<?php
/* ========================================================================
 - [modules/community/bbs/event.php]
 -      新しいイベントを作成する
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/06/17] 書き込み権限追加
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * 表示対象年月日
     * @var string
     */
    var $date = '';

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/bbs/event.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('date', '_GET', 'date');

        /* メンバーではない */
        if (!$this->community['is_member']){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->sid.'/'.$this->ref_community.'/');
            exit();
        }

        /* 編集権限が無い */
        if (!$this->is_editor()){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->sid.'/'.$this->ref_community.'/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/bbs/event/'.$this->sid.'/'.$this->ref_community.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_topic');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();

            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->sid.'/'.$this->ref_community.'/');
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'community/bbs/event/'.$this->sid.'/'.$this->ref_community.'/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        
        $this->set_prefecture();
        $this->set_local();
        $this->set_date();
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return void
     */
    function set_prefecture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['prefecture'];
        }
        
        $this->Assign('prefectures',$list);
    }

    /**
     * 市区町村の設定
     *
     * @access private
     * @return void
     */
    function set_local()
    {
        $ref_prefecture = $this->objmnp->getValue('ref_prefecture');
        $ref_prefecture = empty($ref_prefecture)?$this->objmnp->getInitValue('ref_prefecture'):$ref_prefecture;
        $ref_prefecture = empty($ref_prefecture)?0:$ref_prefecture;

        $sql=
            'SELECT '.
                'id,'.
                'local '.
            'FROM '.
                DB_PREFIX.'ara_local '.
            'WHERE '.
                'ref_prefecture = '.$ref_prefecture.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $list[0] = '市区町村';
        foreach ($result as $value){
            $list[$value['id']] = $value['local'];
        }
        
        $this->Assign('locals', $list);
    }

    /**
     * 日付の設定
     *
     * @access private
     * @return void
     **/
    function set_date()
    {
        $objcal = new RKT_calendar($this->date);
        $timestamp  = $objcal->getTimestamp();

    	$years = array();
    	$months = array();
    	$days = array();

    	$num = date('Y',$timestamp);
    	$max_year = $num + 3;
    	for ($num;$num<$max_year;$num++) {
    		$years[$num] = $num;
    	}
    	for ($num=1;$num<=12;$num++) {
            $num = sprintf('%02d',$num);
    		$months[$num] = $num;
    	}
    	for ($num=1;$num<=31;$num++) {
            $num = sprintf('%02d',$num);
    		$days[$num] = $num;
    	}
    	for ($num=0;$num<=23;$num++) {
            $num = sprintf('%02d',$num);
    		$hours[$num] = $num;
    	}
        $sixty = array(
            '00'=>'00',
            '15'=>'15',
            '30'=>'30',
            '45'=>'45',
        );

        $this->Assign('years', $years);
        $this->Assign('months', $months);
        $this->Assign('days', $days);
        $this->Assign('hours', $hours);
        $this->Assign('sixty', $sixty);

        
        $now_date = date('Y-m-d H:i:s',$timestamp);

        /* 開始年月日: */
        $date = $this->objmnp->getValue('start_date');
        $date = empty($date)?$this->objmnp->getInitValue('start_date'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('start_date', $init_date);

        /* 終了年月日: */
        $date = $this->objmnp->getValue('deadline');
        $date = empty($date)?$this->objmnp->getInitValue('deadline'):$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('deadline', $init_date);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        /* 作成権限 */
        if ($this->community['event_flag'] == PERMISSION_ADMIN){
            if (!$this->base['admin']){
                $this->Assign('permission_denied', true);
                return false;
            }
        } // if ($this->community['event_flag'] == PERMISSION_ADMIN)

        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_community', $this->ref_community);
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('status', STATUS_TOPIC_EVENT);

        $this->objmnp->setInputEffect('comment', array('func'=>array('webapp', 'emojiConvert')));

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * トピックの編集権限
     *
     * @access private
     * @return boolean
     */
    function is_editor()
    {
        if (empty($this->id)){
            return true;
        }
        if ($this->admin){
            return true;
        }

        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'id = '.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return !empty($result['ct']);
    }
} // webapp
?>
