<?php
/* ========================================================================
 - [webapp/libs/wap_friend.php]
 -      friend用WebApplicationクラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/06/15] sql_query.phpのインクルード忘れ修正
 -      [2007/04/13] キリ番メールが連続して送信されるエラー修正
 -      [2007/02/13] 公開レベルを保持
 -      [2006/09/20] $this->base['uri_separator']を追加
 -      [2006/08/28] あしあと処理をメンバ関数に所持
 -      [2006/08/26] 友達情報をメンバ変数に所持
 -      [2006/08/27] ベーステンプレートをコンストラクタで指定
 -      [2006/07/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';
require_once LIB_DIR.'rkt_auth.php';
require_once LIB_DIR.'rkt_webapp.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';

/**
 * friend用WebApplicationクラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package WAP_friend
 * @access public
 * @version 1.0
 */
class WAP_friend extends RKT_webapp
{
    /**
     * アカウント情報
     * @var object
     */
    var $accounts = array();

    /**
     * 友達情報
     * @var object
     */
    var $friend = array();

    /**
     * error情報
     * @var boolean
     */
    var $error = false;

    /**
     * 友達ID
     * @var integer
     */
    var $ref_friend = 0;

    /**
     * アクセスログの挿入結果
     * @var integer
     */
    var $ins_accesslog = false;

    /**
     * 表示公開レベル
     * @var integer
     */
    var $visibility = VISIBILITY_PUBLIC;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function WAP_friend()
    {
        $this->RKT_webapp();
        $this->init_tplargs();

        $objact = account::getInstance();
        $this->account = $objact->getInfo();
        $this->base['account'] = $this->account;

        $this->setTemplateBase('base/friend.tpl');
        $this->base['menu'] = 'menu/friend.tpl';

        $this->addCss('common.css');
        $this->addCss('member.css');
        $this->addCss('friend.css');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_friend');
        if ($this->account['id'] == $this->ref_friend){
            header('Location: '.HTTP_ACTION.'private/home/');
            exit();
        }

        /* 友達情報の設定 */
        $this->set_friend_info();
        if (empty($this->friend['id'])){
            header('Location: '.HTTP_ACTION.'private/home/');
            exit();
        }

        if ($this->breaker()){
            header('Location: '.HTTP_ACTION.'private/home/nobody/');
            exit();
        }
        $this->set_visibility();

        $this->base['ref_friend'] = $this->ref_friend;
        $this->base['friend']     = $this->friend;
        $this->base['visibility'] = $this->visibility;
    }

    /**
     * 実行処理
     *
     * @access public
     **/
    function execute()
    {
    }

    /**
     * 表示処理
     *
     * @access public
     * @return void
     **/
    function display()
    {
        if ($this->error){
            $this->template_file = 'error.tpl';
            error_log('WAP_friend::error();'."\t".
                        $this->objdb->sqlerror."\r\n", 3, ERROR_LOG_FILE);
        }
        $this->mixOutput();
    }

    /**
     * 友達情報の設定
     *
     * @access private
     * @return void
     **/
    function set_friend_info()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'act.email as email,'.
                'act.block as block,'.
                'act.last_login as last_login,'.
                'act.friend_number as friend_number,'.
                'pro.nickname as nickname,'.
                'pro.publicity as publicity,'.
                'sex.sex as sex,'.
                'pht.filename as src,'.
                'pht.width as width,'.
                'pht.height as height,'.
                'pht.thumbnail as t_src,'.
                'pht.t_width as t_width,'.
                'pht.t_height as t_height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->friend = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($this->friend['src'])){
            $this->friend['src']      = NOPHOTO_LARGE;
            $this->friend['width']    = PHOTO_LARGE_SIZE;
            $this->friend['height']   = PHOTO_LARGE_SIZE;
            $this->friend['t_src']    = NOPHOTO_SMALL;
            $this->friend['t_width']  = PHOTO_SMALL_SIZE;
            $this->friend['t_height'] = PHOTO_SMALL_SIZE;
        }
    }

    /**
     * 嫌なユーザーを遮断する
     *
     * @access public
     * @return void
     **/
    function breaker()
    {        
        $blocks = explode("\r\n", $this->friend['block']);
        
        return in_array($this->account['id'], $blocks);
    }


    /**
     * テンプレート引数の初期化
     *
     * @access private
     */
    function init_tplargs()
    {
        $this->base['sid']  = session_id();
        $this->base['url']  = BASE_URL;
        $this->base['http'] = HTTP_ACTION;
        $this->base['ssl']  = SSL_ACTION;

        $this->base['uri_separator']  = htmlspecialchars(WAP_URI_SEPARATOR);
    }

    /**
     * 友達かの判定
     *
     * @access public
     * @return boolean
     */
    function isFriend()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return !empty($result['id']);
    }

    /**
     * あしあと処理
     *
     * @access public
     * @return boolean
     */
    function doFootprint()
    {
        $this->insert_footprint();
        $this->insert_accesslog();
        $this->send_kiriban();
    }

    /**
     * 足跡の挿入
     *
     * @access private
     * @return integer  データ操作結果
     */
    function insert_footprint()
    {
        $to_date = sql_query::toDate('modify');
        $sql = 
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'fri_footprint '.
            'WHERE '.
                $to_date." = '".date('Y-m-d')."' AND ".
                'ref_account = '.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result['id'])){
            $sql =
                'INSERT INTO '.
                    DB_PREFIX.'fri_footprint('.
                        'modify,'.
                        'ref_account,'.
                        'ref_friend '.
                    ') VALUES ('.
                        "'".date('Y-m-d H:i:s')."',".
                        $this->ref_friend.','.
                        $this->account['id'].
                    ')';
        } else {
            $sql =
                'UPDATE '.
                    DB_PREFIX.'fri_footprint '.
                'SET '.
                    "modify = '".date('Y-m-d H:i:s')."' ".
                'WHERE '.
                    'id='.$result['id'];
        }
        return $this->objdb->exec($sql);
    }

    /**
     * アクセスログの挿入
     *
     * @access private
     * @return boolean 正常時：真
     */
    function insert_accesslog()
    {
        $sql = 
            'SELECT '.
                'count(*) as ct '.
            'FROM '.
                DB_PREFIX.'fri_accesslog '.
            'WHERE '.
                "modify > '".date('Y-m-d H:i:s',time()-3600)."' AND ".
                'ref_account = '.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result['ct'])){
            $unique = 1;
            $sql=
                'INSERT INTO '.
                    DB_PREFIX.'fri_accesslog('.
                        'modify,'.
                        'ref_account,'.
                        'ref_friend,'.
                        'unique_flag '.
                    ') VALUES ('.
                        "'".date('Y-m-d H:i:s')."',".
                        $this->ref_friend.','.
                        $this->account['id'].','.
                        "'".$unique."'".
                    ')';
            $this->ins_accesslog = $this->objdb->exec($sql);
        }
    }

    /**
     * 自動通知メール
     *
     * @access private
     * @return void
     */
    function send_mail($footprint)
    {
        if (empty($this->ins_accesslog)){
            return ;
        }
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        include_once WEBAPP_LIB_DIR.'sendmail.php';
        $objmail = new sendmail('footprint');

        $objmail->Assign('footprint', $footprint);
        $objmail->Assign('user_name', $this->friend['nickname']);
        $objmail->Assign('friend', $infos['nickname']);
        $objmail->Assign('url', HTTP_ACTION.'friend/show/profile/'.$this->account['id'].'/');
        
        $to = sql_query::decrypt($this->friend['email']);
        $objmail->send($to);
    }

    /**
     * キリ番訪問のお知らせメール
     *
     * @access private
     * @return void
     */
    function send_kiriban()
    {
        $sql = 
            'SELECT '.
                'act.footprint as footprint,'.
                'act.total as total,'.
                'count(acc.id) as ct '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'fri_accesslog acc '.
                    'ON act.id = acc.ref_account AND '.
                    'acc.unique_flag = 1 '.
            'WHERE '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$this->ref_friend.' '.
            'GROUP BY '.
                'act.id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result['footprint'])){
            return ;
        }

        $total = $result['total'] + $result['ct'];        
        if ($total == $result['footprint']){
            $this->send_mail($result['footprint']);
        }
    }

    /**
     * 公開レベルの設定
     *
     * @access private
     * @return void
     */
    function set_visibility()
    {
        $this->visibility  = VISIBILITY_PUBLIC;
        $this->visibility |= VISIBILITY_PROTECTED;
        $sql=
            'SELECT '.
                'status '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'ref_account ='.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result['status'])){
            return ;
        }

        $this->visibility |= VISIBILITY_FRIEND;
    }

    /**
     * 友達の友達か？
     *
     * @access private
     * @return array
     */
    function is_acquaintance()
    {
        $sql=
            'SELECT '.
                'direct.ref_friend '.
            'FROM '.
                DB_PREFIX.'fri_friends direct,'.
                DB_PREFIX.'fri_friends near '.
            'WHERE '.
                'direct.ref_friend = near.ref_account AND '.
                'direct.avail = '.AVAIL_ENABLE.' AND '.
                'direct.status & '.STATUS_FRIEND_CONNECT.' AND '.
                'direct.ref_account = '.$this->account['id'].' AND '.
                'near.avail = '.AVAIL_ENABLE.' AND '.
                'near.status & '.STATUS_FRIEND_CONNECT.' AND '.
                'near.ref_friend = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['ref_friend'])){
            return false;
        }
        return $result['ref_friend'];
    }

    /**
     * 絵文字エディタ用の初期化設定
     *
     * @access public
     * @return void
     */
    function setEmojiInit()
    {
        $this->addCss('yui_container.css');
        $this->addJavas('YUI/yahoo-min.js');
        $this->addJavas('YUI/event-min.js');
        $this->addJavas('YUI/dom-min.js');
        $this->addJavas('YUI/dragdrop-min.js');
        $this->addJavas('YUI/container-min.js');

        $this->base['javascript'] = empty($this->base['javascript'])?'':$this->base['javascript'];

        $init = 
            'YAHOO.namespace("emoji.container");'."\r\n".
            "\r\n".
            'function init() {'."\r\n".
                'YAHOO.emoji.container.panel = new YAHOO.widget.Panel("emoji_table", { width:"240px", visible:false, constraintoviewport:true } );'."\r\n".
                'YAHOO.emoji.container.panel.render();'."\r\n".
                "\r\n".
                'YAHOO.util.Event.addListener("show", "click", YAHOO.emoji.container.panel.show, YAHOO.emoji.container.panel, true);'."\r\n".
                'YAHOO.util.Event.addListener("hide", "click", YAHOO.emoji.container.panel.hide, YAHOO.emoji.container.panel, true);'."\r\n".
            '}'."\r\n".
            "\r\n".
            'YAHOO.util.Event.addListener(window, "load", init);';
        $this->base['javascript'] .= $init;
    }
}
// WAP_friendの終了
?>
