<?php
/* ========================================================================
 - [modules/private/diary/books.php]
 -      本一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/17] PDFサポート分岐を追加
 -      [2006/09/17] PDFダウンロード用パスを他人から見られないものに変更
 -      [2006/09/14] PDFファイルダウンロード用パスの指定
 -      [2006/09/09] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 削除ID
     * @var integer
     */
    var $delete = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));
        if (!WAP_PDF_SUPPORT){
            header('Location: '.HTTP_ACTION.'private/diary/list/');
            exit();
        }

        $this->setTemplateFile('private/diary/books.tpl');
        $this->addJavas('common.js');

        $this->setSafety('delete');

        if ($this->delete_book()){
            header('Location: '.HTTP_ACTION.'private/diary/books/complete/');
            exit();
        }
        if (preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->account['id']);
        $objmenu->setMenu($this->account['id']);

        $this->set_pdf();
        $this->set_list();
    }

    /**
     * PDFファイル名の設定
     *
     * @access private
     * @return void
     */
    function set_pdf()
    {
        $filename = ACTION_ARCHIVES.ARCHIVES_MEMBER_PATH.'diary_book.pdf';
        if (WAP_DB_DRIVER == 'sqlite'){
            $filename = 'cache'.WAP_ACTION_STYLE.'/diary_book.pdf';
        }

        $this->Assign('pdf_filename', $filename);
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_DIARY);    // クラスの生成
        $sql=
            'SELECT '.
                'id,'.
                'modify,'.
                'created,'.
                'subject,'.
                'comment '.
            'FROM '.
                DB_PREFIX.'dia_book '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'modify DESC ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        if (empty($result)){
            return ;
        }

        $this->Assign('list', $result);
    }

    /**
     * 本・印刷情報の削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_book()
    {
        if (empty($this->delete)){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_book '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'id = '.$this->delete;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
