<?php
/* ========================================================================
 - [htdocs/mobile.php]
 -      携帯用のFront Controller
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/19] アクションページの追加
 -      [2006/08/22] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
include_once BASE_DIR.'mobapp'.DIRECTORY_SEPARATOR.'wap_config.php';

define('WAP_DEFAULT_NUMBER', 5);

/**
 * セッションの開始
 *
 * @access public
 * @return void
 */
function __session_start()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];

    $args   = explode('/',$path_info);
    $session_id = empty($args[4])?null:$args[4];

    if (!preg_match('/'.SESSION_ID_PREFIX.'\w+/',$session_id)){
        $session_id = null;
    }
    if (empty($session_id)){
        $session_id = SESSION_ID_PREFIX.md5(time().$_SERVER['HTTP_USER_AGENT']);
    }

    include_once RKT_INCLUDE_ACCOUNT;
    $func = array(RKT_ACCOUNT_CLASS, 'getInstance');
    $objact = call_user_func($func, $session_id);
}

/**
 * ﾛｸﾞｲﾝ処理
 *
 * @access public
 * @param reference $group
 * @param reference $module
 * @param reference $page
 * @return boolean
 */
function __login_action(&$group,&$module,&$page)
{
    if ($page != 'login'){
        return true;
    }
    include_once LIB_DIR.'rkt_auth.php';

    $objauth = new RKT_auth();
    if (!$objauth->logIn()){
        $group  = 'public';
        $module = 'login';
        $page   = 'entrance';
        $_GET['mismatch'] = 1;
        return false;
    }

    $group  = 'private';
    $module = 'home';
    $page   = 'home';

    if (!empty($_REQUEST['url'])){
        header('Location: '.$_REQUEST['url']);
        exit();
    }
    
    return true;
}

// ------------------------------------------------
// フロントコントローラー
// 引数         なし
// 戻り値       なし
// ------------------------------------------------
function __controller()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];

    $args   = explode('/',$path_info);
    $group  = empty($args[1])?'public':$args[1];
    $module = empty($args[2])?'content':$args[2];
    $page   = empty($args[3])?$module:$args[3];

    __session_start();                      // セッションの開始
    __login_action($group,$module,$page);   // ﾛｸﾞｲﾝ処理

    $titles = array (
        'community'=>   array(
            'bbs'=>         array(      // ﾄﾋﾟｯｸ、ｲﾍﾞﾝﾄ
                'browse'=>      'ﾄﾋﾟｯｸ参照',
                'comment'=>     'ｺﾒﾝﾄを書き込む',
                'entrys'=>      'ｲﾍﾞﾝﾄ参加ﾒﾝﾊﾞｰ一覧',
                'event'=>       '新しいｲﾍﾞﾝﾄを作成する',
                'list'=>        'ﾄﾋﾟｯｸ一覧',
                'send'=>        'ｲﾍﾞﾝﾄ参加者へﾒｯｾｰｼﾞ送信',
                'topic'=>       '新しいﾄﾋﾟｯｸを作成する',
            ),
            'edit'=>        array(      // 各種編集
                'community'=>   'ｺﾐｭﾆﾃｨ基礎情報',
                'entry'=>       'ｺﾐｭﾆﾃｨに参加',
                'exit'=>        'ｺﾐｭﾆﾃｨの退会',
                'intro'=>       '友達に紹介する',
                'names'=>       'ｺﾐｭﾆﾃｨ参加名簿',
            ),
            'item'=>        array(      // ｺﾐｭﾆﾃｨ記事
                'browse'=>      'ｺﾐｭﾆﾃｨ記事閲覧',
                'comment'=>     'ｺﾒﾝﾄ',
                'comments'=>    'ｺﾒﾝﾄ一覧',
                'item'=>        'ｺﾐｭﾆﾃｨ記事',
                'question'=>    'ｱﾝｹｰﾄ結果',
            ),
            'search'=>      array(      // ｺﾐｭﾆﾃｨ検索
                'event'=>       'ｲﾍﾞﾝﾄ検索結果',
                'result'=>      'ｺﾐｭﾆﾃｨ検索結果',
                'schedule'=>    'ｲﾍﾞﾝﾄ検索',
                'search'=>      'ｺﾐｭﾆﾃｨ検索',
            ),
            'show'=>        array(      // ｺﾐｭﾆﾃｨ情報閲覧
                'calendar'=>    'ｺﾐｭﾆﾃｨｲﾍﾞﾝﾄｶﾚﾝﾀﾞｰ',
                'community'=>   'ｺﾐｭﾆﾃｨ情報',
                'home'=>        'ﾎｰﾑ',
                'member'=>      'ﾒﾝﾊﾞｰ一覧',
                'menu'=>        'ｺﾐｭﾆﾃｨメニュー',
            ),
        ), /* ｺﾐｭﾆﾃｨページ */
        'friend'=>   array(
            'diary'=>       array(      // 友達日記
                'comment'=>     'ｺﾒﾝﾄを書く',
                'comments'=>    'ｺﾒﾝﾄ一覧',
                'entry'=>       '日記',
                'list'=>        '日記一覧',
                'result'=>      '日記検索結果',
                'search'=>      '日記検索',
            ),
            'edit'=>        array(      // 各種編集
                'favorite'=>    'お気に入り追加',
                'intro'=>       '紹介文編集',
                'message'=>     'ﾒｯｾｰｼﾞを送る',
                'relation'=>    '友達追加',
            ),
            'forum'=>       array(      // フォーラム
                'browse'=>      'ﾄﾋﾟｯｸ参照',
                'comment'=>     'ｺﾒﾝﾄを書き込む',
                'list'=>        'ﾄﾋﾟｯｸ一覧',
                'result'=>      'ﾄﾋﾟｯｸ検索結果',
                'search'=>      'ﾄﾋﾟｯｸ検索',
            ),
            'search'=>      array(      // 友達検索
                'result'=>      '友達検索結果',
                'search'=>      '友達検索',
            ),
            'show'=>        array(      // 友達情報閲覧
                'community'=>   'ｺﾐｭﾆﾃｨ一覧',
                'friends'=>     '友達一覧',
                'home'=>        'ﾎｰﾑ',
                'intro'=>       '紹介文一覧',
                'menu'=>        'お友達メニュー',
                'photo'=>       '写真一覧',
                'profile'=>     'ﾌﾟﾛﾌｨｰﾙ',
                'recent'=>      '各種一覧表示',
                'review'=>      '投稿ﾚﾋﾞｭｰ一覧表示',
            ),
         ), /* 友達ページ */
        'private'=>   array(
            'account'=>     array(      // 会員情報
                'account'=>     '会員基礎情報',
                'autologin'=>   '自動ﾛｸﾞｲﾝ登録',
                'exit'=>        '退会処理',
                'passwd'=>      'ﾊﾟｽﾜｰﾄﾞ変更',
            ),
            'content'=>     array(      // ｺﾝﾃﾝﾂ閲覧
                'browse'=>      'ｺﾝﾃﾝﾂ記事閲覧',
                'inquire'=>     '問合せﾌｫｰﾑ',
                'list'=>        'お知らせ一覧',
                'question'=>    'ｱﾝｹｰﾄ結果',
            ),
            'diary'=>       array(      // 日記
                'category'=>    'カテゴリ',
                'comment'=>     'ｺﾒﾝﾄを書く',
                'comments'=>    'ｺﾒﾝﾄ一覧',
                'diary'=>       '日記設定',
                'entry'=>       '記事閲覧',
                'list'=>        '日記一覧',
                'post'=>        '日記記事投稿',
            ),
            'edit'=>        array(      // 各種編集
                'community'=>   '参加ｺﾐｭﾆﾃｨ一覧',
                'friend'=>      '友達ﾘｽﾄ管理',
                'photo'=>       '写真編集',
                'profile'=>     'ﾌﾟﾛﾌｨｰﾙ編集',
                'relation'=>    '各種認証',
                'schedule'=>    'ｽｹｼﾞｭｰﾙ編集',
            ),
            'forum'=>       array(      // フォーラム
                'browse'=>      'ﾄﾋﾟｯｸ閲覧',
                'comment'=>     'ｺﾒﾝﾄを書き込む',
                'list'=>        'ﾄﾋﾟｯｸ一覧',
                'response'=>    '返事を書く',
                'topic'=>       'ﾄﾋﾟｯｸ編集',
            ),
            'home'=>        array(      // Myﾎｰﾑ
                'home'=>        'Myﾎｰﾑ',
                'menu'=>        'Myﾎｰﾑ',
                'mail_action'=> 'ﾒｰﾙ画像添付反映',
                'invite'=>      '友達招待ﾌｫｰﾑ',
                'search'=>      '各種検索',
                'recent'=>      '各種一覧表示',
            ),
            'message'=>     array(      // ﾒｯｾｰｼﾞ
                'browse'=>      'ﾒｯｾｰｼﾞ閲覧',
                'list'=>        'ﾒｯｾｰｼﾞﾎﾞｯｸｽ',
                'send'=>        'ﾒｯｾｰｼﾞを送る',
            ),
            'review'=>      array(      // ﾚﾋﾞｭｰ
                'browse'=>      '商品ﾚﾋﾞｭｰ閲覧',
                'item'=>        'ﾚﾋﾞｭｰ対象商品検索',
                'list'=>        '投稿ﾚﾋﾞｭｰ一覧表示',
                'post'=>        'ﾚﾋﾞｭｰ投稿',
                'search'=>      '投稿ﾚﾋﾞｭｰ検索',
            ),
            'show'=>        array(      // 各種閲覧
                'calendar'=>    'ｶﾚﾝﾀﾞｰ',
                'favorite'=>    'お気に入り',
                'footprint'=>   'あしあと',
                'friends'=>     '友達一覧',
                'intro'=>       '紹介文一覧',
                'profile'=>     'ﾌﾟﾛﾌｨｰﾙ確認',
                'schedule'=>    'ｽｹｼﾞｭｰﾙ確認',
            ),
        ), /* プライベートページ */
        'public'=>   array(
            'content'=>     array(      // ｺﾝﾃﾝﾂ記事
                'browse'=>      'ｺﾝﾃﾝﾂ記事閲覧',
                'default'=>     WAP_SYSTEM_NAME,
                'inquire'=>     '問合せﾌｫｰﾑ',
            ),
            'login'=>       array(      // ﾛｸﾞｲﾝ
                'entrance'=>    'ﾛｸﾞｲﾝﾌｫｰﾑ',
                'exit'=>        '退会ﾍﾟｰｼﾞ',
                'login'=>       'ﾛｸﾞｲﾝ',
                'logout'=>      'ﾛｸﾞｱｳﾄ',
                'reissue'=>     'ﾊﾟｽﾜｰﾄﾞの再発行',
            ),
            'registry'=>    array(      // 会員登録
                'account'=>     '会員登録ﾌｫｰﾑ',
                'confirm'=>     '入力内容確認',
                'invite'=>      '自動招待ﾌｫｰﾑ',
                'registry'=>    '会員登録',
                'sendmail'=>    '会員登録確認ﾒｰﾙ発送',
            ),
        ), /* 一般公共ページ */
    );

    /* デフォルト読み込みモジュール */
    $include = 'public/content/default.php';
    /* テンプレートファイルの読み込み */
    if (empty($titles[$group][$module][$page])){
        $group  = 'public';
        $module = 'content';
        $page   = 'default';
    }
    $include = $group.'/'.$module.'/'.$page.'.php';

    include_once MODULE_DIR.$include;

    header('Content-Type: text/html; charset=Shift_JIS');
    $obj_webapp = new webapp();
    $obj_webapp->baseAssign('title', $titles[$group][$module][$page]);
    $obj_webapp->execute();
    $obj_webapp->display();

    if (DEBUG_ENV == 1){
        echo "<div id=\"left\">\n";
        echo "<pre style=\"text-align:left;\">".print_r($_REQUEST,true)."</pre>";
        echo "<pre style=\"text-align:left;\">".print_r($_SESSION,true)."</pre>";
        echo "<pre style=\"text-align:left;\">".print_r($_COOKIE,true)."</pre>";
        echo "</div>\n";
    }
}
?>
