<?php
/* ========================================================================
 - [htdocs/resource/html/dia_category.php]
 -      カテゴリ
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/07/09] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once '../../../sns_config.php';
require_once LIB_DIR.'rkt_session.php';
require_once BASE_DIR.'webapp'.DIRECTORY_SEPARATOR.'wap_config.php';
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

define('WAP_DEFAULT_NUMBER', 4);

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 日記ID
     * @var integer
     */
    var $ref_diary = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->set_diary();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'dia_category');
        $result = $this->do_query();
        if ($result != RKT_MANIP_COMPLETE){
            return false;
        }
        $id = $this->objmnp->getCurID();

        return $id;
    }

    /**
     * 日記情報の取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function set_diary()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->ref_diary = $result['id'];
    }

    /**
     * カテゴリ順番の取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function get_sort()
    {
        $sql=
            'SELECT '.
                'max(sort) as sort '.
            'FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return empty($result['sort'])?1:$result['sort']+1;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_diary', $this->ref_diary);
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('sort', $this->get_sort());

        // 更新しない項目名
        $skip = array(
            'ref_account',
            'sort',
        );
        $this->objmnp->catchInput($skip);
        return $this->objmnp->doManip($this);
    }
} // webapp

/* セッションハンドル設定 */
RKT_session::setSaveHandler();

header('Content-Type: text/html; charset='.ENCODE_TYPE);
$obj_webapp = new webapp();
$ref_category = $obj_webapp->execute();

print('<?xml version="1.0" encoding="utf-8"?>'."\r\n"); 
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="content-type" content='text/html; charset="utf-8"' />
<style type="text/css">
<!--
BODY	{
    margin: 0;
    padding: 0;
}
AREA	{
	cursor: pointer;
	cursor: hand;
}
-->
</style>
<?php if ($ref_category): ?>
<script src="<?php echo BASE_URL; ?>resource/js/prototype.js" type="text/javascript"></script>
<script language="javascript" type="text/javascript">
function insertCategory () {
    var node  = parent.document.getElementById('categorys');
    var label = document.createElement('label');
    var input = document.createElement('input');
    var br    = document.createElement('br');
    var subject  = document.createTextNode('<?php echo $_POST['category']; ?>');

	input.setAttribute('type','checkbox');
	input.setAttribute('name','dia_select[<?php echo $ref_category; ?>]');
	input.value = '<?php echo $_POST['category']; ?>';
	label.appendChild(input);
	label.appendChild(subject);

	node.appendChild(label);
	node.appendChild(br);

	parent.YAHOO.category.container.panel.hide();
    return 0;
}
</script>
</head>
<body onload="insertCategory();">
<?php else: ?>
</head>
<body>
<?php endif; ?>
<form name="edit" method="post" action="<?php echo BASE_URL; ?>resource/html/dia_category.php">
    <table style="width:230px;" align="center" cellpadding="4" cellspacing="0"><tbody>
    	<tr>
    		<td style="text-align:right;"><input type="text" id="category" name="category" value="" size="40" maxlength="128" style="ime-mode:active" /></td>
    	</tr>
    	<tr>
    		<td style="text-align:center;"><input type="submit" name="manip" value="内容を送信" style="width:120px;" /></td>
    	</tr>
    </tbody></table>
</form>
</body>
<html>
