<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty wordwrap modifier plugin
 *
 * Type:     modifier<br>
 * Name:     rkt_strimwidth<br>
 * Purpose:  width a string of text at a given length
 * Examples:
 * <pre>
 * {$string|rkt_strimwidth}
 * {$string|rkt_strimwidth:20}
 * {$string|rkt_strimwidth:20:'...'}
 * {$string|rkt_strimwidth:20:'...':'utf-8'}
 * </pre>
 * @link http://jp.php.net/manual/ja/function.mb-strimwidth.php
 *          rkt_strimwidth
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @param string
 * @param integer
 * @param string
 * @param string
 * @return string
 */
function smarty_modifier_rkt_strimwidth($string,$length=200,$trimmarker="....",$encoding=NULL)
{
    $string = str_replace('<BR>',"\r\n",$string);
    $string = str_replace('<br>',"\r\n",$string);
    $string = strip_tags($string);

    return mb_strimwidth($string, 0, $length, $trimmarker);
}

/**
 * sł悤chunk
 *
 * @access public
 * @param string $string
 * @return string
 */
function __rkt_chunk_split_wbr($string)
{
    $length = mb_strlen($string);
    
    $result = '';
    $start = 0;
    
    $chunk = RKT_CHUNK_NUMBER;
    while ($length > 0){
        if ($length < RKT_CHUNK_NUMBER){
            $chunk = $length;
        }
        
        $result .= mb_substr($string, $start, $chunk);
        $result .= '<wbr>';

        $start  += RKT_CHUNK_NUMBER;
        $length -= RKT_CHUNK_NUMBER;
    }

    return $result;
}
?>
