<?php
/* ========================================================================
 - [libs/rktManip/manip_mysql.php]
 -      rkt_manip(ulation).php MySQLドライバ
 -      Copyright (c) 2005-2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/06/08]    全テーブル名の取得関数追加
 -      [2007/03/11]    入力データのエスケープ処理指定を追加
 -      [2005/06/01]    コンストラクタ引数変更、DB接続オジェクトを追加
 -      [2005/05/11]    作成
 - ======================================================================== */

/**
 * manipulation MySQLドライバ
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_mysql
 * @access public
 * @version 1.0
 */
class manip_mysql
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * テーブル名
     * @var string
     */
    var $tbl_name = '';

    /**
     * プライマリキー
     * @var array
     */
    var $primary = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param object $objdb    データベースオブジェクト
     * @param string $tbl_name テーブル名
     */
    function manip_mysql(&$objdb, $tbl_name='')
    {
        $this->objdb =& $objdb;

        $this->tbl_name = $tbl_name;
    }

    /**
     * テーブル名の設定
     *
     * @access public
     * @param string $tbl_name
     * @return void
     */
    function setTableName($tbl_name)
    {
        $this->tbl_name = $tbl_name;
    }

    /**
     * プライマリキーの取得
     *
     * @access public
     * @return string
     */
    function getPrimaryKey()
    {
        return $this->primary['key'];
    }

    /**
     * 全テーブル名の取得
     *
     * @access public
     * @return array
     */
    function getTables()
    {
        $stmt = $this->objdb->prepare('SHOW TABLES'); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_NUM);

        $list = array();
        foreach ($result as $value){
            $list[] = $value[0];
        }

        return $list;
    }

    /**
     * 項目情報の解析
     *
     * @access public
     * @param array $skip
     * @return array
     */
    function parseColumns($skip=array())
    {
        $sql=
            'SHOW '.
                'COLUMNS '.
            'FROM '.
                $this->tbl_name;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $validates = array();
        foreach ($result as $value){
            $key  = $value['Field'];
            $parse = $this->parse_type($value['Type'],$key);
            $infos = array(
                'type'=>    $parse['type'],
                'pdo_type'=>$parse['pdo_type'],
                'option'=>  $parse['option'],
                'required'=>$this->parse_required($value['Null']),
                'effect'=>  array('RKT_validate', 'escape_character'),
            );

            /* プライマリキーは別扱い */
            if ($this->is_primary_key($value['Key'])){
                $this->primary = array(
                    'key'=>  $key,
                    'info'=> $infos
                );
            } else {
                if (!in_array($key,$skip)){
                    $validates[$key] = $infos;
                }
            } // if (!$this->catch_primary_key($value['Key']))
        }

        return $validates;
    }

    /**
     * フィールドの型を解析
     *
     * @access public
     * @param string $subject
     * @param string $option
     * @return array
     */
    function parse_type($subject,$field)
    {
        $type = 'string';
        $pdo_type = PDO_PARAM_STR;
        $option = null;
        $size = 8000;
        if (preg_match("/\d+/i",$subject,$matchs)){
            $size = $matchs[0];
        }

        /* 型名から設定 */
        if (preg_match("/varchar/i",$subject)){
            $type = 'string';
            $option = array(
                'max_length'=>$size
            );
        } else if (preg_match("/int/i",$subject)){
            $type = 'number';
            $pdo_type = PDO_PARAM_INT;
        } else if (preg_match("/text/i",$subject)){
            $type = 'string';
            $option = array(
                'max_length'=>$size
            );
        } else if (preg_match("/date/i",$subject)){
            $type = 'date';
            $option = array(
                'format'=> '%Y-%n-%d'
            );
        } else if (preg_match("/timestamp/i",$subject)){
            $type = 'date';
            $option = array(
                'format'=> '%Y-%n-%d %H:%i:%s'
            );
        } else if (preg_match("/float/i",$subject)){
            $type = 'number';
            $pdo_type = PDO_PARAM_INT;
            $option = array(
                'decimal'=>'.'
            );
        } else if (preg_match("/double/i",$subject)){
            $type = 'number';
            $pdo_type = PDO_PARAM_INT;
            $option = array(
                'decimal'=>'.'
            );
        } else if (preg_match("/blob/i",$subject)){
            $type = 'string';
            $pdo_type = PDO_PARAM_LOB;
            $option = array(
                'max_length'=>$size
            );
        }
        
        /* フィールド名から設定 */
        if (preg_match("/email/i",$field)){
            $type = 'email';
        } else if (preg_match("/url/i",$field)){
            $type = 'uri';
        } else if (preg_match("/postal/i",$field)){
            $type = 'string';
            $option = array(
                'format'=>'\d+[-]*\d+'
            );
        } else if (preg_match("/phone/i",$field)){
            $type = 'string';
            $option = array(
                'format'=>'\d+[-]*\d+[-]*\d+'
            );
        } else if (preg_match("/fax/i",$field)){
            $type = 'string';
            $option = array(
                'format'=>'\d+[-]*\d+[-]*\d+'
            );
        } else if (preg_match("/password/i",$field)){
            $type = 'string';
            $option = array(
                'format'=> '\w+',
                'min_length'=>4,
                'max_length'=>$size
            );
        }
        
        return array('type'=>$type, 'pdo_type'=>$pdo_type, 'option'=>$option);
    }

    /**
     * 必須項目設定の解析
     *
     * @access public
     * @param string $subject
     * @return array
     */
    function parse_required($subject)
    {
        $required = true;
        if (preg_match("/YES/i",$subject)){
            $required = false;
        }

        return $required;
    }

    /**
     * プライマリキーの判定
     *
     * @access public
     * @param string $subject
     * @return array
     */
    function is_primary_key($subject)
    {
        if (!preg_match("/PRI/i",$subject)){
            return false;
        }
        return true;
    }
} // manip_mysqlの終了
?>