<?php
/* ========================================================================
 - [libs/rkt_account.php]
 -      アカウント（状態）管理クラス
 -      Copyright (c) 2004 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 注意事項:
 -      PHP4用の古いバージョンではRKT_accountを継承して使う事が出来ません。
 -      serialize()関数が継承に対応していません。
 - 更新履歴：
 -      [2004/05/20] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';

/**
 * アカウント管理クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_account
 * @access public
 * @version 1.1
 */
class RKT_account
{
    /**
     * アカウント情報
     * @var array
     */
    var $infos = array();

    /**
     * インスタンス生成
     *
     * @access public
     */
    function &getInstance($id=null)
    {
        $session_id = empty($id) ? session_id():session_id($id);

        if (!$session_id){
            session_start();
        }
        if (!isSet($_SESSION['account'])) {
            $_SESSION['account'] = new RKT_account();
        }
        return $_SESSION['account'];
    }

    /**
     * コンストラクタ
     *
     * @access public
     */
    function RKT_account()
    {
        $this->infos = array(
            'id'       => 0,
            'name'     => '',
            'status'   => RKT_ACC_DEFAULT,
            'password' => false
        );
    }

    /**
     * アカウント削除
     *
     * @access public
     */
    function accountDestroy()
    {
        unset($_SESSION['account']);

        /* セッションファイルの削除 */
        $path = session_save_path();
        $filename = $path."sess_".session_id();

        if (is_file($filename)){
            @unlink($filename);
        }
    }

    /**
     * セッションIDの取得
     *
     * @access public
     * @return string セッションID
     */
    function getSessionID()
    {
        return session_id();
    }

    /**
     * アカウントIDの取得
     *
     * @access public
     * @return integer アカウントID
     */
    function getAccountID()
    {
        return $this->infos['id'];
    }

    /**
     * 管理者権限の有無
     *
     * @access public
     * @return boolean 管理者権限の有無
     */
    function isAdmin()
    {
        if ($this->infos['status'] != RKT_ACC_ADMIN){
            return false;
        }

        return true;
    }

    /**
     * 状態の取得
     *
     * @access public
     * @return string 状態
     */
    function getStatus()
    {
        return $this->infos['status'];
    }

    /**
     * ユーザー情報を取得しメンバ変数へ
     *
     * @access public
     * @param integer $id
     * @return boolean 正常時：真
     */
    function setInfo($id)
    {
        $objdb = RKT_db::getInstance();
        $sql=
            'SELECT '.
                'id,'.
                'status,'.
                'name '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'id = '.$id;
        $stmt = $objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        if (empty($result)){
            return false;
        }

        $this->infos = array(
            'id'       => $result['id'],
            'status'   => $result['status'],
            'name'     => $result['name'],
        );

        /* PHP4用セッションの中身を更新 */
        $_SESSION['account'] = $this;

        return true;
    }

    /**
     * ユーザー情報の取得
     *
     * @access public
     * @return array ユーザー情報
     */
    function getInfo($key=null)
    {
        if (empty($key)){
            return $this->infos;        
        }
        return $this->infos[$key];
    }
} // RKT_accountの終了
?>
