<?php
/* ========================================================================
 - [libs/rkt_image.php]
 -      画像処理クラス
 -      Copyright (c) 2005 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 注意事項:
 -      GIF生成モジュールが使えない場合はImageGifをImagePNGに変更してください。
 - 更新履歴：
 -      [2005/08/20] 作成
 - ======================================================================== */

/**
 * 画像処理クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_upimage
 * @access public
 * @version 1.1
 */
class RKT_image
{
    /**
     * DRIVER
     * @access private
     * @var string
     */
    var $driver = 'gd';

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $driver
     * @return void
     */
    function RKT_image($driver='gd')
    {        
        $this->driver = $driver;
    }

    /**
     * 画像処理クラスの作成
     *
     * @access public
     * @param string $driver
     * @param string $filename
     * @return object イメージ操作オブジェクト
     */
    function &factory($driver='gd', $filename=null)
    {
        include_once LIB_DIR.'rktImage/rkt_'.$driver.'.php';

        $classname = 'RKT_'.$driver;

        @$objimg =& new $classname($filename);

        return $objimg;
    }

    /**
     * 画像の読み込み
     *
     * @access public
     * @param string $driver
     * @param string $filename
     * @return object イメージ操作オブジェクト
     */
    function &readImage($driver='gd', $filename)
    {
        include_once LIB_DIR.'rktImage/rkt_'.$driver.'.php';

        $classname = 'RKT_'.$driver;

        @$objimg =& new $classname($filename);

        return $objimg;
    }

    /**
     * 画像バイナリデータの設定
     *
     * @access public
     * @param string $driver
     * @param binary $binary 画像バイナリデータ
     * @param string $format フォーマット
     * @return boolean
     */
    function &setBinary($driver='gd', $binary, $format)
    {
        include_once LIB_DIR.'rktImage/rkt_'.$driver.'.php';

        $classname = 'RKT_'.$driver;

        @$objimg =& new $classname();
        
        $objimg->setBinary($binary, $format);

        return $objimg;
    }
} // RKT_image
?>