<?php
/* ========================================================================
 - [modules/community/item/item.php]
 -      コミュニティ記事
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/19] メールによる画像添付機能追加
 -      [2007/06/17] 書き込み権限追加
 -      [2007/02/13] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * 表示対象年月日
     * @var string
     */
    var $date = '';

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 添付画像を送信
     * @var integer
     */
    var $attach = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/item/item.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('date', '_GET', 'date');

        /* メンバーではない */
        if (!$this->community['is_member']){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->sid.'/'.$this->ref_community.'/');
            exit();
        }

        /* 編集権限が無い */
        if (!$this->is_editor()){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->sid.'/'.$this->ref_community.'/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/item/item/'.$this->sid.'/'.$this->ref_community.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        $this->set_attach();            // 画像添付フラグの設定

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_topic');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();

            $this->mail_action();
            unset($_SESSION['attach']);

            header('Location: '.HTTP_ACTION.'community/item/item/'.$this->sid.'/'.$this->ref_community.'/complete/'.WAP_URI_SEPARATOR.'id='.$this->id.'&attach='.$this->attach);
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            $_SESSION['attach'] = $this->attach;
            header('Location: '.HTTP_ACTION.'community/item/item/'.$this->sid.'/'.$this->ref_community.'/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
    }

    /**
     * 本文のフォーマット
     *
     * @access public
     * @param string $value
     * @return string
     */
    function format_comment($string)
    {
        $pattern  = '<img src="'.preg_quote(BASE_URL.'resource/img/emoji/','/');
        $pattern .= '(\d+).gif" class\="emoji"(\s\/)?>';
        $string = preg_replace('/'.$pattern.'/i', '[m:\1]', $string);

        $string = preg_replace('/<p>/i', '', $string);
        $string = preg_replace('/<\/p>/i', '<br />', $string);

        $string = preg_replace('/<div>/i', '', $string);
        $string = preg_replace('/<\/div>/i', '<br />', $string);

        return $string;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        /* 作成権限 */
        if ($this->community['item_flag'] == PERMISSION_ADMIN){
            if (!$this->base['admin']){
                $this->Assign('permission_denied', true);
                $this->permission = false;
                return false;
            }
        } // if ($this->community['item_flag'] == PERMISSION_ADMIN)

        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
            $this->objmnp->setValue('post', 0);
            $this->objmnp->setValue('status', STATUS_TOPIC_ITEM);
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_community', $this->ref_community);
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_prefecture', 0);
        $this->objmnp->setValue('start_date', date('Y-m-d'));

        /* 入力データの加工設定 */
        $func = array('webapp', 'format_comment');
        $this->objmnp->setInputEffect('comment', array('func'=>$func, 'key'=>'comment'));

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
            'status',
            'start_hour',
            'start_minute',
            'local',
            'post',
            'comment',
            'sub_locale',
            'deadline',
        );

        /* 入力条件を指定 */
        $validates = array(
            'comment'=> array(
                'type'=>    'string',
                'option'=>  null,
                'required'=>true,
                'effect'=>  array('RKT_validate', 'strip_slashes'),
            ),
        );
        return $this->objmnp->execute($this,$skip,$validates);
    }

    /**
     * トピックの編集権限
     *
     * @access private
     * @return boolean
     */
    function is_editor()
    {
        if (empty($this->id)){
            return true;
        }
        if ($this->admin){
            return true;
        }

        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'id = '.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return !empty($result['ct']);
    }

    /******************************************************/
    /**************    メールアクション     ***************/
    /******************************************************/
    /**
     * 画像添付フラグの設定
     *
     * @access private
     * @return array
     */
    function set_attach()
    {
        if (isSet($_POST['attach'])){
            $this->attach = empty($_POST['attach'])?array():$_POST['attach'];
            return ;
        }
        if (isSet($_SESSION['attach'])){
            $this->attach = empty($_SESSION['attach'])?array():$_SESSION['attach'];
            return ;
        }
        if (isSet($_GET['attach'])){
            $this->attach = empty($_GET['attach'])?array():$_GET['attach'];
            return ;
        }
        if (preg_match('/(manip|confirm|edit)/i',$_SERVER['REQUEST_URI'])){
            return ;
        }
    }

    /**
     * メールアクション設定
     *
     * @access private
     * @return integer  データ操作結果
     */
    function mail_action()
    {
        if (empty($this->attach)){
            return false;
        }
        $ref_relation = $this->objmnp->getCurID();

        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_mailaction');

        $objmnp->setValue('modify',        date('Y-m-d H:i:s'));
        $objmnp->setValue('ref_table',     ACTION_COM_TOPIC);
        $objmnp->setValue('ref_relation',  $ref_relation);
        $objmnp->setValue('ref_account',   $this->account['id']);
        $objmnp->setValue('ref_addition',  $this->ref_community);

        return $objmnp->manip();
    }
} // webapp
?>
