<?php
/* ========================================================================
 - [modules/friend/show/home.php]
 -      プロフィール
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/16] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/show/home.tpl');

        $this->set_friend_number();
        $this->set_photo();
        $this->set_profile();
        $this->set_friend();
        $this->set_community();
        $this->set_community_number();

        $this->set_diary();
        $this->set_review();
        $this->set_forum();
        $this->Assign('news', $this->news);

        $this->doFootprint();
    }

    /**
     * 友達数の設定
     *
     * @access private
     * @return void
     */
    function set_friend_number()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('friend_num',$result['ct']);
    }

    /**
     * 写真の設定
     *
     * @access private
     * @return void
     */
    function set_photo()
    {
        $sql=
            'SELECT '.
                'id,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'status = '.STATUS_PHOTO_MAIN.' AND '.
                'ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            $result = array(
                'id'=> null,
                'src'=>    'resource/img/common/nophoto.gif',
                'width'=>  PHOTO_SMALL_SIZE,
                'height'=> PHOTO_SMALL_SIZE
            );
        }

        $this->Assign('photo',$result);
    }

    /**
     * フラグの設定
     *
     * @access private
     * @return void
     */
    function set_flag(&$value)
    {
        $is_friend = $this->isFriend();
        $flag = array();

        $flag = ($value['prefecture_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['prefecture_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['prefecture_flag'] = $flag;

        $flag = ($value['blood_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['blood_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['blood_flag'] = $flag;

        $flag = ($value['birthday_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['birthday_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['birthday_flag'] = $flag;

        $flag = ($value['age_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['age_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['age_flag'] = $flag;

        $flag = ($value['married_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['married_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['married_flag'] = $flag;

        $flag = ($value['hometown_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['hometown_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['hometown_flag'] = $flag;
    }

    /**
     * プロフィールの設定
     *
     * @access private
     * @return void
     */
    function set_profile()
    {
        $sql=
            'SELECT '.
                'pro.id as id,'.
                'pro.ref_account as ref_account,'.
                'pro.modify as modify,'.
                'pro.first_name as first_name,'.
                'pro.second_name as second_name,'.
                'pro.name_flag as name_flag,'.
                'pro.nickname as nickname,'.
                'pro.prefecture_flag as prefecture_flag,'.
                'pro.ref_blood as ref_blood,'.
                'pro.blood_flag as blood_flag,'.
                'pro.birthday as birthday,'.
                'pro.birthday_flag as birthday_flag,'.
                'pro.age_flag as age_flag,'.
                'pro.married_flag as married_flag,'.
                'pro.hometown_flag as hometown_flag,'.
                'pro.publicity as publicity,'.
                'prf.prefecture as prefecture,'.
                'lcl.local as local,'.
                'sex.sex as sex,'.
                'pro.sex_flag as sex_flag,'.
                'bld.blood as blood,'.
                'mrd.married as married,'.
                'htn.prefecture as hometown,'.
                'hlc.local as homelocal '.
            'FROM '.
                DB_PREFIX.'act_profile pro '.
                    'LEFT JOIN '.DB_PREFIX.'act_blood bld '.
                    'ON bld.id = pro.ref_blood '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture prf '.
                    'ON prf.id = pro.ref_prefecture '.
                    'LEFT JOIN '.DB_PREFIX.'ara_local lcl '.
                    'ON lcl.id = pro.ref_local '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture htn '.
                    'ON htn.id = pro.ref_hometown '.
                    'LEFT JOIN '.DB_PREFIX.'ara_local hlc '.
                    'ON hlc.id = pro.ref_homelocal,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_married mrd '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'sex.id = pro.ref_sex AND '.
                'mrd.id = pro.ref_married AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'pro.ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            header('Location: '.HTTP_ACTION.'private/home/menu/'.$this->sid.'/');
            exit();
        }
        
        $this->set_flag($result);

        $this->Assign('profile',$result);
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = fri.ref_friend AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'act.last_login DESC '.
            'LIMIT 6';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $this->Assign('friends', $result);
    }

    /**
     * コミュニティの設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.community as community,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'com_names nms '.
            'WHERE '.
                'com.id = nms.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                sql_query::bitFlag('nms.status & '.STATUS_COMMUNITY_MEMBERS).' AND '.
                'nms.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'nms.modify '.
            'LIMIT 6';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            $this->Assign('communitys', null);
            return ;
        }

        $this->Assign('communitys', $result);
    }

    /**
     * コミュニティ数の設定
     *
     * @access private
     * @return void
     */
    function set_community_number()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_account = '.$this->ref_friend. ' AND '.
                sql_query::bitFlag('status & '.STATUS_COMMUNITY_MEMBERS);
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('community_num',$result['ct']);
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_diary()
    {
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'ent.regist_date as modify,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                sql_query::bitFlag('ent.visibility & '.$this->visibility).' AND '.
                'dia.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'ent.regist_date DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        $this->news = true;

        $this->Assign('diarys', $result);
    }

    /**
     * レビューの設定
     *
     * @access private
     * @return void
     */
    function set_review()
    {
        $sql = 
            'SELECT '.
                'itm.id as id,'.
                'itm.name as name,'.
                'rev.modify as modify '.
            'FROM '.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev '.
            'WHERE '.
                'itm.id = rev.ref_item AND '.
                'rev.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'rev.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        $this->news = true;

        $this->Assign('reviews', $result);
    }

    /**
     * Myフォーラムの新トピック
     *
     * @access private
     * @return void
     */
    function set_forum()
    {
        $sql=
            'SELECT '.
                'id,'.
                'modify,'.
                'post,'.
                'topic '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->ref_friend.' AND '.
                sql_query::bitFlag('visibility & '.$this->visibility).' '.
            'ORDER BY '.
                'modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        $this->news = true;

        $this->Assign('forums', $result);
    }

    /**
     * 紹介文の設定
     *
     * @access private
     * @return void
     */
    function set_intro()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'itr.ref_friend as ref_friend,'.
                'itr.relation as relation,'.
                'itr.comment as comment,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_intro itr '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = itr.ref_friend AND '.
                'itr.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'itr.modify '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $this->Assign('intros', $result);
    }
} // webapp
?>
