<?php
/* ========================================================================
 - [modules/private/diary/comment.php]
 -      記事閲覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/13] 日記コメント投稿数を記事に保存
 -      [2007/02/13] 日記コメント投稿が機能していないエラーを修正
 -      [2006/07/25] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 記事ID
     * @var object
     */
    var $ref_entry = null;

    /**
     * 日記ID
     * @var object
     */
    var $ref_diary = null;

    /**
     * 削除コメントID
     * @var object
     */
    var $delete = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/diary/comment.tpl');

        /* URL引数の取得 */
        $this->setSafety('ref_entry');
        $this->Assign('ref_entry', $this->ref_entry);
        $this->setSafety('delete');

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/diary/comment/'.$this->sid.'/again/'.WAP_URI_SEPARATOR.'ref_entry='.$this->ref_entry);
            exit();
        }

        $this->set_diary();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'dia_comment');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->update_entry();
            header('Location: '.HTTP_ACTION.'private/diary/comments/'.$this->sid.'/'.$this->ref_entry.'/complete/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/diary/comment/'.$this->sid.'/confirm/'.WAP_URI_SEPARATOR.'ref_entry='.$this->ref_entry);
            exit();
        }


        /* コメントの削除 */
        if ($this->delete_comment()){
            $this->update_entry();
            $this->Assign('deleted', true);
        }

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->account['id']);
        $objmenu->setMenu($this->account['id']);

        $this->set_picture();
        $this->set_category();
        $this->set_comment_num();
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_diary()
    {
        $sql=
            'SELECT '.
                'id,'.
                'modify,'.
                'ref_diary,'.
                'regist_date,'.
                'visibility,'.
                'link,'.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'id = '.$this->ref_entry.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result)){
            header('Location: '.HTTP_ACTION.'private/diary/list/'.$this->sid.'/');
            exit();
        }
        
        $this->ref_diary = $result['ref_diary'];
        $this->Assign('entry', $result);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @return void
     */
    function set_picture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$this->ref_entry.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('pictures', $result);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql = 
            'SELECT '.
                'cat.id as id,'.
                'count(ref.ref_entry) as ct,'.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'dia_category cat,'.
                DB_PREFIX.'dia_select ref,'.
                DB_PREFIX.'dia_select sel '.
            'WHERE '.
                'cat.id = ref.ref_category AND '.
                'cat.id = sel.ref_category AND '.
                'cat.ref_diary = '.$this->ref_diary.' AND '.
                'sel.ref_entry = '.$this->ref_entry.' '.
            'GROUP BY '.
                'cat.id,'.
                'cat.category,'.
                'sel.ref_category '.
            'ORDER BY '.
                'cat.sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('categorys', $result);
    }

    /**
     * コメント数の設定
     *
     * @access private
     * @return void
     */
    function set_comment_num()
    {
        $sql=
            'SELECT '.
                'post '.
            'FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'id = '.$this->ref_entry.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $comment_num = empty($result['ct'])?0:$result['ct'];
        $this->Assign('comment_num', $comment_num);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_diary', $this->ref_diary);
        $this->objmnp->setValue('ref_entry', $this->ref_entry);
        $this->objmnp->setValue('flag', COMMENT_FLAG_READ);

        $this->objmnp->setInputEffect('body', array('func'=>array('webapp', 'emojiConvert')));

        // 更新しない項目名
        $skip = array(
            'link',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * コメントの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_comment()
    {
        if (empty($this->delete)){
            return false;
        }
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'id = '.$this->delete .' AND '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_entry = '.$this->ref_entry;
        return $this->objdb->exec($sql);
    }

    /**
     * 日記記事の更新
     *
     * @access private
     * @return boolean  真偽値
     */
    function update_entry()
    {
        $sql = 
            'SELECT '.
                'count(*) as post '.
            'FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'ref_entry = '.$this->ref_entry;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $post = empty($result['post'])?0:$result['post'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'dia_entry '.
            'SET '.
                'post = '.$post.' '.
            'WHERE '.
                'id = '.$this->ref_entry;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
