<?php
/* ========================================================================
 - [webapp/libs/community/picture.php]
 -      コミュニティ関連の添付画像クラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/30] 画像の更新処理にrkt_manipクラスを使用
 -      [2006/08/27] community_picture::setFix()のエラー修正
 -      [2006/07/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_upload.php';
require_once LIB_DIR.'rkt_image.php';

/**
 * コミュニティ関連の添付画像クラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package community_body
 * @access public
 * @version 1.0
 */
class community_picture
{
    /**
     * 添付ファイル画像ID
     * @var integer
     */
    var $id = 0;

    /**
     * コミュニティID
     * @var boolean
     */
    var $ref_community = 0;

    /**
     * ID
     * @var integer
     */
    var $ref_relation = 0;

    /**
     * アカウントID
     * @var integer
     */
    var $ref_account = 0;

    /**
     * ステータス
     * @var integer
     */
    var $status = 0;

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * BLOB操作オブジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param integer $ref_community
     * @param integer $ref_relation
     * @return void
     */
    function community_picture($ref_community, $ref_relation, $status)
    {
        $this->objdb = RKT_db::getInstance();
        $this->objfile = RKT_upload::getInstance(BLOB_DRIVER,BLOB_PARAM); 

        $this->ref_community = $ref_community;
        $this->ref_relation = empty($ref_relation)?0:$ref_relation;
        $objact = account::getInstance();
        $this->ref_account = $objact->getInfo('id');        
        $this->status = $status;
        $this->set_id();

        if (!empty($_POST['picture_delete'])){
            $_SESSION['picture_delete'] = $this->id;
        }
    }

    /**
     * 添付ファイルIDの取得
     *
     * @access private
     * @return void
     */
    function set_id()
    {
        if (isSet($_SESSION['ref_picture'])){
            $this->id = empty($_SESSION['ref_picture'])?0:$_SESSION['ref_picture'];
            return ;
        } // if (isSet($_SESSION['ref_picture']))

        $where = ' AND ref_relation = '.$this->ref_relation;
        /* コミュニティよう添付画像 */
        if ($this->status == STATUS_PICTURE_COMMUNITY){
            $where = '';
        }
        
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.$this->status.
                $where;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $this->id = empty($result['id'])?0:$result['id'];
    }

    /**
     * 画像のアップロード処理
     *
     * @access public
     * @return integer  データ操作結果
     */
    function upload()
    {
        /* 一覧用画像 */
        if (!$this->objfile->catchFile('photo')) {
            return false;
        }
        if (!$this->objfile->isImage()){
            return false;
        }

        // ファイルの保存
        $dir = ARCHIVES_UPLOAD_PATH;
        $filename = $this->objfile->getName();
        $extension = $this->objfile->getExtension();

        $temp = md5($this->ref_account.time());
        $name = substr($temp, rand(0,25), 6);

        $large_path = $dir.'large/'.$name.'.'.$extension;
        $small_path = $dir.'small/'.$name.'.'.$extension;

        $large  = $this->objfile->saveResize($large_path,PHOTO_LARGE_SIZE,PHOTO_LARGE_SIZE);
        $small  = $this->objfile->saveResize($small_path,PHOTO_SMALL_SIZE,PHOTO_SMALL_SIZE);

        /* テーブルの更新処理 */
        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_picture');
        if (empty($this->id)){
            $objmnp->setValue('ref_account',    $this->ref_account);
            if (!empty($this->ref_community)){
                $objmnp->setValue('ref_community',  $this->ref_community);
            }
        } else {
            $objmnp->setCurID($this->id);
        }

        $objmnp->setValue('modify',         date('Y-m-d H:i:s'));
        $objmnp->setValue('title',          $filename);
        $objmnp->setValue('filename',       $large_path);
        $objmnp->setValue('width',          $large['width']);
        $objmnp->setValue('height',         $large['height']);
        $objmnp->setValue('thumbnail',      $small_path);
        $objmnp->setValue('t_width',        $small['width']);
        $objmnp->setValue('t_height',       $small['height']);

        $objmnp->manip();

        $this->id = $objmnp->getCurID();
        $_SESSION['ref_picture'] = $this->id;

        return true;
    }

    /**
     * 画像の削除
     *
     * @access public
     * @param boolean $cahtch
     * @return integer  データ操作結果
     */
    function delete($catch=false)
    {
        if ($catch) {
            if (empty($_SESSION['picture_delete'])){
                return ;
            }
            if ($_SESSION['picture_delete'] != $this->id){
                unset($_SESSION['picture_delete']);
                return ;
            }
            unset($_SESSION['picture_delete']);
        } // if ($catch)

        $sql=
            'SELECT '.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            return 0;
        }

        $this->objfile->unlink($result['filename']);
        $this->objfile->unlink($result['thumbnail']);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * 修正等を更新する
     *
     * @access public
     * @param integer $ref_relation
     * @return boolean  真偽値
     */
    function setFix($ref_relation)
    {
        $uid = $this->ref_account;
        $this->ref_relation = $ref_relation;
        $sql=
            'SELECT '.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            return 0;
        }
        
        /* コミュニティよう添付画像 */
        if ($this->status == STATUS_PICTURE_COMMUNITY){
            $this->ref_community = $ref_relation;
            
            /* 
                登録者が退会時に画像をuidを元に削除するため
                コミュニティ用画像のuidは０にする。
             */
            $uid = 0;
        }

        // ファイルの保存
        $dir = ARCHIVES_COMMUNITY_PATH.$this->ref_community.'/';

        $large_path = ereg_replace(ARCHIVES_UPLOAD_PATH, $dir, $result['filename']);
        $small_path = ereg_replace(ARCHIVES_UPLOAD_PATH, $dir, $result['thumbnail']);

        $this->objfile->setUID($uid);
        $this->objfile->setGID($this->ref_community);
        $this->objfile->rename($result['filename'], $large_path);
        $this->objfile->rename($result['thumbnail'], $small_path);

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_picture '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'ref_community='.$this->ref_community.','.
                'ref_relation='.$this->ref_relation.','.
                'status='.$this->status.','.
                "filename='".$large_path."',".
                "thumbnail='".$small_path."' ".
            'WHERE '.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * 添付画像IDを削除
     *
     * @access public
     * @return void
     */
    function unSetPicture()
    {
        unset($_SESSION['ref_picture']);
    }

    /**
     * 添付画像情報の取得
     *
     * @access public
     * @return array
     */
    function getImgInfo()
    {
        $id = empty($this->id)?0:$this->id;
        $sql=
            'SELECT '.
                'id,'.
                'filename,'.
                'width,'.
                'height '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result['filename'])){
            $result = array(
                'id'=>       null,
                'filename'=> NOPHOTO_LARGE,
                'width'=>  PHOTO_LARGE_SIZE,
                'height'=> PHOTO_LARGE_SIZE
            );
        }

        $list = array(
            'id'=>     $result['id'],
            'src'=>    $result['filename'],
            'width'=>  $result['width'],
            'height'=> $result['height']
        );
        
        return $list;
    }
}
// community_pictureの終了
?>
