<?php
/* ========================================================================
 - [modules/admin/design/preview.php]
 -      デザイン画像表示
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/29] RKT_image::factory()部分の修正
 -      [2006/08/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_image.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * テーマID
     * @var integer
     */
    var $id = null;

    /**
     * サイズ
     * @var integer
     */
    var $size = null;

    /**
     * 画像名
     * @var string
     */
    var $image = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        // URL引数の取得
        $this->setSafety('id');
        $this->setSafety('size');
        $this->setSafety('image', '_REQUEST', 'string');
        
        $this->output_image();
    }

    /**
     * 画像出力
     *
     * @access private
     * @return void
     **/
    function output_image()
    {
        $filename = THEME_DIR.$this->id.DIRECTORY_SEPARATOR.$this->image;

        if (!file_exists($filename)){
            $filename = ARCHIVES_DIR.NOPHOTO_SMALL;
        }

        $objimg = RKT_image::factory(IMAGE_DRIVER);
        $objimg->readImage($filename);
        if (!empty($this->size)){
            $objimg->resize($this->size,$this->size);
        }
        $objimg->output();
        exit();
    }
} // webapp
?>
