<?php
/* ========================================================================
 - [modules/community/search/event.php]
 -      イベント検索結果
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/04] リストの絞込条件を変数に格納していないエラーを修正
 -      [2006/08/27] 非公開制限処理の追加
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * ORDER句
     * @var string
     */
    var $order = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/search/event.tpl');

        if (!empty($_POST['search'])){
            header('Location: '.HTTP_ACTION.'community/search/event/'.WAP_URI_SEPARATOR.http_build_query($_POST));
            exit();
        }
        
        $this->order = 'ORDER BY tpc.start_date DESC';

        $this->set_sort();
        $this->set_condition();
        $this->set_community();
    }

    /**
     * 並び替えの設定
     *
     * @access private
     * @return void
     */
    function set_sort()
    {
        $sql=
            'SELECT '.
                'id,'.
                'label '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'ref_category = '.SORT_EVENT.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['label'];
        }
        
        $this->Assign('sorts', $list);
    }

    /**
     * 条件データの取得
     *
     * @access private
     * @return string   絞込み句
     **/
    function get_condition()
    {
        /* 絞込条件の取得 */
        $validates = array(
            'ref_prefecture'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'start_year'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'start_month'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'start_day'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'end_year'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'end_month'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'end_day'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'keyword'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'ref_sort'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );

        return $this->catchCondition($validates);
    }

    /**
     * リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        // 絞込み条件の初期化
        $where = array();
        $conditions = $this->get_condition();


        /* 活動拠点 */
        if (!empty($conditions['ref_prefecture'])){
            $where[] = 'com.ref_prefecture='.$conditions['ref_prefecture'];
        }

        /* スタート日付 */
        $start_year  = date('Y');
        $start_month = '1';
        $start_day   = '1';
        $start_flag = 0;
        if (!empty($conditions['start_year'])){
            $start_year = intval($conditions['start_year']);
            $start_flag = true;
        }
        if (!empty($conditions['start_month'])){
            $start_month = intval($conditions['start_month']);
            $start_flag = true;
        }
        if (!empty($conditions['start_day'])){
            $start_day = intval($conditions['start_day']);
            $start_flag = true;
        }
        if ($start_flag){
            $timestamp = mktime(0,0,0, $start_month, $start_day, $start_year);
            $where[] = "tpc.start_date >= '". date('Y-m-d', $timestamp) ."'";
        }

        /* エンド日付 */
        $end_year  = date('Y');
        $end_month = '12';
        $end_day   = '1';
        $end_flag = 0;
        if (!empty($conditions['end_year'])){
            $end_year = intval($conditions['end_year']);
            $end_flag = true;
        }
        if (!empty($conditions['end_month'])){
            $end_month = intval($conditions['end_month']);
            $end_flag = true;
        }
        if (!empty($conditions['end_day'])){
            $end_day = intval($conditions['end_day']);
            $end_flag = true;
        } else {
            $timestamp = mktime(0,0,0, $end_month, $end_day, $end_year);
            $end_day   = intval(date('t',$timestamp));
        }

        if ($end_flag){
            $timestamp = mktime(0,0,0, $end_month, $end_day, $end_year);
            $where[] = "tpc.start_date <= '". date('Y-m-d', $timestamp) ."'";
        }


        /* キーワード検索 */
        $keys = array();
        if (!empty($conditions['keyword'])){
            $keywords = explode(' ',$conditions['keyword']);
            foreach ($keywords as $keyword){
                $keys[] = '('.
                    "tpc.topic like '%".$keyword."%'".' OR '.
                    "tpc.sub_locale like '%".$keyword."%'".' OR '.
                    "tpc.comment like '%".$keyword."%'".')';
            }
            $where[] = '('.implode(' OR ',$keys) .') ';
        }


        /* 並び替え */
        if (!empty($conditions['ref_sort'])){
            $this->set_order($conditions['ref_sort']);
        }

        
        if (!count($where)){
            return '';
        }
        $this->where = 'AND '. implode(' AND ',$where) .' ';
    }

    /**
     * ORDER句の設定
     *
     * @access private
     * @pram integer $id
     * @return void
     */
    function set_order($id)
    {
        $sql=
            'SELECT '.
                'direction '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->order = empty($result['direction'])?
                        '':'ORDER BY '.$result['direction'];
    }

    /**
     * イベントの設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_EVENT);    // クラスの生成
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.ref_community as ref_community,'.
                'tpc.regist_date as regist_date,'.
                'tpc.start_date as start_date,'.
                'tpc.deadline as deadline,'.
                'tpc.sub_locale as sub_locale,'.
                'tpc.topic as topic,'.
                'tpc.comment as comment,'.
                'com.community as community,'.
                'prf.prefecture as prefecture,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'ara_prefecture prf,'.
                DB_PREFIX.'com_topic tpc '.
            'WHERE '.
                'prf.id = tpc.ref_prefecture AND '.
                'com.id = tpc.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'com.visibility != '.VISIBILITY_HIDDEN.' '.
                $this->where.' '.
                $this->order;
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('list', $result);
    }
} // webapp
?>
