<?php
/* ========================================================================
 - [modules/community/show/footprint.php]
 -      あしあと
 -      Copyright (c) 2007 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/06/18] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/show/footprint.tpl');

        $this->set_footprint();
        $this->set_number();
    }

    /**
     * あしあとの設定
     *
     * @access private
     * @return void
     */
    function set_footprint()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'ftp.modify as modify,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_footprint ftp '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = ftp.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'ftp.ref_community = '.$this->ref_community.' '.
            'ORDER BY '.
                'ftp.modify DESC '.
            'LIMIT '.LIMIT_FOOTPRINT;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('footprints', $result);
    }

    /**
     * あしあと数の設定
     *
     * @access private
     * @return void
     */
    function set_number()
    {
        $sql = 
            'SELECT '.
                'com.access_num as total,'.
                'count(acc.id) as ct '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_accesslog acc '.
                    'ON com.id = acc.ref_community AND '.
                    'acc.unique_flag = 1 '.
            'WHERE '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'com.id = '.$this->ref_community.' '.
            'GROUP BY '.
                'com.access_num';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $total = 0;
        if (!empty($result)){
            $total = $result['total'] + $result['ct'];
        }

        $this->Assign('number', $total);
    }
} // webapp
?>
