<?php
/* ========================================================================
 - [modules/friend/forum/search.php]
 -      トピック検索
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('friend/forum/search.tpl');

        $this->set_prefecture();
        $this->set_sex();
        $this->set_blood();
        $this->set_married();
        $this->set_genre();
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return void
     */
    function set_prefecture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['prefecture'];
        }
        
        $this->Assign('prefectures',$list);
    }

    /**
     * 性別の設定
     *
     * @access private
     * @return void
     */
    function set_sex()
    {
        $sql=
            'SELECT '.
                'id,'.
                'sex '.
            'FROM '.
                DB_PREFIX.'act_sex '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['sex'];
        }
        
        $this->Assign('sexs',$list);
    }

    /**
     * 血液型の設定
     *
     * @access private
     * @return void
     */
    function set_blood()
    {
        $sql=
            'SELECT '.
                'id,'.
                'blood '.
            'FROM '.
                DB_PREFIX.'act_blood '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['blood'];
        }
        
        $this->Assign('bloods',$list);
    }

    /**
     * 結婚についての設定
     *
     * @access private
     * @return void
     */
    function set_married()
    {
        $sql=
            'SELECT '.
                'id,'.
                'married '.
            'FROM '.
                DB_PREFIX.'act_married '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['married'];
        }
        
        $this->Assign('marrieds',$list);
    }

    /**
     * トピックジャンルの設定
     *
     * @access private
     * @return void
     */
    function set_genre()
    {
        $sql=
            'SELECT '.
                'id,'.
                'genre '.
            'FROM '.
                DB_PREFIX.'frm_genre '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[] = array(
                'id'=> $value['id'],
                'genre'=> $value['genre'],
                'categorys'=> $this->get_category($value['id'])
            );
        }
        
        $this->Assign('genres',$list);
    }

    /**
     * トピックの内容
     *
     * @access private
     * @return array
     */
    function get_category($ref_genre)
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'frm_category '.
            'WHERE '.
                'ref_genre = '.$ref_genre.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $row = 0;
        $column = 0;
        foreach ($result as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = array(
                    'id'=> $value['id'],
                    'value'=> $value['id'],
                    'label'=> $value['category'],
                    'checked'=> null,
            );
            $column++;
        }

        return $list;
    }
} // webapp
?>
