<?php
/* ========================================================================
 - [modules/friend/search/condition.php]
 -      お友達検索項目一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/13] 公開レベルをビットフラグに対応
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/search/condition.tpl');

        $this->set_area();
        $this->set_sex();
        $this->set_blood();
        $this->set_married();
        $this->set_enquete();
    }

    /**
     * 道州の設定
     *
     * @access private
     * @return void
     */
    function set_area()
    {
        $sql=
            'SELECT '.
                'id,'.
                'area '.
            'FROM '.
                DB_PREFIX.'ara_area '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[] = array(
                'id'=> $value['id'],
                'area'=> $value['area'],
                'prefectures'=> $this->get_prefecture($value['id'],'ref_prefecture'),
                'hometowns'=>   $this->get_prefecture($value['id'],'ref_hometown')
            );
        }

        $this->Assign('areas', $list);
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return array
     */
    function get_prefecture($ref_area,$field)
    {
        $sql=
            'SELECT '.
                'prf.id as id,'.
                'prf.prefecture as prefecture,'.
                'count(pro.id) as ct '.
            'FROM '.
                DB_PREFIX.'ara_prefecture prf '.
                    'LEFT JOIN '.DB_PREFIX.'act_profile pro '.
                        'ON prf.id = pro.'.$field.' '.
            'WHERE '.
                'prf.ref_area = '.$ref_area.' '.
            'GROUP BY '.
                'prf.id,'.
                'prf.prefecture '.
            'ORDER BY '.
                'prf.id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $row = 0;
        $column = 0;
        foreach ($result as $value){
            // 改行処理
            if ($column >= 5){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = array(
                    'id'=>         $value['id'],
                    'prefecture'=> $value['prefecture'],
                    'ct'=>         $value['ct'],
            );
            $column++;
        }

        return $list;
    }

    /**
     * 性別の設定
     *
     * @access private
     * @return void
     */
    function set_sex()
    {
        $sql=
            'SELECT '.
                'sex.id as id,'.
                'sex.sex as sex,'.
                'count(pro.id) as ct '.
            'FROM '.
                DB_PREFIX.'act_sex sex '.
                    'LEFT JOIN '.DB_PREFIX.'act_profile pro '.
                        'ON sex.id = pro.ref_sex '.
            'GROUP BY '.
                'sex.id,'.
                'sex.sex '.
            'ORDER BY '.
                'sex.id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $this->Assign('sexs',$result);
    }

    /**
     * 血液型の設定
     *
     * @access private
     * @return void
     */
    function set_blood()
    {
        $sql=
            'SELECT '.
                'bld.id as id,'.
                'bld.blood as blood,'.
                'count(pro.id) as ct '.
            'FROM '.
                DB_PREFIX.'act_blood bld '.
                    'LEFT JOIN '.DB_PREFIX.'act_profile pro '.
                        'ON bld.id = pro.ref_blood '.
            'GROUP BY '.
                'bld.id,'.
                'bld.blood '.
            'ORDER BY '.
                'bld.id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $this->Assign('bloods', $result);
    }

    /**
     * 結婚についての設定
     *
     * @access private
     * @return void
     */
    function set_married()
    {
        $sql=
            'SELECT '.
                'mri.id as id,'.
                'mri.married as married,'.
                'count(pro.id) as ct '.
            'FROM '.
                DB_PREFIX.'act_married mri '.
                    'LEFT JOIN '.DB_PREFIX.'act_profile pro '.
                        'ON mri.id = pro.ref_married '.
            'GROUP BY '.
                'mri.id,'.
                'mri.married '.
            'ORDER BY '.
                'mri.id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $row = 0;
        $column = 0;
        foreach ($result as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = array(
                    'id'=>      $value['id'],
                    'married'=> $value['married'],
                    'ct'=>      $value['ct'],
            );
            $column++;
        }

        $this->Assign('marrieds', $list);
    }

    /**
     * アンケートの設定
     *
     * @access private
     * @return void
     */
    function set_enquete()
    {
        $sql=
            'SELECT '.
                'id,'.
                'form_type,'.
                'enquete '.
            'FROM '.
                DB_PREFIX.'act_enquete '.
            'WHERE '.
                'form_type = '.FORM_TYPE_SELECT.' OR '.
                'form_type = '.FORM_TYPE_CHECKBOX.' OR '.
                'form_type = '.FORM_TYPE_RADIO.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            if ($value['form_type'] == FORM_TYPE_CHECKBOX){
                $value['options'] = $this->get_select($value['id']);
            } else {
                $value['options'] = $this->get_item($value['id']);
            }
            $list[] = $value;
        }

        $this->Assign('enquetes', $list);
    }

    /**
     * 回答したアンケートの取得
     *
     * @access private
     * @param integer $ref_enquete
     * @param integer $form_type
     * @return array
     */
    function get_item($ref_enquete)
    {        
        $sql=
            'SELECT '.
                'itm.id as id,'.
                'itm.item as item,'.
                'count(con.ref_item) as ct '.
            'FROM '.
                DB_PREFIX.'act_item itm '.
                    'LEFT JOIN '.DB_PREFIX.'act_content con '.
                    'ON itm.id = con.ref_item AND '.
                       sql_query::bitFlag('con.visibility & '.VISIBILITY_OPEN).' '.
            'WHERE '.
                'itm.ref_enquete = '.$ref_enquete.' '.
            'GROUP BY '.
                'itm.id,'.
                'itm.item';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        if (empty($result)){
            return null;
        }

        $list = array();
        $row = 0;
        $column = 0;
        foreach ($result as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = array(
                    'id'=>   $value['id'],
                    'item'=> $value['item'],
                    'ct'=>   $value['ct'],
            );
            $column++;
        }
        return $list;
    }

    /**
     * 選択肢の取得
     *
     * @access private
     * @param integer $ref_enquete
     * @return array
     */
    function get_select($ref_enquete)
    {
        $sql=
            'SELECT '.
                'itm.id as id,'.
                'itm.item as item,'.
                'count(sel.ref_item) as ct '.
            'FROM '.
                DB_PREFIX.'act_item itm '.
                    'LEFT JOIN '.DB_PREFIX.'act_select sel '.
                    'ON itm.id = sel.ref_item AND '.
                       sql_query::bitFlag('sel.visibility & '.VISIBILITY_OPEN).' '.
            'WHERE '.
                'itm.ref_enquete = '.$ref_enquete.' '.
            'GROUP BY '.
                'itm.id,'.
                'itm.item';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        $row = 0;
        $column = 0;
        foreach ($result as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = array(
                    'id'=>   $value['id'],
                    'item'=> $value['item'],
                    'ct'=>   $value['ct'],
            );
            $column++;
        }
        return $list;
    }
} // webapp
?>
