<?php
/* ========================================================================
 - [modules/private/edit/friend.php]
 -      友達リスト管理
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/03/11] 友達紹介文の削除を追加
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 友達登録ID
     * @var object
     */
    var $id = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/edit/friend.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->set_friend();

        if (preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        /* 削除 */
        if ($this->delete_friends()){
            header('Location: '.HTTP_ACTION.'private/edit/friend/complete/');
            exit();
        }
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_FRIEND);    // クラスの生成

        $sql=
            'SELECT '.
                'fri.id as id,'.
                'fri.ref_friend as ref_friend,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'act.last_login as last_login,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = fri.ref_friend AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'fri.modify DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();        
        $this->Assign('friends', $result);
    }

    /**
     * 友達登録の解消
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_friends()
    {
        if (empty($_GET['delete'])){
            return false;
        }

        $sql=
            'SELECT '.
                'ref_friend '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['ref_friend'])){
            return false;
        }
        $ref_friend = $result['ref_friend'];

        /* 友達紹介文を削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_intro '.
            ' WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'ref_friend = '.$ref_friend;
        $result = $this->objdb->exec($sql);
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_intro '.
            ' WHERE '.
                'ref_account = '.$ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $result = $this->objdb->exec($sql);

        /* 友達リストを削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_friends '.
            ' WHERE '.
                'id ='.$this->id;
        $result = $this->objdb->exec($sql);
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_friends '.
            ' WHERE '.
                'ref_account = '.$ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $result = $this->objdb->exec($sql);
        
        $this->update_friend_number($this->account['id']);
        $this->update_friend_number($ref_friend);
        return $result;
    }

    /**
     * 友達数の設定
     *
     * @access private
     * @param integer $ref_account
     * @return void
     */
    function update_friend_number($ref_account)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $sql =
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'friend_number ='.$result['ct'].' '.
            'WHERE '.
                'id='.$ref_account;
        $this->objdb->exec($sql);
    }
} // webapp
?>
