-- ========================================================================
-- [sqls/sqlite.sql]
-- 		SQLite用テーブル定義
--      Copyright (c) 2006 Yujiro Takahashi
-- ライセンス:
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      as published by the Free Software Foundation; either version 2
--      of the License, or (at your option) any later version.
--
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
-- 問い合わせ先：
--      yujiro@rakuto.net
--      http://rakuto.net/rktSNS/
-- 更新履歴：
--	[2007/08/30] 会員メールアクションref_communityをref_additionに変更
-- ========================================================================

BEGIN TRANSACTION;

CREATE TEMPORARY TABLE 'tmp_act_mailaction' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_table' integer NOT NULL,
  'ref_relation' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_addition' integer,
  PRIMARY KEY  ('id')
);
INSERT INTO tmp_act_mailaction SELECT * FROM sns_act_mailaction;

DROP TABLE 'sns_act_mailaction';
CREATE TABLE 'sns_act_mailaction' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_table' integer NOT NULL,
  'ref_relation' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_addition' integer,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_table', 'ref_relation', 'ref_account')
);
INSERT INTO sns_act_mailaction SELECT * FROM tmp_act_mailaction;

CREATE INDEX sns_mailaction_modify ON sns_act_mailaction (modify);

COMMIT;
