/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao;

import java.util.HashMap;
import java.util.Map;

public class DaoTypes {
    public static final String ARRAY = "ARRAY";
    public static final String BIGINT = "BIGINT";
    public static final String BINARY = "BINARY";
    public static final String BIT = "BIT";
    public static final String BLOB = "BLOB";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String CHAR = "CHAR";
    public static final String CLOB = "CLOB";
    public static final String DATALINK = "DATALINK";
    public static final String DATE = "DATE";
    public static final String DECIMAL = "DECIMAL";
    public static final String DISTINCT = "DISTINCT";
    public static final String DOUBLE = "DOUBLE";
    public static final String FLOAT = "FLOAT";
    public static final String INTEGER = "INTEGER";
    public static final String JAVA_OBJECT = "JAVA_OBJECT";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String NULL = "NULL";
    public static final String NUMERIC = "NUMERIC";
    public static final String OTHER = "OTHER";
    public static final String REAL = "REAL";
    public static final String REF = "REF";
    public static final String SMALLINT = "SMALLINT";
    public static final String STRUCT = "STRUCT";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TINYINT = "TINYINT";
    public static final String VARBINARY = "VARBINARY";
    public static final String VARCHAR = "VARCHAR";
    private static Map TYPE_MAP = null;
    private static String[] TYPE_STRING;

    public static Integer getSQLType(String typeStr) {
        return (Integer)TYPE_MAP.get(typeStr);
    }

    public static String getSQLTypeString(int sqlType) {
        return TYPE_STRING[sqlType];
    }

    private DaoTypes() {
    }

    static {
        TYPE_MAP = new HashMap();
        TYPE_MAP.put(ARRAY, new Integer(2003));
        TYPE_MAP.put(BIGINT, new Integer(-5));
        TYPE_MAP.put(BINARY, new Integer(-2));
        TYPE_MAP.put(BIT, new Integer(-7));
        TYPE_MAP.put(BLOB, new Integer(2004));
        TYPE_MAP.put(BOOLEAN, new Integer(16));
        TYPE_MAP.put(CHAR, new Integer(1));
        TYPE_MAP.put(CLOB, new Integer(2005));
        TYPE_MAP.put(DATALINK, new Integer(70));
        TYPE_MAP.put(DATE, new Integer(91));
        TYPE_MAP.put(DECIMAL, new Integer(3));
        TYPE_MAP.put(DISTINCT, new Integer(2001));
        TYPE_MAP.put(DOUBLE, new Integer(8));
        TYPE_MAP.put(FLOAT, new Integer(6));
        TYPE_MAP.put(INTEGER, new Integer(4));
        TYPE_MAP.put(JAVA_OBJECT, new Integer(2000));
        TYPE_MAP.put(LONGVARBINARY, new Integer(-4));
        TYPE_MAP.put(LONGVARCHAR, new Integer(-1));
        TYPE_MAP.put(NULL, new Integer(0));
        TYPE_MAP.put(NUMERIC, new Integer(2));
        TYPE_MAP.put(OTHER, new Integer(1111));
        TYPE_MAP.put(REAL, new Integer(7));
        TYPE_MAP.put(REF, new Integer(2006));
        TYPE_MAP.put(SMALLINT, new Integer(5));
        TYPE_MAP.put(STRUCT, new Integer(2002));
        TYPE_MAP.put(TIME, new Integer(92));
        TYPE_MAP.put(TIMESTAMP, new Integer(93));
        TYPE_MAP.put(TINYINT, new Integer(-6));
        TYPE_MAP.put(VARBINARY, new Integer(-3));
        TYPE_MAP.put(VARCHAR, new Integer(12));
        TYPE_STRING = new String[]{ARRAY, BIGINT, BINARY, BIT, BLOB, BOOLEAN, CHAR, CLOB, DATALINK, DATE, DECIMAL, DISTINCT, DOUBLE, FLOAT, INTEGER, JAVA_OBJECT, LONGVARBINARY, LONGVARCHAR, NULL, NUMERIC, OTHER, REAL, REF, SMALLINT, STRUCT, TIME, TIMESTAMP, TINYINT, VARBINARY, VARCHAR};
    }
}

