/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import robbie.dao.DaoSysException;
import robbie.util.CollectionsUtil;

public class DaoUtil {
    private static final Log LOG;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("robbie.dao.DaoUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private DaoUtil() {
    }

    public static List resultSetToMapList(ResultSet rs) throws SQLException {
        List list = CollectionsUtil.createList();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        String[] columnNames = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            int name_i = i + 1;
            columnNames[i] = rsMetaData.getColumnName(name_i);
            ++i;
        }
        while (rs.next()) {
            Map columnMap = CollectionsUtil.createMap();
            int i2 = 0;
            while (i2 < columnNames.length) {
                int object_i = i2 + 1;
                columnMap.put(columnNames[i2], rs.getObject(object_i));
                ++i2;
            }
            list.add(columnMap);
        }
        if (list.size() == 0) {
            list = null;
        }
        return list;
    }

    public static Object[][] resultSetToArray(ResultSet rs) throws SQLException {
        List list = CollectionsUtil.createList();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        Object[] columnNames = new Object[columnCount];
        int i = 0;
        while (i < columnCount) {
            int name_i = i + 1;
            columnNames[i] = rsMetaData.getColumnName(name_i);
            ++i;
        }
        list.add(columnNames);
        while (rs.next()) {
            Object[] columnValue = new Object[columnCount];
            int i2 = 0;
            while (i2 < columnCount) {
                int object_i = i2 + 1;
                columnValue[i2] = rs.getObject(object_i);
                ++i2;
            }
            list.add(columnValue);
        }
        if (list.size() <= 1) {
            return null;
        }
        Object[] before = list.toArray();
        Object[][] after = new Object[before.length][];
        int i3 = 0;
        while (i3 < before.length) {
            after[i3] = (Object[])before[i3];
            ++i3;
        }
        return after;
    }

    public static final List resultSetToBeansList(Class beanClass, ResultSet rs) throws Exception {
        List beanList = CollectionsUtil.createList();
        if (rs != null) {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            int i = 0;
            while (i < columnNames.length) {
                columnNames[i] = rsMetaData.getColumnName(i + 1);
                ++i;
            }
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            if (descriptors == null) {
                return beanList;
            }
            Map descriptorMap = CollectionsUtil.createMap();
            int i2 = 0;
            while (i2 < descriptors.length) {
                descriptorMap.put(descriptors[i2].getName().toLowerCase(), descriptors[i2]);
                ++i2;
            }
            while (rs.next()) {
                Object bean = beanClass.newInstance();
                int i3 = 0;
                while (i3 < columnNames.length) {
                    String columnName = DaoUtil.columnNameToPropertyName(columnNames[i3]).toLowerCase();
                    if (descriptorMap.containsKey(columnName)) {
                        PropertyDescriptor descriptor = (PropertyDescriptor)descriptorMap.get(columnName);
                        Object arg = DaoUtil.convertObjectIfNeeded(descriptor.getPropertyType(), descriptor.getName(), columnNames[i3], rs.getObject(i3 + 1));
                        Object[] args = new Object[]{arg};
                        descriptor.getWriteMethod().invoke(bean, args);
                    }
                    ++i3;
                }
                beanList.add(bean);
            }
        }
        return beanList;
    }

    public static final Map beansToMap(Object beans) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Map map = CollectionsUtil.createMap();
        if (beans == null) {
            return map;
        }
        Class<?> beansClass = beans.getClass();
        BeanInfo info = Introspector.getBeanInfo(beansClass);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        if (descriptors == null) {
            return null;
        }
        int i = 0;
        while (i < descriptors.length) {
            PropertyDescriptor descriptor = descriptors[i];
            Object[] args = new Object[]{};
            map.put(descriptors[i].getName(), descriptor.getReadMethod().invoke(beans, args));
            ++i;
        }
        return map;
    }

    private static String columnNameToPropertyName(String columnName) {
        return columnName.replaceAll("[_]", "");
    }

    private static final Object convertObjectIfNeeded(Class objClass, String propName, String columnName, Object obj) {
        if (LOG.isDebugEnabled()) {
            String className = null;
            className = obj != null ? obj.getClass().getName() : "null";
            LOG.debug((Object)("\u578b\u5909\u63db\u60c5\u5831 \u30ab\u30e9\u30e0:" + columnName + "(\u578b=" + className + ":\u5024=" + obj + ") => " + "\u30d7\u30ed\u30d1\u30c6\u30a3:" + propName + "(\u578b=" + objClass.getName() + ")"));
        }
        if (DaoUtil.isPrimitiveType(objClass)) {
            if (Integer.TYPE.equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Integer(((Number)obj).intValue());
                }
                if (obj == null) {
                    return new Integer(0);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cInteger\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Long(((Number)obj).longValue());
                }
                if (obj == null) {
                    return new Long(0L);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cLong\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Short(((Number)obj).shortValue());
                }
                if (obj == null) {
                    return new Short(0);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cShort\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Float(((Number)obj).floatValue());
                }
                if (obj == null) {
                    return new Float(0.0f);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cFloat\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Double(((Number)obj).doubleValue());
                }
                if (obj == null) {
                    return new Double(0.0);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cDouble\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Boolean.TYPE.equals(objClass)) {
                if (obj instanceof Boolean) {
                    return obj;
                }
                if (obj == null) {
                    return new Boolean(false);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cBoolean\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Byte.TYPE.equals(objClass)) {
                if (obj instanceof Byte) {
                    return obj;
                }
                if (obj == null) {
                    return new Byte(0);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cByte\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Character.TYPE.equals(objClass)) {
                if (obj instanceof Character) {
                    return obj;
                }
                if (obj == null) {
                    return new Character('\u0000');
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cCharacter\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
        } else if (obj instanceof Number) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                }
                return new Integer(((Number)obj).intValue());
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                }
                return new Long(((Number)obj).longValue());
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                }
                return new Short(((Number)obj).shortValue());
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                }
                return new Float(((Number)obj).floatValue());
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                }
                return new Double(((Number)obj).doubleValue());
            }
        }
        return obj;
    }

    private static boolean isPrimitiveType(Class objClass) {
        if (Integer.TYPE.equals(objClass)) {
            return true;
        }
        if (Long.TYPE.equals(objClass)) {
            return true;
        }
        if (Float.TYPE.equals(objClass)) {
            return true;
        }
        if (Double.TYPE.equals(objClass)) {
            return true;
        }
        if (Boolean.TYPE.equals(objClass)) {
            return true;
        }
        if (Short.TYPE.equals(objClass)) {
            return true;
        }
        if (Byte.TYPE.equals(objClass)) {
            return true;
        }
        return Character.TYPE.equals(objClass);
    }
}

