/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao.x;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import robbie.dao.x.XDao;
import robbie.dao.x.XDaoException;
import robbie.dao.x.XDbResourceFactory;
import robbie.dao.x.XQueryFactory;
import robbie.util.CollectionsUtil;
import robbie.util.InstanceFactory;
import robbie.util.JdomXmlLoader;

public class XDaoFactory
implements Serializable {
    private static final long serialVersionUID = -7266751084337417590L;
    private static final Log LOG;
    protected String xQueryFactoryClassName;
    protected String xDBResourceFactoryClassName;
    protected String filepath;
    protected XQueryFactory queryFactory;
    protected XDbResourceFactory resourceFactory;
    protected Map daoNameMap;
    protected Map daoResRefMap;
    protected long lastModifiedTimestamp;
    protected boolean isValidate;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("robbie.dao.x.XDaoFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private XDaoFactory() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("robbie.dao.x.XQueryFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.xQueryFactoryClassName = clazz.getName();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("robbie.dao.x.XDbResourceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.xDBResourceFactoryClassName = clazz2.getName();
        this.filepath = null;
        this.queryFactory = null;
        this.resourceFactory = null;
        this.daoNameMap = null;
        this.daoResRefMap = null;
        this.lastModifiedTimestamp = 0L;
        this.isValidate = false;
    }

    public XDaoFactory(String filename) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("robbie.dao.x.XQueryFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.xQueryFactoryClassName = clazz.getName();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("robbie.dao.x.XDbResourceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.xDBResourceFactoryClassName = clazz2.getName();
        this.filepath = null;
        this.queryFactory = null;
        this.resourceFactory = null;
        this.daoNameMap = null;
        this.daoResRefMap = null;
        this.lastModifiedTimestamp = 0L;
        this.isValidate = false;
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("\u30d1\u30e9\u30e1\u30fc\u30bffilename\u304cNULL\u304b\u6587\u5b57\u6570\u304c0\u3067\u3059");
        }
        try {
            String filepath = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(filename);
            if (url != null) {
                filepath = url.getFile();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" CLASSPATH\u3092\u691c\u7d22\u3057\u3066URL\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u304c\u4f5c\u6210\u3067\u304d\u307e\u3057\u305f. filename=" + filename + " \u3053\u306eURL\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306egetFile()\u3092\u4f7f\u7528\u3057\u3066FileInputStream\u3092\u4f5c\u6210\u3057\u307e\u3059. filepath=" + filepath));
                }
                try {
                    this.configure(new FileInputStream(filepath));
                }
                catch (FileNotFoundException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(" FileInputStream\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f. filepath=" + filepath + " URL#openStream()\u304b\u3089InputStream\u3092\u4f5c\u6210\u3057\u3066\u521d\u671f\u5316\u3092\u884c\u3044\u307e\u3059. " + " \u305f\u3060\u3057\u3001\u3053\u306e\u5834\u5408\u30d5\u30a1\u30a4\u30eb\u30b9\u30bf\u30f3\u30d7\u3092\u78ba\u8a8d\u3057\u3066\u5b9a\u7fa9\u60c5\u5831\u306e\u30ea\u30ed\u30fc\u30c9\u306f\u884c\u3044\u307e\u305b\u3093\u3002."));
                    }
                    this.configure(url.openStream());
                    return;
                }
            } else {
                filepath = filename;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" CLASSPATH\u3092\u691c\u7d22\u3057\u307e\u3057\u305f\u304c\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f. filename=" + filename + " \u3092\u30d5\u30a1\u30a4\u30eb\u306ePATH\u3068\u3057\u3066FileInputStream\u3092\u4f5c\u6210\u3057\u307e\u3059."));
                }
                this.configure(new FileInputStream(filename));
            }
            this.filepath = filepath;
            this.lastModifiedTimestamp = new File(filepath).lastModified();
        }
        catch (FileNotFoundException ex) {
            LOG.error((Object)("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f. filepath = " + filename), (Throwable)ex);
            throw new XDaoException("file not found. filepath = " + filename, ex);
        }
        catch (IOException ex) {
            LOG.error((Object)("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f. filepath = " + filename), (Throwable)ex);
            throw new XDaoException("file not found. filepath = " + filename, ex);
        }
    }

    public XDaoFactory(InputStream inputStream) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("robbie.dao.x.XQueryFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.xQueryFactoryClassName = clazz.getName();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("robbie.dao.x.XDbResourceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.xDBResourceFactoryClassName = clazz2.getName();
        this.filepath = null;
        this.queryFactory = null;
        this.resourceFactory = null;
        this.daoNameMap = null;
        this.daoResRefMap = null;
        this.lastModifiedTimestamp = 0L;
        this.isValidate = false;
        if (inputStream == null) {
            throw new IllegalArgumentException("InputSream\u304cNULL\u3067\u3059.");
        }
        this.configure(inputStream);
    }

    public XDao createDaoInstance(String id, ClassLoader loader) {
        this.reconfigureIfNeeded();
        if (!this.daoNameMap.containsKey(id)) {
            throw new XDaoException("id=[" + id + "]\u306eQuery\u60c5\u5831\u304cXML\u306b\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093.");
        }
        Object obj = InstanceFactory.createInstance((String)this.daoNameMap.get(id), loader);
        XDao dao = (XDao)obj;
        dao.setQueryFactory(this.queryFactory);
        dao.setResource(this.resourceFactory.getDbResource((String)this.daoResRefMap.get(id)));
        dao.configure();
        return dao;
    }

    public XDao createDaoInstance(String id) {
        return this.createDaoInstance(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(InputStream inputStream) {
        Element root = this.loadRootElemet(inputStream);
        if (this.resourceFactory != null) {
            XDbResourceFactory xDbResourceFactory = this.resourceFactory;
            synchronized (xDbResourceFactory) {
                this.configureResourceFactory(root);
                this.conifgureDAOMap(root);
                this.configureQueryFactory(root);
            }
        } else {
            this.configureResourceFactory(root);
            this.conifgureDAOMap(root);
            this.configureQueryFactory(root);
        }
    }

    protected void reconfigureIfNeeded() {
        long nowLastModifiedTimestamp;
        if (this.filepath != null && (nowLastModifiedTimestamp = new File(this.filepath).lastModified()) > this.lastModifiedTimestamp) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("reload config file. filepath=" + this.filepath + " \u3053\u308c\u307e\u3067\u306e\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7 = " + new Date(this.lastModifiedTimestamp) + " \u66f4\u65b0\u3055\u308c\u305f\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7 = " + new Date(nowLastModifiedTimestamp)));
            }
            try {
                this.configure(new FileInputStream(this.filepath));
                this.lastModifiedTimestamp = nowLastModifiedTimestamp;
            }
            catch (FileNotFoundException ex) {
                throw new XDaoException("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093. filepath=" + this.filepath, ex);
            }
        }
    }

    protected Element loadRootElemet(InputStream inputStream) {
        try {
            return JdomXmlLoader.load(inputStream, this.isValidate);
        }
        catch (Exception ex) {
            throw new XDaoException("XML\u30d5\u30a1\u30a4\u30eb\u3092\u30ed\u30fc\u30c9\u4e2d\u306b\u4f8b\u5916\u3092\u691c\u51fa\u3057\u307e\u3057\u305f.", ex);
        }
    }

    protected void configureResourceFactory(Element root) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("configureResourceFactory(): XDbResourceFactory\u306e\u30af\u30e9\u30b9\u540d=" + this.xDBResourceFactoryClassName));
        }
        XDbResourceFactory factory = (XDbResourceFactory)InstanceFactory.createInstance(this.xDBResourceFactoryClassName);
        factory.configure(root.getChild("resource-list"));
        this.resourceFactory = factory;
    }

    protected void conifgureDAOMap(Element root) {
        Element daoList = root.getChild("dao-list");
        if (daoList == null) {
            throw new XDaoException("dao-list\u8981\u7d20\u304cNULL\u3067\u3059.");
        }
        List list = daoList.getChildren("dao");
        if (list != null && list.size() > 0) {
            Map nameMap = CollectionsUtil.createMap();
            Map refMap = CollectionsUtil.createMap();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Element ele = (Element)it.next();
                String id = ele.getAttributeValue("id");
                if (id == null) {
                    throw new XDaoException("dao\u8981\u7d20\u306eid\u5c5e\u6027\u304cNULL\u3067\u3059.");
                }
                String calssName = null;
                String refResoauce = null;
                try {
                    calssName = ele.getChild("class").getText();
                    refResoauce = ele.getChild("resource-ref").getText();
                }
                catch (Exception ex) {
                    throw new XDaoException("class-name\u8981\u7d20\u3001\u307e\u305f\u306fresource-ref\u8981\u7d20\u304cnull\u3067\u3059.", ex);
                }
                if (nameMap.containsKey(id) && LOG.isDebugEnabled()) {
                    LOG.warn((Object)("\u8b66\u544a! DAO\u306eid=[" + id + "]\u306f\u65e2\u306b\u5b9a\u7fa9\u304c\u5b58\u5728\u3057\u307e\u3059. \u65b0\u3057\u3044\u60c5\u5831\u3067\u4e0a\u66f8\u304d\u3055\u308c\u307e\u3059."));
                }
                nameMap.put(id, calssName);
                refMap.put(id, refResoauce);
            }
            this.daoNameMap = nameMap;
            this.daoResRefMap = refMap;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XDao Name " + this.daoNameMap));
                LOG.debug((Object)("XDao Reource-ref " + this.daoResRefMap));
            }
        }
    }

    protected void configureQueryFactory(Element root) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("configureQueryFactory(): XQueryFactory\u306e\u30af\u30e9\u30b9\u540d=" + this.xQueryFactoryClassName));
        }
        XQueryFactory factory = (XQueryFactory)InstanceFactory.createInstance(this.xQueryFactoryClassName);
        factory.configure(root.getChild("query-list"));
        this.queryFactory = factory;
    }
}

