/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao.x;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import robbie.dao.DbConnectionUtil;
import robbie.dao.resource.DataSourceResource;
import robbie.dao.resource.DbResource;
import robbie.dao.resource.JdbcOdbcResource;
import robbie.dao.resource.JdbcResource;
import robbie.dao.x.XDaoException;
import robbie.util.CollectionsUtil;

public class XDbResourceFactory {
    private static final Log LOG;
    protected Map resourceMap = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("robbie.dao.x.XDbResourceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public DbResource getDbResource(String id) {
        return (DbResource)this.resourceMap.get(id);
    }

    public void configure(Element resourceListElement) {
        List list = resourceListElement.getChildren("resource");
        if (list != null && list.size() > 0) {
            Map map = CollectionsUtil.createMap();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Element ele = (Element)it.next();
                String id = ele.getAttributeValue("id");
                if (id == null || id.length() == 0) {
                    throw new XDaoException("resouce\u8981\u7d20\u306e\u5c5e\u6027'id'\u304cNULL\u304b\u6587\u5b57\u6570\u304c0\u3067\u3059.");
                }
                String type = ele.getAttributeValue("type");
                if (map.containsKey(id) && LOG.isDebugEnabled()) {
                    LOG.warn((Object)("\u8b66\u544a! resource\u306eid=[" + id + "]\u306f\u65e2\u306b\u5b9a\u7fa9\u304c\u5b58\u5728\u3057\u307e\u3059. \u65b0\u3057\u3044\u60c5\u5831\u3067\u4e0a\u66f8\u304d\u3055\u308c\u307e\u3059."));
                }
                map.put(id, this.createXDbResource(type, ele));
            }
            this.resourceMap = map;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XDbReource\u306e\u5b9a\u7fa9Map\uff1a" + this.resourceMap));
            }
        } else {
            throw new XDaoException("'resource'\u8981\u7d20\u304cNULL\u304b\u7a7a\u3067\u3059.");
        }
    }

    protected DbResource createXDbResource(String type, Element ele) {
        DbResource resource = null;
        if ("DataSource".equals(type)) {
            String jndiName = null;
            try {
                jndiName = ele.getChild("jndi-name").getText();
                if (jndiName == null || jndiName.length() == 0) {
                    throw new XDaoException("'jndi-name'\u304cNULL\u304b\u6587\u5b57\u6570\u304c0\u3067\u3059.");
                }
            }
            catch (Exception ex) {
                throw new XDaoException("'jndi-name'\u8981\u7d20\u304cNULL\u304b\u7a7a\u3067\u3059.");
            }
            resource = new DataSourceResource(jndiName);
        } else if ("JDBC".equals(type)) {
            Properties env = null;
            try {
                env = DbConnectionUtil.createConnectionProperties(ele.getChild("driver").getText(), ele.getChild("url").getText(), ele.getChild("username").getText(), ele.getChild("password").getText());
            }
            catch (Exception ex) {
                throw new XDaoException("'driver','url','username','password'\u8981\u7d20\u306e\u3044\u305a\u308c\u304b\u304cNULL\u3067\u3059.");
            }
            resource = new JdbcResource(env);
        } else if ("JDBC-ODBC".equals(type)) {
            String sourceName = null;
            try {
                sourceName = ele.getChild("odbc-data-source").getText();
                if (sourceName == null || sourceName.length() == 0) {
                    throw new XDaoException("'odbc-data-source'\u304cNULL\u304b\u6587\u5b57\u6570\u304c0\u3067\u3059.");
                }
            }
            catch (Exception ex) {
                throw new XDaoException("'odbc-data-source'\u8981\u7d20\u304cNULL\u3067\u3059.");
            }
            resource = new JdbcOdbcResource(sourceName);
        } else {
            throw new XDaoException("\u30ea\u30bd\u30fc\u30b9\u306etype\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093. type=" + type);
        }
        return resource;
    }
}

