/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao;

import java.util.Map;
import java.util.HashMap;

import java.sql.Types;


/**
 * DAOTypesNX.<p>
 */
public class DaoTypes {

    /** typeŎw肷ėpSQL^uARRAYvB  */
    public static final String ARRAY = "ARRAY";

    /** typeŎw肷ėpSQL^uBIGINTvB  */
    public static final String BIGINT = "BIGINT";

    /** typeŎw肷ėpSQL^uBINARYvB  */
    public static final String BINARY = "BINARY";

    /** typeŎw肷ėpSQL^uBITvB  */
    public static final String BIT = "BIT";

    /** typeŎw肷ėpSQL^uBLOBvB  */
    public static final String BLOB = "BLOB";

    /** typeŎw肷ėpSQL^uBOOLEANvB  */
    public static final String BOOLEAN = "BOOLEAN";

    /** typeŎw肷ėpSQL^uCHARvB  */
    public static final String CHAR = "CHAR";

    /** typeŎw肷ėpSQL^uCLOBvB  */
    public static final String CLOB = "CLOB";

    /** typeŎw肷ėpSQL^uDATALINKvB  */
    public static final String DATALINK = "DATALINK";

    /** typeŎw肷ėpSQL^uDATEvB  */
    public static final String DATE = "DATE";

    /** typeŎw肷ėpSQL^uDECIMALvB  */
    public static final String DECIMAL = "DECIMAL";

    /** typeŎw肷ėpSQL^uDISTINCTvB  */
    public static final String DISTINCT = "DISTINCT";

    /** typeŎw肷ėpSQL^uDOUBLEvB  */
    public static final String DOUBLE = "DOUBLE";

    /** typeŎw肷ėpSQL^uFLOATvB  */
    public static final String FLOAT = "FLOAT";

    /** typeŎw肷ėpSQL^uINTEGERvB  */
    public static final String INTEGER = "INTEGER";

    /** typeŎw肷ėpSQL^uJAVA_OBJECTvB  */
    public static final String JAVA_OBJECT = "JAVA_OBJECT";

    /** typeŎw肷ėpSQL^uLONGVARBINARYvB  */
    public static final String LONGVARBINARY = "LONGVARBINARY";

    /** typeŎw肷ėpSQL^uLONGVARCHARvB  */
    public static final String LONGVARCHAR = "LONGVARCHAR";

    /** typeŎw肷ėpSQL^uNULLvB  */
    public static final String NULL = "NULL";

    /** typeŎw肷ėpSQL^uNUMERICvB  */
    public static final String NUMERIC = "NUMERIC";

    /** typeŎw肷ėpSQL^uOTHERvB  */
    public static final String OTHER = "OTHER";

    /** typeŎw肷ėpSQL^uREALvB  */
    public static final String REAL = "REAL";

    /** typeŎw肷ėpSQL^uREFvB  */
    public static final String REF = "REF";

    /** typeŎw肷ėpSQL^uSMALLINTvB  */
    public static final String SMALLINT = "SMALLINT";

    /** typeŎw肷ėpSQL^uSTRUCTvB  */
    public static final String STRUCT = "STRUCT";

    /** typeŎw肷ėpSQL^uTIMEvB  */
    public static final String TIME = "TIME";

    /** typeŎw肷ėpSQL^uTIMESTAMPvB  */
    public static final String TIMESTAMP = "TIMESTAMP";

    /** typeŎw肷ėpSQL^uTINYINTvB  */
    public static final String TINYINT = "TINYINT";

    /** typeŎw肷ėpSQL^uVARBINARYvB  */
    public static final String VARBINARY = "VARBINARY";

    /** typeŎw肷ėpSQL^uVARCHARvB  */
    public static final String VARCHAR = "VARCHAR";

    private static Map TYPE_MAP = null;

    static {
        TYPE_MAP = new HashMap();
        TYPE_MAP.put(DaoTypes.ARRAY, new Integer(Types.ARRAY));
        TYPE_MAP.put(DaoTypes.BIGINT, new Integer(Types.BIGINT));
        TYPE_MAP.put(DaoTypes.BINARY, new Integer(Types.BINARY));
        TYPE_MAP.put(DaoTypes.BIT, new Integer(Types.BIT));
        TYPE_MAP.put(DaoTypes.BLOB, new Integer(Types.BLOB));
        TYPE_MAP.put(DaoTypes.BOOLEAN, new Integer(Types.BOOLEAN));
        TYPE_MAP.put(DaoTypes.CHAR, new Integer(Types.CHAR));
        TYPE_MAP.put(DaoTypes.CLOB, new Integer(Types.CLOB));
        TYPE_MAP.put(DaoTypes.DATALINK, new Integer(Types.DATALINK));
        TYPE_MAP.put(DaoTypes.DATE, new Integer(Types.DATE));
        TYPE_MAP.put(DaoTypes.DECIMAL, new Integer(Types.DECIMAL));
        TYPE_MAP.put(DaoTypes.DISTINCT, new Integer(Types.DISTINCT));
        TYPE_MAP.put(DaoTypes.DOUBLE, new Integer(Types.DOUBLE));
        TYPE_MAP.put(DaoTypes.FLOAT, new Integer(Types.FLOAT));
        TYPE_MAP.put(DaoTypes.INTEGER, new Integer(Types.INTEGER));
        TYPE_MAP.put(DaoTypes.JAVA_OBJECT, new Integer(Types.JAVA_OBJECT));
        TYPE_MAP.put(DaoTypes.LONGVARBINARY, new Integer(Types.LONGVARBINARY));
        TYPE_MAP.put(DaoTypes.LONGVARCHAR, new Integer(Types.LONGVARCHAR));
        TYPE_MAP.put(DaoTypes.NULL, new Integer(Types.NULL));
        TYPE_MAP.put(DaoTypes.NUMERIC, new Integer(Types.NUMERIC));
        TYPE_MAP.put(DaoTypes.OTHER, new Integer(Types.OTHER));
        TYPE_MAP.put(DaoTypes.REAL, new Integer(Types.REAL));
        TYPE_MAP.put(DaoTypes.REF, new Integer(Types.REF));
        TYPE_MAP.put(DaoTypes.SMALLINT, new Integer(Types.SMALLINT));
        TYPE_MAP.put(DaoTypes.STRUCT, new Integer(Types.STRUCT));
        TYPE_MAP.put(DaoTypes.TIME, new Integer(Types.TIME));
        TYPE_MAP.put(DaoTypes.TIMESTAMP, new Integer(Types.TIMESTAMP));
        TYPE_MAP.put(DaoTypes.TINYINT, new Integer(Types.TINYINT));
        TYPE_MAP.put(DaoTypes.VARBINARY, new Integer(Types.VARBINARY));
        TYPE_MAP.put(DaoTypes.VARCHAR, new Integer(Types.VARCHAR));
    }
    
    private static String[] TYPE_STRING = {
        DaoTypes.ARRAY,
        DaoTypes.BIGINT,
        DaoTypes.BINARY,
        DaoTypes.BIT,
        DaoTypes.BLOB,
        DaoTypes.BOOLEAN,
        DaoTypes.CHAR,
        DaoTypes.CLOB,
        DaoTypes.DATALINK,
        DaoTypes.DATE,
        DaoTypes.DECIMAL,
        DaoTypes.DISTINCT,
        DaoTypes.DOUBLE,
        DaoTypes.FLOAT,
        DaoTypes.INTEGER,
        DaoTypes.JAVA_OBJECT,
        DaoTypes.LONGVARBINARY,
        DaoTypes.LONGVARCHAR,
        DaoTypes.NULL,
        DaoTypes.NUMERIC,
        DaoTypes.OTHER,
        DaoTypes.REAL,
        DaoTypes.REF,
        DaoTypes.SMALLINT,
        DaoTypes.STRUCT,
        DaoTypes.TIME,
        DaoTypes.TIMESTAMP,
        DaoTypes.TINYINT,
        DaoTypes.VARBINARY,
        DaoTypes.VARCHAR
    };
    
    /**
     * 񂩂SQLTYPEԂB<p>
     * @param typeStr
     * @return SQLTYPE(Integer)
     */
    public static Integer getSQLType(String typeStr) {
        return (Integer)DaoTypes.TYPE_MAP.get(typeStr);
    }
    
    /**
     * SQLType(int)炻̕\LԂB<p>
     * @param sqlType
     * @return SQLType̕\L
     */
    public static String getSQLTypeString(int sqlType) {
        return TYPE_STRING[sqlType];
    }
    
    private DaoTypes() {
        // ȂACX^XȂB
    }
}
