/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao;

import java.util.List;
import java.util.Map;


/**
 * QueryC^tF[X̃T|[gNXB<p>
 * QueryC^tF[X̎ƁAtoString()\bh̎
 * sȂĂ܂B
 * TuNXł́ÃNXŒ`Ă
 * sqlStringparameterListɁA
 * SQLsɕKvȏZbg鏈A
 * configure()\bhɎĂB
 */
public abstract class QuerySupport implements Query {

    /** SQL̕ */
    protected String sqlString = null;
    
    /** oChϐ̃Xg */
    protected List prametersList = null; 
    
    /** 
     * JavaBeansϊClass.<p> 
     * @since 1.2.0 
     */
    protected Class resultClass = null;
    
    /**
     * ϊSQLԂB<p>
     * TuNXł́Ã\bhŕԂėp\(PreparedStatementp)A
     * SQL쐬鏈ĂB
     * @return@SQL
     */
    public String getSQLString() {
        return sqlString;
    }
    
    /**
     * oChp[^MapListԂB<p>
     * TuNXł́Ã\bhŕԂMapList
     * 쐬鏈ĂB
     * @return oChp[^MapList
     */
    public List getBindParametersMapList() {
        return prametersList;
    }
    
    /**
     * JavaBeans̕ϊIuWFNgClassԂB<p>
     * @since 1.2.0
     * @return ϊIuWFNgClass
     */
    public Class getReslutClass() {
        return this.resultClass;
    }


    /**
     * toString()̃I[oChB<p>
     * @return CX^X̕\L
     */
    public String toString() {
        
        String LS = System.getProperty("line.separator");
        
        StringBuffer sqlStr = new StringBuffer(LS); 
        sqlStr.append("[Query =");
        sqlStr.append(LS);
        sqlStr.append(" Result =[");
        sqlStr.append(resultClass);
        sqlStr.append("]");
        sqlStr.append(LS);
        sqlStr.append(" Query string=[");
        sqlStr.append(LS);
        sqlStr.append("    ");
        sqlStr.append(sqlString);
        sqlStr.append("]");
        sqlStr.append(LS);
        
        StringBuffer bindStr = new StringBuffer();
        bindStr.append(" Baind parameters=[" + LS);
        for (int i=0; i<prametersList.size(); i++) {
            int id = i + 1;
            Map paramMap = (Map)prametersList.get(i);
            bindStr.append("    id:");
            bindStr.append(id); 
            bindStr.append(" value:");
            bindStr.append(paramMap.get(DaoKeys.VALUE_KEY));
            bindStr.append(" type:");
            bindStr.append(paramMap.get(DaoKeys.TYPE_KEY));
            bindStr.append(LS);
        }
        bindStr.append(" ]" + LS + "]");
        
        return sqlStr.append(bindStr).toString();
    }
}
