/*
 * Copyright 2006 Robbie.JP
 */
package robbie.dao.resource;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import robbie.dao.ConnectionWrapper;


/**
 * JdbcConnectionWrapperNXB<p>
 * @since 
 */
public class JdbcConnectionWrapper extends ConnectionWrapper {

    private static final long serialVersionUID = -206755455187045054L;
    
    private static Log LOG = LogFactory.getLog(JdbcConnectionWrapper.class);
    
    /**
     * ConnectionCX^Xw肵ăCX^X쐬B<p>
     * @param conn ConnectionCX^X
     */
    public JdbcConnectionWrapper(Connection conn) {
        super(conn);
    }
    
    /**
     * ConnectionCX^XAI[gR~bg[hw肵ăCX^X쐬B<p>
     * @param conn ConnectionCX^X
     * @param isAutoCommit I[gR~bg[h
     */
    public JdbcConnectionWrapper(Connection conn, boolean isAutoCommit) {
        super(conn, isAutoCommit);
    }
    
    /**
     * ConnectionSɕ܂B<p>
     * <b>ӂĂ</b>
     * APIConnectionC^tF[Xɂ݂͑܂B
     * Robbie DAO Ver1.1.0ȍ~͂̃\bh𖾎IɌĂяoȂƁA
     * RlNV͕܂B
     */
    public void closeConnection() throws SQLException {
        
        if (conn  != null || !conn.isClosed()) {
            conn.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("RlNV܂. Connection=" + conn);
            }
        }
    }
    
    /**
     * Connection܂B<p>
     * <b>ӂĂ</b>
     * Robbie DAO Ver 1.0.x܂ł́AʏJDBC APIʂɃRlNV܂A
     * Ver1.1.0ȍ~̓R~bgăRlNV͕܂B
     */
    public void close() throws SQLException {
        
        if (LOG.isDebugEnabled()) {
            LOG.debug(
                    " gUNVR~bg܂." +
                    " ARlNV͕Ă܂." +
                    " Connection=" + conn);
        }
        conn.commit();
    }
}
