/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.s;

import java.util.Map;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.List;
import java.util.ArrayList;

import java.sql.Types;

import robbie.dao.DaoKeys;
import robbie.dao.QuerySupport;
import robbie.util.ClassFactory;

/**
 * sSQL̃bpNXB<p>
 */
public class SQuery extends QuerySupport {
    
    private static final long serialVersionUID = -8728093809571144384L;

    private Object[] params = null;
    private Integer[] types = null;
    private int count = 0;
    
    /**
     * RXgN^B<p>
     * sSQLݒ肵ĂB
     * @param sql PreparedStatementɐݒ肷SQL
     */
    public SQuery(String sql) {
        init(sql);
    }
    
    /**
     * oϐ̏s܂B<p>
     * ̃\bh̓RXgN^ĂяoĂ܂B
     * {IɊgKv͂܂B
     * @param sql PreparedStatementɐݒ肷SQL
     */
    protected void init(String sql) {
        this.sqlString = sql;
        this.count = getBindValiableCount(sql);
        this.params = new Object[count];
        this.types = new Integer[count];
    }
    
    /**
     * oChϐǉ܂B<p>
     * @param num oChuHv
     * @param value l
     * @param type java.sql.Typesɐݒ肳Ă^Bvaluenull̏ꍇɕKvB
     */
    public void addBindParameter(int num, Object value, Integer type) {
        
        if ( num < 1 || num > count ) {
            return;
        }
        if (type == null) {
            type = new Integer(Types.VARCHAR);
        }
        params[num-1] = value;
        types[num-1] = type;
    }
    
    /**
     * oChϐǉ܂B<p>
     * Ȃǂ͂ŁAZbgł܂B
     * @param num oChuHv
     * @param value l
     */
    public void addBindParameter(int num, Object value) {
        addBindParameter(num, value, null);
    }
    
    /**
     * JavaBeansւ̕ϊClassZbg܂B<p>
     * @since 1.2.0
     * @param resultClsss ϊClass
     */
    public void setResultClass(Class resultClsss) {
        resultClass = resultClsss;
    }
    
    /**
     * JavaBeansւ̕ϊClassZbg܂B<p>
     * @since 1.2.0
     * @param resultClassName ϊClass̖
     */
    public void setResultClassName(String resultClassName) throws ClassNotFoundException {
        resultClass = ClassFactory.getClass(resultClassName);
    }
    
    /**
     * configure()̎B<p>
     * oChϐSăZbgIĂA
     * ̃\bhĂяoĂB
     */
    public void configure() {
        
        List list = new ArrayList();
        for(int i=0; i<count; i++) {
            Map map = new HashMap();
            map.put(DaoKeys.VALUE_KEY, params[i]);
            map.put(DaoKeys.TYPE_KEY, types[i]);
            list.add(map);
        }
        prametersList = list;
    }
    
    /**
     * ZbgꂽSQLoChϐ̐ZoB<p>
     * @param sql SQL̕
     * @return@oChϐ̐
     */
    private int getBindValiableCount(String sql) {
        
        StringTokenizer fulltoken = new StringTokenizer(sql, "?", true);
        StringTokenizer token = new StringTokenizer(sql, "?", false);
        int count = fulltoken.countTokens() - token.countTokens();
        
        return count;
    }
}
