/*
 * Copyright 2006 Robbie.JP
 */
package robbie.dao.x;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * GeneralXDaoNXB<p>
 * <pre>
 * XDao͈ÖٓIȃgUNVŁÃ\bh1gUNVƂ
 * sĂ܂܂B(ACMTɂEJBł͕Kł͂܂)
 * ̌ʁAIɃgUNV邽߂ɂ́AXDaopgDao
 * 쐬Kv܂B
 * 
 * AGeneralXDao͊gsȂĂAIȃgUNVsł悤
 * BaseDaöꕔAPIpublicɂ̂ɂȂ܂B
 * 
 * ɂāAOJTAȂǂgpĖIȃgUNVADao
 * gUNV̓Ƃ邱Ƃ\łB
 * 
 * ȉAR[fBOɂȂ܂B
 * 
 *         XDaoFactory factory = new XDaoFactory("etc/test-config.xml");
 *         GeneralXDao dao = (GeneralXDao)factory.createDaoInstance("GeneralXDao");
 *         
 *         try {
 *             // Connection̎擾
 *             dao.openConnection();
 *             dao.setAutoCommit(false);
 *             
 *             // p[^Map̐ݒ
 *             Map params = new HashMap();
 *             params.put("id", new Integer(4));
 *             params.put("name", "EEE");
 *             params.put("age",  new Integer(4));
 *             
 *             int count = dao.executeUpdate("test9", params);
 *             if (count != 1) {
 *                 dao.rollback();
 *             } else {
 *                 dao.commit();
 *             }
 *             
 *             System.out.println("updateCount=" + count);
 *             
 *         } catch(Exception ex) {
 *             try {
 *                 dao.rollback();
 *             } catch(Exception ex2) {
 *                 
 *             }
 *             throw ex;
 *         } finally {
 *             try {
 *                 // Connection
 *                 dao.closeConnection();
 *             } catch(Exception ex) {
 *                 // Ȃ
 *             }
 *         }
 * 
 * L̂悤StandaloneXDaȍꍇɂ́ARlNVopen/closeAїO
 * ǗsKv܂Acommit/rollbackgp_ȏTuNX
 * 쐬ȂĂ\ɂȂ܂B
 * 
 * </pre>
 * @see robbie.dao.BaseDao
 * @see robbie.dao.x.XDao
 * @since 1.0.1
 */
public class GeneralXDao extends XDao {

    private static final long serialVersionUID = -3455411682967958400L;

    /**
     * VKɃf[^x[XRlNVI[v܂B<p>
     * @throws SQLException
     */
    public void openConnection() throws SQLException {
        super.setConnection(resource.getConnection());
    }
    
    // JavaDocsv
    public void closeConnection() throws SQLException {
        super.closeConnection();
    }
    
    // JavaDocsv
    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }
    
    // JavaDocsv
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        super.setAutoCommit(isAutoCommit);
    }
    
    // JavaDocsv
    public void commit() throws SQLException {
        super.commit();
    }

    // JavaDocsv
    public void rollback() throws SQLException {
        super.rollback();
    }
    
    /**
     * BaseDao#executeQuery(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeQuery(robbie.dao.Query)
     * @param id queryid
     * @param params p[^Map
     * @return MapList
     * @throws SQLException
     */
    public List executeQuery(String id, Map params) throws SQLException {
        return executeQuery(queryFactory.createQueryInstance(id, params));
    }
    
    /**
     * BaseDao#executeQueryForArray(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeQueryForArray(robbie.dao.Query)
     * @param id queryid
     * @param params p[^Map
     * @return ₢킹ʂ2z
     * @throws SQLException
     */
    public Object[][] executeQueryForArray(String id, Map params) throws SQLException {
        return executeQueryForArray(queryFactory.createQueryInstance(id, params));
    }
    
    /**
     * BaseDao#executeQueryForBeans(Query, Class)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeQueryForBeans(robbie.dao.Query, Class)
     * @param id queryid
     * @param params p[^Map
     * @return JavaBeansList
     * @throws SQLException
     * @deprecated
     */
    public List executeQueryForBeans(String id, Map params, Class beanClass) throws SQLException {
        return executeQueryForBeans(queryFactory.createQueryInstance(id, params), beanClass);
    }
    
    /**
     * BaseDao#executeQueryForBeans(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeQueryForBeans(robbie.dao.Query)
     * @param id queryid
     * @param params p[^Map
     * @return JavaBeansList
     * @throws SQLException
     * @since 1.2.0
     */
    public List executeQueryForBeans(String id, Map params) throws SQLException {
        return executeQueryForBeans(queryFactory.createQueryInstance(id, params));
    }
    
    /**
     * BaseDao#executeUpdate(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeUpdate(robbie.dao.Query)
     * @param id queryid
     * @param params p[^Map
     * @return XV
     * @throws SQLException
     */
    public int executeUpdate(String id, Map params) throws SQLException {
        return executeUpdate(queryFactory.createQueryInstance(id, params));
    }
    
    /**
     * BaseDao#executeUpdate(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeUpdate(robbie.dao.Query)
     * @param id queryid
     * @param bean p[^ƂȂJavaBean
     * @return XV
     * @throws SQLException
     */
    public int executeUpdate(String id, Object bean) throws SQLException {
        return executeUpdate(queryFactory.createQueryInstance(id, bean));
    }
}
