/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

import java.net.URL;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.jdom.Element;

import robbie.util.CollectionsUtil;
import robbie.util.InstanceFactory;
import robbie.util.JdomXmlLoader;

/**
 * XDAOFactoryNXB<p>
 * w肳ꂽt@CɊÂāADAOCX^X𐶐܂B
 */
public class XDaoFactory implements Serializable {
    
    private static final long serialVersionUID = -7266751084337417590L;

    private static final Log LOG = LogFactory.getLog(XDaoFactory.class);
    
    /** XQueryFactoryClass */
    protected String xQueryFactoryClassName = XQueryFactory.class.getName();
    
    /** XDbResourceFactoryClass */
    protected String xDBResourceFactoryClassName = XDbResourceFactory.class.getName();
    
    /** t@CFilepath */
    protected String filepath = null;
    
    /** XQueryFactorỹCX^X */
    protected XQueryFactory queryFactory = null;
    
    /** XDBResourceFactorỹCX^X */
    protected XDbResourceFactory resourceFactory = null;
    
    /** DAÕNXǗMap */
    protected Map daoNameMap = null;
    
    /** DAOƗpDbResource̊֘AǗMap */
    protected Map daoResRefMap = null;
    
    // init inputStream 1970/1/1 00:00:00:000
    /** t@C̍XV */
    protected long lastModifiedTimestamp = 0;
    
    /** XML̃[hɌ؂sBftHg͍sȂ */
    protected boolean isValidate = false;
    
    /**
     * ftHgRXgN^B<>
     */
    private XDaoFactory() {
        // ȂB
    }

    /**
     * t@C琧t@CǍݏȂ܂B<p>
     * filenaméAt@Cłt@CPATHłw肷邱Ƃ\łB
     * At@Cw肷ꍇɂ́Ãt@CclasspathɔzuĂ
     * Kv܂B<br> 
     * <br>
     * ܂AJARt@CŌꍇɂ́A[h͍s܂B
     * ʏ̃fBNgŌꍇɂ̓t@CX^vmF
     * [hs܂B
     * @param filename t@C
     */
    public XDaoFactory(String filename) {
        
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("p[^filenameNULL0ł");
        }
        
        try {
            String filepath = null;
            
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            
            /* debug */
            /*
            Class loaderClass = loader.getClass();
            Class[] loaderClasses = loaderClass.getInterfaces();
            for(int i=0; i<loaderClasses.length; i++) {
                System.out.println("Class[" + i + "]=" + loaderClasses[i]);
            }
            */
            
            URL url = loader.getResource(filename);
            
            if (url != null) {
                filepath = url.getFile();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(
                        " CLASSPATHURLCX^X쐬ł܂. filename=" + filename + 
                        " URLCX^XgetFile()gpFileInputStream쐬܂. filepath=" + filepath);
                }
                try {
                    configure(new FileInputStream(filepath));
                } catch(FileNotFoundException ex) {
                    
                    // t@CVXeȊȌꏊ(JARt@CȂ)Ńt@Cꍇ
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(
                            " FileInputStream̍쐬Ɏs܂. filepath=" + filepath + 
                            " URL#openStream()InputStream쐬ďs܂. " +
                            " Ȁꍇt@CX^vmFĒ`̃[h͍s܂B.");
                    }
                    configure(url.openStream());
                    return;
                }
            } else {
                filepath = filename;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(
                        " CLASSPATH܂t@C܂ł. filename=" + filename + 
                        " t@CPATHƂFileInputStream쐬܂.");
                }
                configure(new FileInputStream(filename));
            }
            
            // [hp̃t@CpXƃ^CX^vۑ
            this.filepath = filepath;
            this.lastModifiedTimestamp = (new File(filepath)).lastModified();
            
        } catch(FileNotFoundException ex) {
            LOG.error("t@C܂ł. filepath = "+ filename, ex);
            throw new XDaoException("file not found. filepath = "+ filename, ex);
        } catch(IOException ex) {
            LOG.error("t@C܂ł. filepath = "+ filename, ex);
            throw new XDaoException("file not found. filepath = "+ filename, ex);
        }
    }
    
    /**
     * w肵InputStream琧t@CǍݏȂ܂B<p>
     * @param inputStream w肵InputStream
     */
    public XDaoFactory(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputSreamNULLł.");
        }
        configure(inputStream);
    }
    
    /**
     * DAOCX^X擾B<p>
     * VKDAO쐬Ƃ́A̎̍ŐV̐XML̓e
     * fB
     * @param id DAOID
     * @param loader 쐬CX^XClassLoader
     * @return xDAOCX^X
     */
    public XDao createDaoInstance(String id, ClassLoader loader) {
        
        reconfigureIfNeeded();
        if (!daoNameMap.containsKey(id)) {
            throw new XDaoException("id=[" + id + "]QueryXMLɒ`Ă܂.");
        }
        Object obj = InstanceFactory.createInstance((String)daoNameMap.get(id), loader);
        XDao dao = (XDao)obj;
        dao.setQueryFactory(queryFactory);
        dao.setResource(resourceFactory.getDbResource((String)daoResRefMap.get(id)));
        dao.configure();
        return dao;
    }
    
    /**
     * DAOCX^X擾B<p>
     * VKDAO쐬Ƃ́A̎̍ŐV̐XML̓e
     * fB
     * @param id DAOID
     * @return xDAOCX^X
     */
    public XDao createDaoInstance(String id) {
        return createDaoInstance(id, null);
    }
    
    /**
     * SĂ̐XV܂B<p>
     * ͓̏Ă܂B
     * @param inputStream RootElementǂݍނ߂InputStream
     */
    protected void configure(InputStream inputStream) {
        
        Element root = loadRootElemet(inputStream);
        
        // ver1.1܂ł͓Ă܂łA
        // ver1.2瓯܂B
        // A̓Sł͂܂B
        if (resourceFactory != null) {
            synchronized(resourceFactory) {
                configureResourceFactory(root);
                conifgureDAOMap(root);
                configureQueryFactory(root);
            }
        } else {
            configureResourceFactory(root);
            conifgureDAOMap(root);
            configureQueryFactory(root);
        }
    }
    
    /**
     * t@C̃^CX^vXVĂ΁A[hB<p>
     * t@C̑InputStreamǂݍ܂ꂽꍇɂ͉ȂB
     */
    protected void reconfigureIfNeeded() {
        
        if(filepath != null) {
            long nowLastModifiedTimestamp = (new File(filepath)).lastModified();
            if (nowLastModifiedTimestamp > lastModifiedTimestamp) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("reload config file." + 
                        " filepath=" + this.filepath +
                        " ܂ł̃^CX^v = " + new Date(lastModifiedTimestamp) + 
                        " XVꂽ^CX^v = " + new Date(nowLastModifiedTimestamp));
                }
                try{
                    configure(new FileInputStream(filepath));
                    this.lastModifiedTimestamp = nowLastModifiedTimestamp;
                } catch(FileNotFoundException ex) {
                    throw new XDaoException("t@C܂. filepath=" + filepath, ex);
                }
            }
        }
    }
    
    /**
     * InputStream琧XMLElementǂݍ݂܂B<p>
     * @param inputStream RootElementǂݍނ߂InputStream
     * @return rootElement
     */
    protected Element loadRootElemet(InputStream inputStream) {
        
        try {
            return JdomXmlLoader.load(inputStream, isValidate);
        } catch(Exception ex) {
            throw new XDaoException("XMLt@C[hɗOo܂.", ex);
        }
    }
    
    /** 
     * XDbResourceFactoryNX쐬܂B<p>
     * @param root XMLrootElement
     */
    protected void configureResourceFactory(Element root) {
        
        if (LOG.isDebugEnabled()) {
            LOG.debug(
                "configureResourceFactory(): XDbResourceFactorỹNX=" + 
                this.xDBResourceFactoryClassName);
        }
        
        XDbResourceFactory factory = 
            (XDbResourceFactory)InstanceFactory.createInstance(this.xDBResourceFactoryClassName);
        factory.configure(root.getChild("resource-list"));
        this.resourceFactory = factory;
    }
    
    /**
     * DAÕNXƑΏۃ\[XMapt@C[hB<p>
     * @param root XMLrootElement
     */
    protected void conifgureDAOMap(Element root) {
        
        Element daoList = root.getChild("dao-list");
        if (daoList == null) {
            throw new XDaoException("dao-listvfNULLł.");
        }
        List list = daoList.getChildren("dao");
        if (list != null && list.size() > 0) {
            Map nameMap = CollectionsUtil.createMap();
            Map refMap = CollectionsUtil.createMap();
            for (Iterator it=list.iterator(); it.hasNext(); ) {
                Element ele = (Element)it.next();
                String id = ele.getAttributeValue("id");
                if (id == null) {
                    throw new XDaoException("daovfidNULLł.");
                }
                String calssName = null;;
                String refResoauce = null;
                try {
                    calssName = ele.getChild("class").getText();
                    refResoauce = ele.getChild("resource-ref").getText();
                } catch(Exception ex) {
                    throw new XDaoException("class-namevfA܂resource-refvfnullł.", ex); 
                }
                if (nameMap.containsKey(id) && LOG.isDebugEnabled()) {
                    LOG.warn("x! DAOid=[" + id + "]͊ɒ`݂܂. Vŏ㏑܂.");
                }
                nameMap.put(id, calssName);
                refMap.put(id, refResoauce);
            }
            this.daoNameMap = nameMap;
            this.daoResRefMap = refMap;
            
            if (LOG.isDebugEnabled()) {
                LOG.debug("XDao Name " + this.daoNameMap);
                LOG.debug("XDao Reource-ref " + this.daoResRefMap);
            }
        }
    }
    
    /**
     * XQueryFactoryNX쐬܂B<p>
     * @param root XMLrootElement
     */
    protected void configureQueryFactory(Element root) {
        
        if (LOG.isDebugEnabled()) {
            LOG.debug(
                "configureQueryFactory(): XQueryFactorỹNX=" + 
                this.xQueryFactoryClassName);
        }
        
        XQueryFactory factory = 
            (XQueryFactory)InstanceFactory.createInstance(this.xQueryFactoryClassName);
        factory.configure(root.getChild("query-list"));
        this.queryFactory = factory;
    }
}
