/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

import robbie.dao.DbConnectionUtil;
import robbie.dao.resource.DataSourceResource;
import robbie.dao.resource.DbResource;
import robbie.dao.resource.JdbcOdbcResource;
import robbie.dao.resource.JdbcResource;
import robbie.util.CollectionsUtil;

/**
 * XML`DbResourceCX^X쐬ĊǗNX.<p>
 */
public class XDbResourceFactory {

    private static final Log LOG = LogFactory.getLog(XDbResourceFactory.class);
    
    /** DbResourcẽCX^XێMap */
    protected Map resourceMap = null;
    
    /**
     * ftHgRXgN^B<p>
     */
    public XDbResourceFactory() {
        // Ȃ
    }
    
    /**
     * w肵IDDbResourcẽCX^XԂ܂B<p>
     * @param id DbResourcew肷ID
     * @return DbResourcẽCX^X
     */
    public DbResource getDbResource(String id) {
        return (DbResource)resourceMap.get(id);
    }
    
    /**
     * ݒt@CDbResourcẽCX^X쐬ێ܂B<p>
     * @param resourceListElement Resource`ȂElement
     */
    public void configure(Element resourceListElement) {
        
        List list = resourceListElement.getChildren("resource");
        if (list != null && list.size() > 0) {
            Map map = CollectionsUtil.createMap();
            for (Iterator it=list.iterator(); it.hasNext(); ) {
                Element ele = (Element)it.next();
                String id = ele.getAttributeValue("id");
                if (id == null || id.length() == 0) {
                    throw new XDaoException("resoucevf̑'id'NULL0ł.");
                }
                String type = ele.getAttributeValue("type");
                if (map.containsKey(id)  && LOG.isDebugEnabled()) {
                    LOG.warn("x! resourceid=[" + id + "]͊ɒ`݂܂. Vŏ㏑܂.");
                }
                map.put(id, createXDbResource(type, ele));
            }
            this.resourceMap = map;
            
            if (LOG.isDebugEnabled()) {
                LOG.debug("XDbReource̒`MapF" + this.resourceMap);
            }
            
        } else {
            throw new XDaoException("'resource'vfNULLł.");
        }
    }
    
    /**
     * resoucevfDbResourcẽCX^X쐬܂B<p>
     * {IɂXDbResourceFactory͊g̕Kv͂܂񂪁AƎ̕@
     * Connection擾Kvꍇɂ́Ã\bhgĂB
     * @param type Connection̎擾@TYPE
     * @param ele resoucevfElement
     * @return XDbResourceCX^X
     */
    protected DbResource createXDbResource(String type, Element ele) {
        
        DbResource resource = null;
        if ("DataSource".equals(type)) {
            
            // Server JDBCiDataSourcejpXML\[XǗ
            String jndiName =null;
            try {
                jndiName = ele.getChild("jndi-name").getText();
                if (jndiName == null || jndiName.length() == 0) {
                    throw new XDaoException("'jndi-name'NULL0ł.");
                }
            } catch(Exception ex) {
                throw new XDaoException("'jndi-name'vfNULLł.");
            }
            resource =  new DataSourceResource(jndiName);
            
        } else if ("JDBC".equals(type)) {
            
            // Local JDBCpXML\[XǗ
            Properties env = null;
            try {
                env = DbConnectionUtil.createConnectionProperties(
                        ele.getChild("driver").getText(),
                        ele.getChild("url").getText(),
                        ele.getChild("username").getText(),
                        ele.getChild("password").getText());
            } catch(Exception ex) {
                throw new XDaoException("'driver','url','username','password'vf̂ꂩNULLł.");
            }
            resource = new JdbcResource(env);
            
        } else if ("JDBC-ODBC".equals(type)) {
            
            // JDBC-ODBCpXML\[XǗ
            String sourceName = null;
            try {
                sourceName = ele.getChild("odbc-data-source").getText();
                if (sourceName == null || sourceName.length() == 0) {
                    throw new XDaoException("'odbc-data-source'NULL0ł.");
                }
            } catch(Exception ex) {
                throw new XDaoException("'odbc-data-source'vfNULLł.");
            }
            resource = new JdbcOdbcResource(sourceName);
            
        } else {
            throw new XDaoException("\[Xtypev܂. type=" + type);
        }
        return resource;
    }
}
