/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Text;

import robbie.dao.DaoKeys;
import robbie.dao.DaoTypes;
import robbie.dao.QuerySupport;

import robbie.util.ClassFactory;


/**
 * XMLɒ`ꂽ񂩂AIɎsSQLƃoChϐMapList
 * 쐬Query̎NXB<p>
 */
public class XQuery extends QuerySupport {
    
    private static final long serialVersionUID = -3624781312816832754L;

    private static final Log LOG = LogFactory.getLog(XQuery.class);

    /** Query-ID */
    protected String queryId = null; 
    
    /** SQL̏Element */
    protected Element element = null;
    
    /** oChp[^Map */
    protected Map parameters = null;
    
    /**
     * ftHgRXgN^B<>
     */
    public XQuery() {
        super();
    }
    
    /**
     * SQL`ElementIuWFNgZbgB<p>
     * @param element SQL`ElementIuWFNg
     */
    public void setElement(Element element) {
        this.element = element;
    }

    /**
     * oChϐ̓MapZbgB<p>
     * @param parameters
     */
    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }
    
    /**
     * sSQLƁAp[^List쐬B<p>
     * ͓̏Ă܂B
     */
    public void configure() {
        
        if (element == null) {
            throw new IllegalArgumentException("queryvfNULLł");
        }
        
        long startdate = 0;
        
        // debug
        if (LOG.isDebugEnabled()) {
            startdate = (new Date()).getTime();
            LOG.debug("Query̍\zJn܂.");
        }
        
        // oChϐi[Listnew
        prametersList = new ArrayList();
        
        // SQL쐬ăoϐփZbg
        String className = this.element.getAttributeValue("result");
        try {
            if (className != null && className.length() > 0) {
                resultClass = ClassFactory.getClass(className);
            }
        } catch(Exception ex) {
            throw new XDaoException("ϊBeanClass̐Ɏs܂B" +
                    "ŏ𒆒f܂BClass name=[" + className + "]", ex);
        }
        this.queryId = this.element.getAttributeValue("id");
        sqlString = handleQueryElement(this.element);
        
        // debug
        if (LOG.isDebugEnabled()) {
            long configuretime = (new Date()).getTime() - startdate;
            LOG.debug("Query̍\zI܂. vԂ " + configuretime +"(ms)ł.");
            LOG.debug(this);
        }
    }
    
    /**
     * &lt;query&gt;A&lt;subquery&gt;A&lt;case&gt;A&lt;default&gt;vfSQL𐶐B<p>
     * <pre>
     * queryAswitchAlistAwhereAvarArepeatAbetweenvfACDATALq\łB
     * eLXgLȂ̂́AqueryAcase(default)Asubqueryvf
     * ̃Reĉ݂łB
     * ̑whereAswitchAlistvfł́AeLXg͋܂B
     * ܂A̋tqueryAcase(default)Asubqueryvf̒łconstvf͎gpo܂B
     * constvfwherelistvfł̂ݎgpł܂B
     * </pre>
     * @param ele
     * @return SQL(LSQL񂪐łȂꍇɂnull)
     */
    protected String handleQueryElement(Element ele) {
        
        StringBuffer sqlStrBuff = new StringBuffer();
        List children = ele.getContent();
        for (Iterator it=children.iterator(); it.hasNext(); ) {
            Object obj = it.next();
            
            // ̏
            if (obj instanceof String) {
                sqlStrBuff.append((String)obj);
                continue;
            }
            // Text̏iJDOM 1.0 Ήj
            if (obj instanceof Text) {
                sqlStrBuff.append(((Text)obj).getText());
                continue;
            }
            
            // Element̏
            String eleStr = null;
            Element child = (Element)obj;
            if (child.getName().equals("var")) {
                eleStr =  handleVarElement(child);
            } else if (child.getName().equals("repeat")) { 
                eleStr =  handleRepeatElement(child);
            } else if (child.getName().equals("between")) { 
                eleStr =  handleBetweenElement(child);
            } else if (child.getName().equals("switch")) {
                eleStr =  handleSwitchElement(child);
            } else if (child.getName().equals("list")) {
                eleStr =  handleListElement(child);
            } else if (child.getName().equals("where")) {
                eleStr =  handleWhereElement((Element)obj);
            } else {
                throw new XDaoException("vf܂." +
                        " query id=" + this.queryId +
                        " element=" + ele.getName());
            }
            
            if (eleStr != null) {
                sqlStrBuff.append(eleStr);
            }
        }
        if (XQueryUtil.isSpaceOnly(sqlStrBuff.toString())) {
            return null;
        }
        return sqlStrBuff.toString();
    }
    
    /**
     * &lt;const&gt;vfSQL𐶐B<p>
     * <pre>
     * ̗vf́AvarArepeatAbetweenƓlleafi}̐[jƂȂvfłB
     * qvf݂͑܂B
     * ܂AconstvfwherevfA܂listvfł̂ݎwł܂B
     * </pre>
     * @param ele
     * @return SQL(񂪐łȂꍇɂnull)
     */
    protected String handleConstElement(Element ele) {
        
        String reqStr = ele.getAttributeValue("req");
        if (reqStr != null) {
            Boolean isRequired = Boolean.valueOf(reqStr);
            String keyStr = ele.getAttributeValue("key");
            if (isRequired.booleanValue()) {
                if(keyStr == null || keyStr.length() == 0 || !parameters.containsKey(keyStr)) {
                    // key݂ȂA܂͒l͂ĂȂB
                    throw new XDaoException("reqvf݂̂Ƀp[^Mapɒl݂܂." +
                            " query id=" + this.queryId +
                            " element=" + ele.getName() +
                            " req=" + reqStr +
                            " key=" + keyStr);
                }
            } else {
                if (keyStr == null || keyStr.length() == 0 || !parameters.containsKey(keyStr)) {
                    // K{łȂMapKey܂܂Ȃꍇɂ͓WJȂ
                    return null;
                }
            }
        }
        String sqlStr = ele.getText();
        if (XQueryUtil.isSpaceOnly(sqlStr)) {
            return null;
        }
        return sqlStr;
    }
    
    /**
     * &lt;var&gt;vfSQL𐶐B<p>
     * <pre>
     * varvfɂ́Ap[^ɑΉoChϐuHv
     * ܂ރeLXgł邱Ƃz肳Ă܂B
     * qvfꍇɂ͖܂B
     * ܂Ap[^݂Ȃꍇɂ̗͂vf݂̑
     * 邽߁AISQL쐬ꍇɂvarvf
     * whereAlistvf𗘗pSQL`܂B
     * </pre>
     * @param ele
     * @return@SQL(񂪐łȂꍇɂnull)
     */
    protected String handleVarElement(Element ele) {
        
        String keyStr = ele.getAttributeValue("key");
        if(keyStr == null) {
            // key݂ȂA܂͒l͂ĂȂB
            throw new XDaoException("key݂܂." +
                    " query id=" + this.queryId +
                    " element=" + ele.getName());
        }
        // lMapɓĂ邩H
        if(parameters == null || !parameters.containsKey(keyStr)) {
            if(ele.getAttributeValue("req") == null) {
                // req݂ȂA܂͒l͂ĂȂB
                throw new XDaoException("varvfreq݂܂." +
                        " query id=" + this.queryId +
                        " element=" + ele.getName());
            }
            // (ĂȂ)̃p[^͕K{H
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XDaoException(
                    " varvfreqtrueȂ̂Ƀp[^Mapɑ݂܂." +
                    " query id=" + this.queryId +
                    " key=" + keyStr);
            }
            // K{łȂΉȂ
            return null;
        } 
        
        String typeStr = ele.getAttributeValue("type");
        Object valueObj = parameters.get(keyStr);
        if (valueObj != null && valueObj.getClass().isArray()) {
            // p[^z̏ꍇɂ́A
            // ڂ̒lZbgB
            valueObj = ((Object[])valueObj)[0];
        }
        if (ele.getAttribute("like") != null) {
            valueObj = handleLikeAttribute(ele.getAttributeValue("like"), valueObj);
        }
        Map parameterMap = new HashMap();
        parameterMap.put(DaoKeys.VALUE_KEY, valueObj);
        parameterMap.put(DaoKeys.TYPE_KEY, DaoTypes.getSQLType(typeStr));
        this.prametersList.add(parameterMap);
        return ele.getText();
    }

    /**
     * &lt;repeat&gt;vfSQL𐶐B<p>
     * <pre>
     * {IrepeatvfINq̃f[^WJƂ݂̂Ɏgp܂B
     * ȊO̎gpɂĂ͑z肵Ă܂̂ŒӂĂB
     * ܂Avarvfreqtrueł鎞ƓlɃp[^݂Ȃ
     * G[Ƃ܂B
     * </pre>
     * @param ele 
     * @return@SQL(񂪐łȂꍇɂnull)
     */
    protected String handleRepeatElement(Element ele) {
        
        String keyStr = ele.getAttributeValue("key");
        if(keyStr == null) {
            //@key݂ȂA܂͒l͂ĂȂB
            throw new XDaoException("repeatvfkey݂܂." +
                    " query id=" + this.queryId +
                    " element=" + ele.getName());
        }
        // lMapɓĂ邩H
        if(parameters == null || !parameters.containsKey(keyStr)) {
            if(ele.getAttributeValue("req") == null) {
                // req݂ȂA܂͒l͂ĂȂB
                throw new XDaoException("repeatvfreq݂܂." +
                        " query id=" + this.queryId +
                        " element=" + ele.getName());
            }
            // (ĂȂ)̃p[^͕K{H
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XDaoException(
                        " repeatvfreqtrueȂ̂Ƀp[^Mapɑ݂܂." +
                        " query id=" + this.queryId +
                        " key=" + keyStr);
            }
            // K{łȂΉȂ
            return null;
        } 
        String sqlStr = null;
        String typeStr = ele.getAttributeValue("type");
        Object valueObj = parameters.get(keyStr);
        if (valueObj.getClass().isArray()) {
            // Zbglzłꍇɂ́A
            // ̒l̐ZbgB
            Object[] valueArray = (Object[])valueObj;
            if (valueArray.length == 0) {
                // lȂnull
                return null;
            }
            StringBuffer bindStr = new StringBuffer();
            for(int i=0; i<valueArray.length; i++) {
                // Zbgl̐AoChϐ̃eLXgύXB
                if (i > 0) {
                    bindStr.append(", ?");
                } else {
                    bindStr.append("?");
                }
                Object setValue = valueArray[i];
                if (ele.getAttribute("like") != null) {
                    setValue = handleLikeAttribute(ele.getAttributeValue("like"), setValue);
                }
                Map parameterMap = new HashMap();
                parameterMap.put(DaoKeys.VALUE_KEY, setValue);
                parameterMap.put(DaoKeys.TYPE_KEY, DaoTypes.getSQLType(typeStr));
                this.prametersList.add(parameterMap);
            }
            // oChϐvCX
            // ł̓eLXg̒ňoChϐ݂邱Ƃz肵ĂB
            sqlStr = ele.getText().replaceFirst("[?]", bindStr.toString());
        } else {
            sqlStr = handleVarElement(ele);
        }
        return sqlStr;
    }
    
    /**
     * &lt;between&gt;vfSQL𐶐B<p>
     * <pre>
     * betweenvfSQLBETWEEN̂悤ɁAQZbgŎw肷Kv
     * ꍇɗp܂B]āAvarƈĂQKEY̑݃`FbN
     * sȂKv܂B
     * ܂A֋XbetweenƂOɂŁAbetweenɂgȂł
     * ܂B  
     * </pre>
     * @param ele
     * @return SQL(񂪐łȂꍇɂnull)
     */
    protected String handleBetweenElement(Element ele) {
        
        String fromKey = ele.getAttributeValue("from");
        if(fromKey == null) {
            // from݂ȂA܂͒l͂ĂȂB
            throw new XDaoException("betweenvffrom݂܂." +
                    " query id=" + this.queryId +
                    " element=" + ele.getName());
        }
        String toKey = ele.getAttributeValue("to");
        if(toKey == null) {
            // to݂ȂA܂͒l͂ĂȂB
            throw new XDaoException("betweenvfto݂܂." +
                    " query id=" + this.queryId +
                    " element=" + ele.getName());
        }
        if (parameters == null 
                || !parameters.containsKey(fromKey)
                || !parameters.containsKey(toKey)) {
            if(ele.getAttributeValue("req") == null) {
                // req݂ȂA܂͒l͂ĂȂB
                throw new XDaoException("betweenvfreq݂܂." +
                        " query id=" + this.queryId +
                        " element=" + ele.getName());
            }
            // (ĂȂ)̃p[^͕K{H
            Boolean isRequired = Boolean.valueOf(ele.getAttributeValue("req"));
            if (isRequired.booleanValue()) {
                throw new XDaoException(
                        " repeatvfreqtrueȂ̂Ƀp[^Mapɑ݂܂." +
                        " query id=" + this.queryId +
                        " from key=" + fromKey +
                        " to key=" + toKey);
            }
            // K{łȂΉȂ
            return null;
        }
        String sqlStr = null;
        Object valueFrom = parameters.get(fromKey);
        if (valueFrom != null && valueFrom.getClass().isArray()) {
            // zȂzCast
            valueFrom = ((Object[])valueFrom)[0];
        }
        Object valueTo = parameters.get(toKey);
        if (valueTo != null && valueTo.getClass().isArray()) {
            // zȂzCast
            valueTo = ((Object[])valueTo)[0];
        }
        // set from value
        Map parameterMap = new HashMap();
        parameterMap.put(DaoKeys.VALUE_KEY, valueFrom);
        parameterMap.put(DaoKeys.TYPE_KEY, null);
        this.prametersList.add(parameterMap);
        
        // set to value
        parameterMap = new HashMap();
        parameterMap.put(DaoKeys.VALUE_KEY, valueTo);
        parameterMap.put(DaoKeys.TYPE_KEY, null);
        this.prametersList.add(parameterMap);
        
        sqlStr = ele.getText();
        return sqlStr;
    }

    /**
     * &lt;switch&gt;vfSQL𐶐B<p>
     * <pre>
     * switchvfł́AcaseAdefault܂B
     * eLXg܂B
     * </pre>
     * @param ele
     * @return SQL(񂪐łȂꍇɂnull)
     */
    protected String handleSwitchElement(Element ele) {
        
        String keyStr = ele.getAttributeValue("key");
        if (keyStr == null) {
            return null;
        }
        if (parameters != null && parameters.containsKey(keyStr)) {
            Object valueObj = parameters.get(keyStr);
            if (valueObj == null) {
                return null;
            }
            List children = ele.getChildren("case");
            for (Iterator it=children.iterator(); it.hasNext(); ) {
                Element child = (Element)it.next();
                if (((String)valueObj).equals(child.getAttributeValue("value"))) {
                    // v<case>̏
                    return handleQueryElement(child);
                }
            }
        }
        // <default>݂Ȃꍇɂ́Anull
        Element defaultCase = ele.getChild("default");
        if (defaultCase == null) {
            return null;
        }
        // <default>̏
        return handleQueryElement(defaultCase);
    }
    
    /**
     * &lt;list&gt;vfSQL𐶐B<p>
     * <pre>
     * listvfł́AeLXg͋܂B
     * ́AlistqElemenťʓm邽߂
     * @\邽߂łB
     * ]varArepeat, constAlistAswitchAsubquery̗vf
     * 󔒕݂̂Ac̗vf͖܂B
     * A󔒕ɑ΂ĂjoinŌ͍sȂ܂B
     * </pre>
     * @param ele
     * @return SQL(񂪐łȂꍇɂnull)
     */
    protected String handleListElement(Element ele) {
        
        StringBuffer sqlStrBuff = new StringBuffer();
        String joinStr = " ";
        if (ele.getAttribute("join") != null) {
            joinStr = " " + ele.getAttributeValue("join") + " ";
        }
        boolean isFirstContent = true;
        List contents = ele.getContent();
        for (Iterator it = contents.iterator(); it.hasNext();) {
            Object obj = it.next();
            
            // ̏
            if (obj instanceof String && XQueryUtil.isSpaceOnly((String)obj)) {
                sqlStrBuff.append((String)obj);
                continue;
            }
            // Text̏iJDOM 1.0 Ήj
            if (obj instanceof Text && XQueryUtil.isSpaceOnly(((Text)obj).getText())) {
                sqlStrBuff.append(((Text)obj).getText());
                continue;
            }
            
            // Element̏
            if (obj instanceof Element) {
                String eleStr = null;
                String eleType = ((Element)obj).getName();
                if (eleType.equals("list")) {
                    eleStr = handleListElement((Element)obj);
                    if (eleStr != null) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(" ( ");
                        buf.append(eleStr);
                        buf.append(" ) ");
                        eleStr = buf.toString();
                    }
                } else if (eleType.equals("switch")) {
                    eleStr = handleSwitchElement((Element)obj);
                    if (eleStr != null) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(" ( ");
                        buf.append(eleStr);
                        buf.append(" ) ");
                        eleStr = buf.toString();
                    }
                } else if (eleType.equals("subquery")) {
                    eleStr = handleQueryElement((Element)obj);
                    if (eleStr != null) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(" ( ");
                        buf.append(eleStr);
                        buf.append(" ) ");
                        eleStr = buf.toString();
                    }
                } else if (eleType.equals("const")) {
                    eleStr = handleConstElement((Element)obj);
                } else if (eleType.equals("var")) {
                    eleStr = handleVarElement((Element)obj);
                } else if (eleType.equals("repeat")) {
                    eleStr = handleRepeatElement((Element)obj);
                } else if (eleType.equals("between")) {
                    eleStr = handleBetweenElement((Element)obj);
                } else {
                    throw new XDaoException("vf܂." +
                            " query id=" + this.queryId +
                            " element=" + ((Element)obj).getName());
                }
                
                if (eleStr != null) {
                    if (isFirstContent)  {
                        sqlStrBuff.append(" ").append(eleStr);
                        isFirstContent = false;
                        continue;
                    }
                    sqlStrBuff.append(joinStr).append(eleStr);
                }
            }
        }
        String sqlStr = sqlStrBuff.toString();
        if (XQueryUtil.isSpaceOnly(sqlStr)) {
            return null;
        }
        return sqlStr;
    }
    
    /**
     * &lt;where&gt;SQL𐶐B<p>
     * <pre>
     * listvfƂ̈Ⴂ́AjoinZbgĂȂ΁A
     * l"AND"joinZbg邱ƂƁAWHERE
     * 擪ɒǉ邱ƂłB
     * </pre>
     * @param ele
     * @return SQL
     */
    protected String handleWhereElement(Element ele) {
        
        if (ele.getAttribute("join") == null) {
            Attribute attr = new Attribute("join", "AND");
            ele.setAttribute(attr);
        }
        String sqlStr = handleListElement(ele);
        if (sqlStr != null) {
            StringBuffer buf = new StringBuffer("WHERE ");
            buf.append(sqlStr);
            sqlStr = buf.toString();
        }
        return sqlStr;
    }
    
    /**
     * &lt;like&gt;ꍇɂ̓oChϐɃChJ[hǉB<p>
     * ϐStringł͂Ȃꍇɂ́AȂB
     * @param likeStr
     * @param valueObj
     * @return oChϐ
     */
    protected Object handleLikeAttribute(String likeStr, Object valueObj) {
        
        if (valueObj instanceof String) {
            if ("%?%".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append("%");
                buf.append((String)valueObj);
                buf.append("%");
                return  buf.toString();
            }
            if ("?%".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append((String)valueObj);
                buf.append("%");
                return  buf.toString();
            }
            if ("%?".equals(likeStr)) {
                StringBuffer buf = new StringBuffer();
                buf.append("%");
                buf.append((String)valueObj);
                return  buf.toString();
            }
        }
        return valueObj;
    }
    
    /**
     * toString()̃I[oChB<p>
     * @return ̃CX^X̕\L
     */
    public String toString() {
        String ls = System.getProperty("line.separator");
        return ls + 
        "Query-ID=[" + queryId + "]" + super.toString();
    }
}
