/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.html;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import jp.robotbrain.html.HtmlFormException;

public class UtilHtml {
    private UtilHtml() {
    }

    protected static String encodeWideChar(String p_src, String p_charset) {
        try {
            byte[] bsrc = p_src.getBytes(p_charset);
            if (p_src.length() != bsrc.length) {
                return URLEncoder.encode(p_src, p_charset);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return p_src;
    }

    public static String moveURL(String p_currentUrl, String p_nextUrl) throws HtmlFormException {
        int up;
        String dir = "";
        String nextUrl = "";
        if (p_nextUrl.indexOf("http://") == 0 || p_nextUrl.indexOf("https://") == 0) {
            return p_nextUrl;
        }
        if (!UtilHtml.checkUrl(p_currentUrl)) {
            throw new HtmlFormException("method:HtmlUtil.moveUrl-1 p_currentUrl=" + p_currentUrl + " p_nextUrl=" + p_nextUrl);
        }
        dir = p_currentUrl.substring(0, p_currentUrl.lastIndexOf("/"));
        if (dir.length() < 9) {
            dir = p_currentUrl;
        }
        nextUrl = p_nextUrl.replaceAll("(?<![\\.])\\./", "");
        if (p_nextUrl.length() <= 0) {
            return p_currentUrl;
        }
        if (p_nextUrl.substring(0, 1).equals("/")) {
            String host = UtilHtml.extractHost(p_currentUrl);
            if (host == null) {
                throw new HtmlFormException("method:HtmlUtil.moveUrl-4 p_currentUrl=" + p_currentUrl + " p_nextUrl=" + p_nextUrl);
            }
            return String.valueOf(host) + p_nextUrl;
        }
        while ((up = nextUrl.indexOf("../")) >= 0) {
            if (up != 0) {
                throw new HtmlFormException("method:HtmlUtil.moveUrl-2 p_currentUrl=" + p_currentUrl + " p_nextUrl=" + p_nextUrl);
            }
            if (!UtilHtml.checkUrl(dir = p_currentUrl.substring(0, dir.lastIndexOf("/")))) {
                throw new HtmlFormException("method:HtmlUtil.moveUrl-3 p_currentUrl=" + p_currentUrl + " p_nextUrl=" + p_nextUrl);
            }
            nextUrl = nextUrl.substring(3);
        }
        return String.valueOf(dir) + "/" + nextUrl;
    }

    private static String extractHost(String p_url) {
        if (p_url.indexOf("http://") == 0) {
            String host = p_url.substring(7);
            int pos = host.indexOf("/");
            if (pos < 0) {
                return p_url;
            }
            return "http://" + host.substring(0, pos);
        }
        if (p_url.indexOf("https://") == 0) {
            String host = p_url.substring(8);
            int pos = host.indexOf("/");
            if (pos < 0) {
                return p_url;
            }
            return "https://" + host.substring(0, pos);
        }
        return null;
    }

    private static boolean checkUrl(String p_url) {
        return p_url.lastIndexOf("http://") >= 0 || p_url.lastIndexOf("https://") >= 0;
    }
}

