/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalBlock;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeSignalBlock;

@TypeSignalBlock
@EnabledDefaultSignal
@GeneDefaultLabelList(values={"count"})
@InputComponentList(values={"@Signal"})
public class CountDownSignalBlock
extends SignalBlock {
    private final int m_initialCount;
    private int m_currentCount;
    private Tag m_prevTag;

    public CountDownSignalBlock(String p_label, int p_priority, GeneList p_geneList, String p_countLabel) throws GeneListException {
        super(p_label, p_priority);
        this.m_initialCount = p_geneList.getGene(p_countLabel).getIntValue();
    }

    @Override
    public JudgmentResult getJudgmentResult() throws IndexStreamException {
        Tag inputTag = this.getInputTag();
        if (inputTag == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        JudgmentResult returnValue = new JudgmentResult(inputTag, NmSignal.NOSIGNAL);
        if (!inputTag.equals(this.m_prevTag)) {
            if (this.m_currentCount > 0) {
                --this.m_currentCount;
                if (this.m_currentCount <= 0) {
                    this.m_currentCount = 0;
                    returnValue = new JudgmentResult(inputTag, this.getDefaultSignal());
                }
            } else {
                JudgmentResult inputSignal = super.getJudgmentResult();
                if (inputSignal.getSignal() == NmSignal.LONG || inputSignal.getSignal() == NmSignal.SHORT) {
                    this.m_currentCount = this.m_initialCount;
                }
            }
        }
        this.m_prevTag = inputTag.clone();
        this.setDetails("[" + this.getLabel() + "]" + returnValue.getSignal().toString() + "(count=" + this.m_currentCount + ")");
        return returnValue;
    }
}

