/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jp.robotbrain.common.UtilFile;

public class TextFile {
    private String m_filePath;
    private String m_charset;
    public static final String LSP = System.getProperty("line.separator");

    public TextFile(String p_filePath, String p_charset) {
        this.m_filePath = p_filePath;
        this.m_charset = p_charset;
    }

    public boolean write(String p_line, boolean p_append) {
        block6: {
            try {
                File dest = new File(this.m_filePath);
                FileOutputStream fos = new FileOutputStream(dest, p_append);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, this.m_charset);
                BufferedWriter bw = new BufferedWriter(osw);
                bw.write(p_line);
                bw.close();
                osw.close();
                fos.close();
                return true;
            }
            catch (FileNotFoundException e) {
                if (UtilFile.getLogger() != null) {
                    UtilFile.getLogger().warning("FileNotFoundException: " + e.getMessage());
                }
            }
            catch (UnsupportedEncodingException e) {
                if (UtilFile.getLogger() != null) {
                    UtilFile.getLogger().warning("UnsupportedEncodingException: " + e.getMessage());
                }
            }
            catch (IOException e) {
                if (UtilFile.getLogger() == null) break block6;
                UtilFile.getLogger().warning("IOException: " + e.getMessage());
            }
        }
        return false;
    }

    public boolean writeln(String p_line, boolean p_append) {
        block6: {
            try {
                File dest = new File(this.m_filePath);
                FileOutputStream fos = new FileOutputStream(dest, p_append);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, this.m_charset);
                BufferedWriter bw = new BufferedWriter(osw);
                bw.write(p_line);
                bw.newLine();
                bw.close();
                osw.close();
                fos.close();
                return true;
            }
            catch (FileNotFoundException e) {
                if (UtilFile.getLogger() != null) {
                    UtilFile.getLogger().warning("FileNotFoundException: " + e.getMessage());
                }
            }
            catch (UnsupportedEncodingException e) {
                if (UtilFile.getLogger() != null) {
                    UtilFile.getLogger().warning("UnsupportedEncodingException: " + e.getMessage());
                }
            }
            catch (IOException e) {
                if (UtilFile.getLogger() == null) break block6;
                UtilFile.getLogger().warning("IOException: " + e.getMessage());
            }
        }
        return false;
    }

    public String read() {
        StringBuilder returnValue = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(this.m_filePath);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, this.m_charset);
            BufferedReader br = new BufferedReader(isr);
            while (br.ready()) {
                String line = String.valueOf(br.readLine()) + LSP;
                returnValue.append(line);
            }
            br.close();
            isr.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            if (UtilFile.getLogger() != null) {
                UtilFile.getLogger().warning("FileNotFoundException: " + e.getMessage());
            }
            return null;
        }
        catch (IOException e) {
            if (UtilFile.getLogger() != null) {
                UtilFile.getLogger().warning("IOException: " + e.getMessage());
            }
            return null;
        }
        return returnValue.toString();
    }
}

