/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.Serializable;
import java.util.ArrayList;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStreamDestination;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TradeComponent;

public abstract class IndexStream
extends TradeComponent
implements Serializable,
IndexStreamDestination {
    private static final long serialVersionUID = 1L;
    private final ArrayList<IndexStreamDestination> m_destinationList = new ArrayList();
    private Tag m_prevTag;
    private int m_destinationMaxCost;

    public IndexStream(String p_label) {
        super(p_label);
    }

    @Override
    public final void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        this.notifyIndexSub(p_indexObjectList);
    }

    protected abstract void notifyIndexSub(IndexObjectList<?> var1) throws IndexStreamException;

    protected boolean isTagChanged(IndexObjectList<?> p_indexObjectList) {
        if (p_indexObjectList.size() <= 0) {
            return false;
        }
        Tag tag = ((IndexObject)p_indexObjectList.getLast()).getTag();
        boolean returnValue = !tag.equals(this.m_prevTag);
        this.m_prevTag = tag;
        return returnValue;
    }

    protected final void notifyIndexNext(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (this.isTagChanged(p_indexObjectList)) {
            for (IndexStreamDestination i : this.m_destinationList) {
                if (i == null) continue;
                i.notifyIndex(p_indexObjectList);
            }
        }
    }

    public abstract IndexObjectList<?> getValues();

    public final void addDestination(IndexStreamDestination p_indexStream) {
        this.m_destinationList.add(p_indexStream);
        if (p_indexStream.getCost() > this.m_destinationMaxCost) {
            this.m_destinationMaxCost = p_indexStream.getCost();
        }
    }

    protected void setDestinationMaxCost(int p_destinationMaxCost) {
        this.m_destinationMaxCost = p_destinationMaxCost;
    }

    public int getDestinationMaxCost() {
        return this.m_destinationMaxCost;
    }

    public abstract void economizeCapacity();

    public final String toXml() {
        if (this.getValues().size() <= 0) {
            return "";
        }
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<component label=\"");
        returnValue.append(this.getLabel());
        returnValue.append("\">");
        returnValue.append(this.getValues().toXml());
        returnValue.append("</component>");
        return returnValue.toString();
    }
}

