<?php

/*
 +-----------------------------------------------------------------------+
 | program/steps/mail/show.inc                                           |
 |                                                                       |
 | This file is part of the RoundCube Webmail client                     |
 | Copyright (C) 2005, RoundCube Dev. - Switzerland                      |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Display a mail message similar as a usual mail application does     |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: show.inc 419 2006-12-20 14:06:33Z thomasb $

*/

require_once('Mail/mimeDecode.php');

$PRINT_MODE = $_action=='print' ? TRUE : FALSE;

// allow this request to be cached
send_future_expire_header();

// similar code as in program/steps/mail/get.inc
if ($_GET['_uid'])
  {
  $MESSAGE = array('UID' => get_input_value('_uid', RCUBE_INPUT_GET));
  $MESSAGE['headers'] = $IMAP->get_headers($MESSAGE['UID']);
  $MESSAGE['structure'] = $IMAP->get_structure($MESSAGE['UID']);
  
  // go back to list if message not found (wrong UID)
  if (!$MESSAGE['headers'] || !$MESSAGE['structure'])
    {
    show_message('messageopenerror', 'error');
    if ($_action=='preview' && template_exists('messagepreview'))
        parse_template('messagepreview');
    else
      {
      $_action = 'list';
      return;
      }
    }

  $MESSAGE['subject'] = $IMAP->decode_header($MESSAGE['headers']->subject);
  
  if ($MESSAGE['structure'])
    list($MESSAGE['parts'], $MESSAGE['attachments']) = rcmail_parse_message(
      $MESSAGE['structure'],
      array('safe' => (bool)$_GET['_safe'],
            'prefer_html' => $CONFIG['prefer_html'],
            'get_url' => $GET_URL.'&_part=%s')
      );
  else
    $MESSAGE['body'] = $IMAP->get_body($MESSAGE['UID']);


  // mark message as read
  if (!$MESSAGE['headers']->seen && $_action != 'preview')
    $IMAP->set_flag($_GET['_uid'], 'SEEN');

  // give message uid to the client
  $javascript = sprintf("%s.set_env('uid', '%s');\n", $JS_OBJECT_NAME, $MESSAGE['UID']);
  $javascript .= sprintf("%s.set_env('safemode', '%b');", $JS_OBJECT_NAME, $_GET['_safe']);

  $next = $prev = -1;
  // get previous, first, next and last message UID
  if (!($_SESSION['sort_col'] == 'date' && $_SESSION['sort_order'] == 'DESC') && 
      $IMAP->get_capability('sort')) 
    {
    // Only if we use custom sorting
    $a_msg_index = $IMAP->message_index(NULL, $_SESSION['sort_col'], $_SESSION['sort_order']);
 
    $MESSAGE['index'] = array_search((string)$MESSAGE['UID'], $a_msg_index, TRUE);
    $prev = isset($a_msg_index[$MESSAGE['index']-1]) ? $a_msg_index[$MESSAGE['index']-1] : -1 ;
    $first = count($a_msg_index)>0 ? $a_msg_index[0] : -1;
    $next = isset($a_msg_index[$MESSAGE['index']+1]) ? $a_msg_index[$MESSAGE['index']+1] : -1 ;
    $last = count($a_msg_index)>0 ? $a_msg_index[count($a_msg_index)-1] : -1;
    }
  else
    {
    // this assumes that we are sorted by date_DESC
    $seq = $IMAP->get_id($MESSAGE['UID']);
    $prev = $IMAP->get_uid($seq + 1);
    $first = $IMAP->get_uid($IMAP->messagecount());
    $next = $IMAP->get_uid($seq - 1);
    $last = $IMAP->get_uid(1);
    $MESSAGE['index'] = $IMAP->messagecount() - $seq;
    }
  
  if ($prev > 0)
    $javascript .= sprintf("\n%s.set_env('prev_uid', '%s');", $JS_OBJECT_NAME, $prev);
  if ($first >0)
    $javascript .= sprintf("\n%s.set_env('first_uid', '%s');", $JS_OBJECT_NAME, $first);
  if ($next > 0)
    $javascript .= sprintf("\n%s.set_env('next_uid', '%s');", $JS_OBJECT_NAME, $next);
  if ($last >0)
    $javascript .= sprintf("\n%s.set_env('last_uid', '%s');", $JS_OBJECT_NAME, $last);

  $OUTPUT->add_script($javascript);
  }



function rcmail_message_attachments($attrib)
  {
  global $CONFIG, $OUTPUT, $PRINT_MODE, $MESSAGE, $GET_URL, $JS_OBJECT_NAME;

  if (sizeof($MESSAGE['attachments']))
    {
    // allow the following attributes to be added to the <ul> tag
    $attrib_str = create_attrib_string($attrib, array('style', 'class', 'id'));
    $out = '<ul' . $attrib_str . ">\n";

    foreach ($MESSAGE['attachments'] as $attach_prop)
      {
      if ($PRINT_MODE)
        $out .= sprintf('<li>%s (%s)</li>'."\n",
                        $attach_prop->filename,
                        show_bytes($attach_prop->size));
      else
        $out .= sprintf('<li><a href="%s&amp;_part=%s" onclick="return %s.command(\'load-attachment\',{part:\'%s\', mimetype:\'%s\'},this)">%s</a></li>'."\n",
                        htmlspecialchars($GET_URL),
                        $attach_prop->mime_id,
                        $JS_OBJECT_NAME,
                        $attach_prop->mime_id,
                        $attach_prop->mimetype,
                        $attach_prop->filename);
      }

    $out .= "</ul>";
    return $out;
    }  
  }



function rcmail_remote_objects_msg($attrib)
  {
  global $CONFIG, $OUTPUT, $JS_OBJECT_NAME;
  
  if (!$attrib['id'])
    $attrib['id'] = 'rcmremoteobjmsg';

  // allow the following attributes to be added to the <div> tag
  $attrib_str = create_attrib_string($attrib, array('style', 'class', 'id'));
  $out = '<div' . $attrib_str . ">";
  
  $out .= sprintf('%s&nbsp;<a href="#loadimages" onclick="%s.command(\'load-images\')">%s</a>',
                  Q(rcube_label('blockedimages')),
                  $JS_OBJECT_NAME,
                  Q(rcube_label('showimages')));
  
  $out .= '</div>';
  
  $OUTPUT->add_script(sprintf("%s.gui_object('remoteobjectsmsg', '%s');", $JS_OBJECT_NAME, $attrib['id']));
  return $out;
  }


if ($_action=='print' && template_exists('printmessage'))
  parse_template('printmessage');
else if ($_action=='preview' && template_exists('messagepreview'))
    parse_template('messagepreview');
else
  parse_template('message');
?>