require 'redmine'


Redmine::Plugin.register :glossary_plugin do
  name 'Redmine Glossary Plugin'
  author 'Mitsuyoshi Yoshida'
  description "This is a Redmine plugin to create a glossary which is is a list of terms in a project"
  version '0.0.1'
  url 'http://sourceforge.jp/projects/rp-glossary'

  project_module :glossary do
    permission(:view_terms, {:glossary => [:index, :show]})
    permission(:manage_terms, {:glossary => [:new, :edit, :destroy, :preview]},
               :require => :member)
    permission(:manage_term_categories,
               {:glossary => [:add_term_category],
                :term_categories => [:index, :change_order, :edit, :destroy]},
               :require => :member)
  end

  menu(:project_menu, :glossary,
       { :controller => 'glossary', :action => 'index' },
       :caption => :glossary_title)

end
