class Term < ActiveRecord::Base
  unloadable

  belongs_to :category, :class_name => 'TermCategory', :foreign_key => 'category_id'
  belongs_to :project
  belongs_to :author, :class_name => 'User', :foreign_key => 'author_id'

  validates_presence_of :name, :project
  validates_length_of :name, :maximum => 255

  acts_as_attachable

  acts_as_searchable :columns => ["#{table_name}.name", "#{table_name}.description"],
                        :include => [:project]

  acts_as_event :title => Proc.new {|o| "#{l(:glossary_title)} ##{o.id}: #{o.name}" },
                  :description => Proc.new {|o| "#{o.description}"},
                  :datetime => :created_on,
                  :type => 'terms',
                  :url => Proc.new {|o| {:controller => 'glossary', :action => 'show', :id => o.project, :term_id => o.id} }

  
  def author
    author_id ? User.find(:first, :conditions => "users.id = #{author_id}") : nil
  end
  
  def updater
    updater_id ? User.find(:first, :conditions => "users.id = #{updater_id}") : nil
  end
  
  def project
    Project.find(:first, :conditions => "projects.id = #{project_id}")
  end
  
  def <=>(term)
    id <=> term.id
  end
  
  def to_s
    "##{id}: #{name}"
  end  

  def self.find_for_macro(tname, proj, all_project = false)
    term = Term.find(:first,
                     :conditions => "project_id = #{proj.id} and name = '#{tname}'")
    return term		if term
    unless all_project
      raise sprintf(I18n.t(:error_term_not_found_name_project), tname, proj)
    end
    term = self.find_by_name(tname)
    return term		if term
    raise sprintf(I18n.t(:error_term_not_found_name), tname)
  end
  
end
