module GlossaryHelper

  def updated_by(updated, author)
    time_tag = content_tag('acronym', distance_of_time_in_words(Time.now, updated), :title => format_time(updated))
    author_tag = (author.is_a?(User) && !author.is_a?(AnonymousUser)) ? link_to(h(author), :controller => 'account', :action => 'show', :id => author) : h(author || 'Anonymous')
    l(:label_updated_time_by, :author => author_tag, :age => time_tag)
  end


  def glossary_to_csv(terms)
    ic = Iconv.new(l(:general_csv_encoding), 'UTF-8')    
    decimal_separator = l(:general_csv_decimal_separator)
    export = FCSV.generate(:col_sep => l(:general_csv_separator)) do |csv|
      # csv header fields
      headers = [ "#",
                 l(:field_project),
                 t('label.name'),
                 t('label.category'),
                 t('label.datatype'),
                 t('label.codename'),
                 t('field_author'),
                 t('label_updater'),
                 t('field_created_on'),
                 t('field_updated_on'),
                 t('label.name_en')
      ]

      # Description in the last column
      headers << l(:field_description)
      csv << headers.collect {|c| begin; ic.iconv(c.to_s); rescue; c.to_s; end }

      # csv lines
      terms.each do |term|
        fields = [term.id,
                  term.project.name,
                  term.category, 
                  term.datatype,
                  term.codename,
                  term.author,
                  term.updater,
                  format_time(term.created_on),
                  format_time(term.updated_on),
                  term.name_en            
        ]
        fields << term.description
        csv << fields.collect {|c| begin; ic.iconv(c.to_s); rescue; c.to_s; end }
      end
    end
    export
  end

end
