/'
   Copyright (c)2022 vasile eodor nastasa
   rqwork7.com, rqwork.de, rqwork.ro
   nastasa.eodor@gmail.com
'/

#include once "win/commctrl.bi"

#define Q_CustomTabControl(ptr) *cast(PCustomTabControl,ptr)
#define W_CustomTabControl(dlg) *cast(QCustomTabControl ptr,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-cboffset))

type PCustomTabControl as QCustomTabControl ptr
type QCustomTabControl extends QFrame
    protected:
    declare virtual sub Dispatch(byref as QMessage)
    declare static function dlgproc(as hwnd,as uint,as wparam,as lparam) as lresult
    public:
    declare static function Register(byref as string="QTabControl") as integer
    declare virtual operator cast as any ptr
    declare constructor
    declare destructor
    #ifdef RTL
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QTabControl as QCustomTabControl

#define Q_CustomToolBar(ptr) *cast(QCustomToolBar ptr,ptr)
#define W_CustomToolBar(dlg) *cast(QCustomToolBar ptr,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-cboffset))

type PCustomToolBar as QCustomToolBar ptr

type QCustomToolBar extends QFrame
    protected:
    declare virtual sub Create
    declare virtual sub Dispatch(byref as QMessage)
    declare static function dlgproc(as hwnd,as uint,as wparam,as lparam) as lresult
    public:
    declare static function Register(byref as string="QToolBar") as integer
    declare virtual operator cast as any ptr
    declare constructor
    declare destructor
    #ifdef RTL
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QToolBar as QCustomToolBar

namespace ComCtrls
    function Register as zstring ptr
        return @"ComCtrls=QToolBar,QTabControl"
    end function
end namespace

'''QCustomTabControl'''
#ifdef RTL
     function QCustomTabControl.GetProperties as zstring ptr
         return Base.GetProperties
     end function

     function QCustomTabControl.GetPropertyInfo(v as string) as PELPropInfo
         return Base.GetPropertyInfo(v)
     end function

     function QCustomTabControl.GetProperty(v as string) as zstring ptr
         return Base.GetProperty(v)
     end function

     function QCustomTabControl.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

function QCustomTabControl.dlgproc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(CreationData,CreationData,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-sizeof(integer))))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->Dispatch(m)
       if m.result=0 then F->Handler(m)
       return m.result
    else
       F=new QCustomTabControl
       F->fhandle=dlg
       F->Dispatch(m)
       if m.result=0 then F->Handler(m)
       return m.result
    end if
    return m.result
end function

sub QCustomTabControl.Dispatch(byref m as QMessage)
    Base.Dispatch(m)
end sub

function QCustomTabControl.Register(byref v as string="QTabControl") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if GetClassInfoEx(0,"SysTabControl32",@wcls) then
       wcls.lpszclassname=strptr(v)
       wcls.lpfnwndproc=@dlgproc
       wcls.hinstance=instance
       wcls.cbwndextra+=sizeof(integer)
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QCustomTabControl.cast as any ptr
    return @this
end operator

constructor QCustomTabControl
    classname="QTabControl"
    classancestor="SysTabControl32"
    fstyle=ws_child
    fwidth=175
    fheight=125
end constructor

destructor QCustomTabControl
end destructor

'''QCustomToolBar'''
#ifdef RTL
     function QCustomToolBar.GetProperties as zstring ptr
         dim as zstring ptr s=Base.GetProperties
         return s
     end function

     function QCustomToolBar.GetPropertyInfo(v as string) as PELPropInfo
         return Base.GetPropertyInfo(v)
     end function

     function QCustomToolBar.GetProperty(v as string) as zstring ptr
         return Base.GetProperty(v)
     end function

     function QCustomToolBar.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

function QCustomToolBar.dlgproc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(CreationData,CreationData,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-sizeof(integer))))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->Dispatch(m)
       if m.result=0 then F->Handler(m)
       return m.result
    else
       F=new QCustomToolBar
       F->fhandle=dlg
       F->Dispatch(m)
       if m.result=0 then F->Handler(m)
       return m.result
    end if
    return m.result
end function

sub QCustomToolBar.Dispatch(byref m as QMessage)
    Base.Dispatch(m)
end sub

function QCustomToolBar.Register(byref v as string="QToolBar") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if GetClassInfoEx(0,"ToolBarWindow32",@wcls) then
       wcls.lpszclassname=strptr(v)
       wcls.lpfnwndproc=@dlgproc
       wcls.hinstance=instance
       wcls.cbwndextra+=sizeof(integer)
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QCustomToolBar.cast as any ptr
    return @this
end operator

sub QCustomToolBar.Create
end sub

constructor QCustomToolBar
    classname="QCustomToolBar"
    classancestor="ToolBarWindow32"
    fstyle=ws_child or ccs_nomovex or ccs_nomovey or ccs_noresize or not ccs_nodivider
    fwidth=121
    fheight=21
    Create
end constructor

destructor QCustomToolBar
end destructor

sub ComCtrls_initialization constructor
    InitCommonControls
    QCustomTabControl.Register
    QCustomToolBar.Register
end sub
