/'
   This is GUI standards unit in FreeBasic
   is suitable for windows operating system,
   but can be easely translated for Linux systems
   copyright (c)2021 vasile eodor nastasa
   http://www.rqwork.ro
   http://www.rqwork.de
   nastasa.eodor@gmail.com
   this version is number 11, is a stable release(GUI_V11)
'/

#include once "sysutils.bas"

type QForm extends QCustomForm
    public:
    declare operator cast as any ptr
    declare constructor
end type

type QStatic extends QFrame
     protected:
     as QAlignment falignment
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare property Alignment as integer
     declare property Alignment (as integer)
     declare virtual sub Update
     declare static function Register(v as string="QStatic") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QLabel as QStatic

/'QImage'/
type QImage extends QStatic
    protected:
    as ppicture fpicture
    as boolean fcenter
    declare virtual sub Dispatch(byref as QMessage)
    declare static sub PictureChange(as QObject)
    declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
    public:
    declare static function Register(v as string="QImage") as integer
    declare property Center as integer
    declare property Center (as integer)
    declare property Picture as  QPicture
    declare property Picture (as  QPicture)
    declare virtual operator cast as any ptr
    declare constructor
    declare destructor
    #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QButton extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QButton") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QEdit extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QEdit") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QComboBox extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QComboBox") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QListBox extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QListBox") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

type QScrollBar extends QFrame
     protected:
     declare virtual sub Dispatch(byref as QMessage)
     declare virtual sub Handler(byref as QMessage)
     declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
     public:
     declare static function Register(v as string="QScrollBar") as integer
     declare operator cast as any ptr
     declare operator cast as string
     declare constructor
     declare destructor
     #ifdef rtl
     declare virtual function GetProperties as zstring ptr
     declare virtual function GetPropertyInfo(as string) as PELPropInfo
     declare virtual function GetProperty(as string) as zstring ptr
     declare virtual function SetProperty(as string,as zstring ptr) as boolean
    #endif
end type

/'Register to ide'/
namespace Standards
    function RegisterComponents as zstring ptr export
        dim as string s="Standards=QStatic,QImage,QButton,QEdit,QComboBox,QListBox,QScrollBar"+chr(0)
        dim as zstring ptr result=callocate(len(s))
        *result=s
        return result
    end function
end namespace

/'QForm'/
operator QForm.cast as any ptr
    return @this
end operator

constructor QForm
end constructor

/'QStatic'/
#ifdef rtl
     function QStatic.GetProperties as zstring ptr
         return Base.GetProperties
     end function

     function QStatic.GetPropertyInfo(n as string) as PELPropInfo
         if n="" then return 0
         return Base.GetPropertyInfo(n)
     end function

     function QStatic.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QStatic.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

property QStatic.Alignment as integer
    if style and ss_left=ss_left then
       falignment=taLeft
    elseif style and ss_center=ss_center then
       falignment=taCenter
    elseif style and (ss_center or ss_left)=(ss_center or ss_left)then
       falignment=taRight
    end if
    return falignment
end property

property QStatic.Alignment (v as integer)
    falignment=v
    select case v
    case 0:fstyle or=ss_left
           fstyle and=not (ss_center or ss_right)
    case 1:fstyle or=ss_center
           fstyle and=not (ss_left or ss_right)
    case 2:fstyle or=ss_right
           fstyle and=not (ss_center or ss_left)
    end select
    style=fstyle
    Update
end property

sub QStatic.Update
    Base.UpdateControl
end sub

sub QStatic.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QStatic.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QStatic.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
     dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
     dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
     if F then
        F->fhandle=dlg
        F->dispatch(m)
        if m.result=0 then F->handler(m)
        return m.result
     else
        F=new QStatic
        F->fhandle=dlg
        F->dispatch(m)
        if m.result=0 then F->handler(m)
        return m.result
     end if
     return m.result
end function

function QStatic.Register(v as string="QStatic") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"static",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@qstatic.dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QStatic.cast as any ptr
    return @this
end operator

operator QStatic.cast as string
    return iif(classname<>"",classname,"QStatic")
end operator

constructor QStatic
    classname="QStatic"
    classAncestor="static"
    fstyle=ws_child or ss_notify or ss_simple
    fwidth=97
    fheight=17
end constructor

destructor QStatic
end destructor

/'QImage'/
#ifdef rtl
     function QImage.GetProperties as zstring ptr
         dim as string s="Center"+lf+"Picture"+lf+*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s)+1)
         *zs=s+chr(0)
         return zs
     end function

     function QImage.GetPropertyInfo(n as string) as PELPropInfo
         if n="" then return 0
         dim as PELPropInfo pif=new QELPropInfo
         select case lcase(n)
         case "picture"
               pif->value=callocate(len(n)+1)
               *pif->value=n
               pif->typename=callocate(len("QPicture"))
               *pif->typename="QPicture"
               pif->editor=callocate(len("ImageEditor")+1)
               *pif->editor="TELImageEditor"+chr(0)
               pif->typekind=tkType
               return pif
         case "center"
               if pif=0 then pif=new QELPropInfo
               pif->value=callocate(len(n)+1)
               *pif->value=n
               pif->typename=callocate(len("Boolean"))
               *pif->typename="Boolean"+chr(0)
               pif->name=callocate(len("false,true")+1)
               *pif->name="false,true"+chr(0)
               pif->typekind=tkBool
               return pif
         case else
              return Base.GetPropertyInfo(n)
         end select
         return 0
     end function

     function QImage.GetProperty(n as string) as zstring ptr
         select case lcase(n)
         case "picture"
              dim as integer i=cint(fpicture)
              dim as string s=str(i)+chr(0)
              dim as zstring ptr zs=callocate(len(s))
              *zs=s
              return zs
         case "center"
              dim as integer i=cint(fcenter)
              dim as string s=str(i)+chr(0)
              dim as zstring ptr zs=callocate(len(s))
              *zs=s
              return zs
         case else
              return Base.GetProperty(n)
         end select
     end function

     function QImage.SetProperty(n as string,v as zstring ptr) as boolean
          select case lcase(n)
         case "picture"
              dim as integer i=val(*v)
              picture=*cast(ppicture,i)
              return fpicture>0
         case "center"
              dim as integer i=val(*v)
              center=i
              return fcenter=0
         case else
              return Base.SetProperty(n,v)
         end select
     end function
#endif

function QImage.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
     dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
     dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
     if F then
        F->fhandle=dlg
        F->dispatch(m)
        if m.result=0 then F->handler(m)
        return m.result
     else
        F=new QImage
        F->fhandle=dlg
        F->dispatch(m)
        if m.result=0 then F->handler(m)
        return m.result
     end if
     return m.result
end function

function QImage.Register(v as string="QImage") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"static",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@qimage.dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

sub QImage.Dispatch(byref m as QMessage)
    base.Dispatch(m)
    select case m.msg
    case stm_setimage
         fpicture->handle=cast(any ptr,m.lparam)
         select case m.wparam
         case image_bitmap
         case image_cursor
         case image_icon
         case image_enhmetafile
         end select
         m.result=0
    end select
end sub

property QImage.Picture as QPicture
    if fpicture then
       return *fpicture
    else
       return *cast(ppicture,0)
    end if
end property

property QImage.Picture (v as QPicture)
    fpicture=v
end property

property QImage.Center as integer
    fcenter=style and ss_centerimage
    return fcenter
end property

property QImage.Center (v as integer)
    fcenter=v
    if v then
       fstyle or=ss_centerimage
    else
       fstyle and=not ss_centerimage
    end if
    style=fstyle
end property

sub QImage.PictureChange(sender as QObject)
    dim as integer it=image_bitmap
    with *cast(PPicture,@sender)
         dim as string ext=extractfileext(.filename)
         select case lcase(ext)
         case ".bmp": it=image_bitmap
                     cast(PFrame,.interface)->style=cast(PFrame,.interface)->style or ss_bitmap and not (ss_icon  or ss_enhmetafile)
         case ".cur",".ico":it=image_icon
                     cast(PFrame,.interface)->style=cast(PFrame,.interface)->style or ss_icon and not (ss_bitmap or ss_enhmetafile)
         end select
         SendMessage(cast(PFrame,.interface)->Handle,stm_setimage,it,cint(.handle))
    end with
end sub

operator QImage.cast as any ptr
    return @this
end operator

constructor QImage
    classname="QImage"
    classancestor="static"
    style=ss_bitmap or ws_child or ss_notify
    this.width=105
    this.Height=105
    fpicture=new QPicture
    if fpicture then
       fpicture->interface=this
       fpicture->onchange=@picturechange
    end if
end constructor

destructor QImage
    if fpicture then delete fpicture
end destructor

/'QButton'/
#ifdef rtl
     function QButton.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QButton.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QButton.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QButton.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QButton.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QButton.Dispatch(byref m as QMessage)
    base.Dispatch(m)
    select case m.msg
    case cm_command
         if m.wparam=bn_clicked then click
    end select
end sub

function QButton.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QButton
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QButton.Register(v as string="QButton") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"button",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QButton.cast as any ptr
    return @this
end operator

operator QButton.cast as string
    return iif(classname<>"",classname,"QButton")
end operator

constructor QButton
    classname="QButton"
    classAncestor="Button"
    fstyle=ws_child
    fwidth=75
    fheight=35
end constructor

destructor QButton
end destructor

/'QEdit'/
#ifdef rtl
     function QEdit.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QEdit.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QEdit.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QEdit.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QEdit.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QEdit.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QEdit.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QEdit
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QEdit.Register(v as string="QEdit") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"edit",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QEdit.cast as any ptr
    return @this
end operator

operator QEdit.cast as string
    return iif(classname<>"",classname,"QEdit")
end operator

constructor QEdit
    classname="QEdit"
    classAncestor="edit"
    fstyle=ws_child
    fwidth=97
    fheight=17
end constructor

destructor QEdit
end destructor

/'QComboBox'/
#ifdef rtl
     function QComboBox.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QComboBox.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QComboBox.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QComboBox.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QComboBox.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QComboBox.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QComboBox.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QComboBox
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QComboBox.Register(v as string="QComboBox") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"combobox",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QComboBox.cast as any ptr
    return @this
end operator

operator QComboBox.cast as string
    return iif(classname<>"",classname,"QComboBox")
end operator

constructor QComboBox
    classname="QComboBox"
    classAncestor="combobox"
    fstyle=ws_child
    fwidth=121
    fheight=21
end constructor

destructor QComboBox
end destructor

/'QListBox'/
#ifdef rtl
     function QListBox.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QListBox.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QListBox.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QListBox.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QListBox.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QListBox.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QListBox.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QListBox
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QListBox.Register(v as string="QListBox") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"listbox",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QListBox.cast as any ptr
    return @this
end operator

operator QListBox.cast as string
    return iif(classname<>"",classname,"QListBox")
end operator

constructor QListBox
    classname="QListBox"
    classAncestor="listbox"
    fstyle=ws_child
    fwidth=121
    fheight=121
end constructor

destructor QListBox
end destructor

/'QScrollBar'/
#ifdef rtl
     function QScrollBar.GetProperties as zstring ptr
         dim as string s=*Base.GetProperties
         dim as zstring ptr zs=callocate(len(s))
         *zs=s
         return zs
     end function

     function QScrollBar.GetPropertyInfo(n as string) as PELPropInfo
         return Base.GetPropertyInfo(n)
     end function

     function QScrollBar.GetProperty(n as string) as zstring ptr
         return Base.GetProperty(n)
     end function

     function QScrollBar.SetProperty(n as string,v as zstring ptr) as boolean
         return Base.SetProperty(n,v)
     end function
#endif

sub QScrollBar.Handler(byref m as QMessage)
    Base.Handler(m)
end sub

sub QScrollBar.Dispatch(byref m as QMessage)
    base.Dispatch(m)
end sub

function QScrollBar.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    dim as PFrame F=iif(creationdata,creationdata,cast(PFrame,GetWindowLongPtr(dlg,GetClassLongPtr(dlg,gcl_cbwndextra)-4)))
    dim as QMessage m=type(dlg,msg,wparam,lparam,0,F)
    if F then
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    else
       F=new QScrollBar
       F->fhandle=dlg
       F->dispatch(m)
       if m.result=0 then F->handler(m)
       return m.result
    end if
    return m.result
end function

function QScrollBar.Register(v as string="QScrollBar") as integer
    dim as wndclassex wcls
    wcls.cbsize=sizeof(wcls)
    if getclassinfoex(0,"scrollbar",@wcls) then
       wcls.cbwndextra+=sizeof(integer)
       wcls.lpfnwndproc=@dlgproc
       wcls.lpszclassname=strptr(v)
       wcls.hinstance=instance
       return RegisterClassEx(@wcls)
    end if
    return 0
end function

operator QScrollBar.cast as any ptr
    return @this
end operator

operator QScrollBar.cast as string
    return iif(classname<>"",classname,"QScrollBar")
end operator

constructor QScrollBar
    classname="QScrollBar"
    classAncestor="scrollbar"
    fstyle=ws_child
    fwidth=221
    fheight=17
end constructor

destructor QScrollBar
end destructor

sub standards_initialization constructor
     QForm.register
     QStatic.register
     QImage.register
     QButton.register
     QEdit.register
     QComboBox.register
     QListBox.register
     QScrollBar.register
end sub

sub standard_finalization destructor
    unregisterclass("QForm",instance)
    unregisterclass("QStatic",instance)
    unregisterclass("QImage",instance)
    unregisterclass("QButton",instance)
    unregisterclass("QEdit",instance)
    unregisterclass("QComboBox",instance)
    unregisterclass("QListBox",instance)
    unregisterclass("QScrollBar",instance)
end sub