#!/bin/sh
##########################################################################################
##########################################################################################
##LinuxでのRTCの自動起動・自動接続・自動アクティブ化を行うサンプルシェルスクリプト
##ConsoleIn・ConsoleOutを10個に起動し、瞬時に接続を行う。
##
##########################################################################################
##########################################################################################

#############################################
############Start Naming Server
############NamingServierを起動する.
rtm-naming 9876 &

#############################################
############Run RTComponents(RTCD Commend)
############rtcdコマンドにて複数コンポーネントを一括起動
cd rtc_run_linux/
############.soのサンプルをCurrentにコピー
cp /usr/share/OpenRTM-aist/examples/src/SimpleIO/ConsoleOut.so ./
cp /usr/share/OpenRTM-aist/examples/src/SimpleIO/ConsoleIn.so ./
xterm -e rtcd &
cd ..

###########タイミングはsleepで調整可能.
sleep 1

#############################################
############Connection
rtc-controller 127.0.0.1:9876 --connect ConsoleOut0 in ConsoleIn0 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut1 in ConsoleIn1 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut2 in ConsoleIn2 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut3 in ConsoleIn3 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut4 in ConsoleIn4 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut5 in ConsoleIn5 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut6 in ConsoleIn6 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut7 in ConsoleIn7 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut8 in ConsoleIn8 out
rtc-controller 127.0.0.1:9876 --connect ConsoleOut9 in ConsoleIn9 out

#############################################
###########DisConnection
###########切断は以下のように行う
#rtc-controller 127.0.0.1:9876--disconnect ConsoleOut0 in
#rtc-controller 127.0.0.1:9876--disconnect ConsoleOut1 in
###########全切断も可能
#rtc-controller 127.0.0.1:9876--alldisconnect


#############################################
###########ConfigSet
###########
#rtc-controller 127.0.0.1:9876--confset Config conf1 0



#############################################
###########Active
###########タイミングはsleepで調整可能.
#rtc-controller 127.0.0.1:9876 --active ConsoleOut0
#sleep 1
#rtc-controller 127.0.0.1:9876 --active ConsoleOut1
#sleep 1
#rtc-controller 127.0.0.1:9876 --active ConsoleIn0
#sleep 1
#rtc-controller 127.0.0.1:9876 --active ConsoleIn1
#sleep 1

#############################################
###########ALLActive
###########タイミング調整が不要であれば，
###########以下のコマンドにて全てのコンポーネントをアクティブ化
rtc-controller 127.0.0.1:9876 --allactive


#############################################
###########ALLdeactive
###########全てのコンポーネントを非アクティブ化
#rtc-controller 127.0.0.1:9876 --alldeactive

#############################################
###########Destory
###########ネームサーバをクリアする
#rtc-controller 127.0.0.1:9876 --destory




