///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//@file  rtc-controller.cpp
//brief: OpenRTM-aist開発支援ツール．RTコンポーネントの制御を行う
//$Date$ 2009/12/12
//@author eno 
//@mail:enoreplies@gmail.com
//@WebPage:http://www15.atpages.jp/~technotes/wiki/
//$Id$ 
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
/*
rtc-controller

The MIT License

Copyright (c) 2009 eno <enoreplies@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

#include <iostream>
#include <cctype>
#include <string>
#include <fstream>
#include <vector>
using namespace std;
#include "rtc_control.h"

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
#define USE_READLINE 0
#else
#define USE_READLINE 1		
#endif

#if USE_READLINE==1

/////////////////////////////////////////////////////////////////
//LIBREADLINEを使用する．
#include <readline/readline.h>
#include <readline/history.h>


const char* CommandList[]= {
	"quit",
	"connect",
	"list",
	"state",
	"save",
	"load",
	"portlist",
	"portshow",
	"portinfo",
	"connectinfo",
	"rtcinfo",
	"disconnect",
	"disconnectall",
	"active",
	"reset",
	"deactive",
	"allgetrate",
	"allactive",
	"alldeactive",
	"allshow",
	"alldisconnect",
	"confget",
	"confgetdefault",
	"confsetdefault",
	"confset",
	"confsetnew",
	"destory",
	"getrate",
	"setrate",
	NULL
};

char* WordFind(const char* text, int state_word){
	static int index, wordlen;
	const char*  name;

	if (state_word == 0) {  
		wordlen = strlen(text);
		index = 0;
	}
	while ((name = CommandList[index])) {
		index++;   
		if (!strncmp(text, name, wordlen)) {
			return strdup(name);  
		}
	}
	return NULL;
}


char** TabComplete(const char* text, int start, int end){
	if (start==0) { 
		return rl_completion_matches(text, WordFind);
	}
	return NULL;
}

void GetConsoleLine(char **line_read){
	if(line_read){
		free(*line_read);
		*line_read = (char *)NULL;
	}
	*line_read = readline("input >>> ");
	if(*line_read && **line_read)
		add_history (*line_read);
}


char *TrimSpace(char *str){
	char *p = str;
	char *last = NULL;
	while (*p != '\0') {
		if (isspace(*p)) {
			if (last == NULL) {
				last = p;
			}
		} else {
			last = NULL;
		}
		++p;
	}
	if (last != NULL) {
		*last = '\0';
	}

	return str;
}

string conv(string buff){
	char chr[256];
	sprintf(chr,"%s", buff.c_str());
	TrimSpace(chr);
	string st=chr;
	return st;
}

int  input_cui(string &cmd){	
	static char *line = (char *)NULL;
	GetConsoleLine(&line);
	cmd=line;
	cmd=conv(cmd);
	return 0;
}

#else
int  input_cui(string &cmd){
	cout<<"input >>>";
	getline(cin,cmd);
	return 0;
}
#endif

int ConsoleMode(string IP_adress){					//コンソールからコマンドを入力する．
#if USE_READLINE==1
	/// readlineのhistory初期化
	using_history();
	read_history("/var/rtc-control_history");
	rl_attempted_completion_function = TabComplete; 
#endif

	//適当な代入し，CORBA初期化．
	int _argc(1);
	char* _argv[]={"initialize"};
	CORBA::ORB_var orb = CORBA::ORB_init(_argc,_argv);
	RTC::CorbaNaming namingserver(orb, IP_adress.c_str());	

	//RTコンポーネントリスト格納
	vector<string> rtclist;
	rtc_get_rtclist(namingserver,rtclist);

	while(1){
		string cmd;
		cout<<endl;
		cout<<"Input Commond"<<endl;
		cout<<"quit(q),connect(c),list(l),state(s),portlist(pl),"<<endl;
		cout<<"portshow(ps),portinfo(pi),connectinfo(ci),rtcinfo(ri),disconnect(dc),"<<endl;
		cout<<"disconnectall(dca),active(a),deactive(d),allgetrate(agr),allactive(aa),"<<endl;
		cout<<"alldeactive(ad),allshow(as),alldisconnect(adc),confget(cg),confgetdefault(cgd),"<<endl;
		cout<<"confsetdefault(csd),confset(cs),confsetnew(csn),destory(des),getrate(gr)"<<endl;
		cout<<"setrate(sr),reset(r),save,load"<<endl;
		input_cui(cmd);

		cout<<"---------------------------"<<endl;
		vector<string> rtclist;
		rtc_get_rtclist(namingserver,rtclist);

		if((cmd=="quit")||(cmd=="q")){
			break;
		}
		if((signed int)rtclist.size()>0){
			if((cmd=="connect")||(cmd=="c")){				
				string rtc_name1;
				string rtc_name2;
				string port_name1;
				string port_name2;
				int rtc_num1;
				int rtc_num2;
				int port_num1;
				int port_num2;

				vector<string> rtclist;
				rtc_get_rtclist(namingserver,rtclist);
				name_show(&rtclist[0],rtclist.size());
				cout<<"Input Comp1-Name or Number"<<endl;
				input_cui(rtc_name1);
				rtc_num1=str_conv_int(rtc_name1);
				if((rtc_num1>=0)&&(rtc_num1<(signed int)rtclist.size())){						//コンポーネント名に数字が入力
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num1,rtc_name1);							
				}
				cout<<"Input Port Name or Number"<<endl;
				if(!rtc_namecheck(rtc_name1,&rtclist[0],rtclist.size())){
					vector<string> portlist1;
					rtc_get_portlist(namingserver,rtc_name1,portlist1);
					name_show(&portlist1[0],portlist1.size());
				}

				input_cui(port_name1);
				port_num1=str_conv_int(port_name1);

				name_show(&rtclist[0],rtclist.size());
				cout<<"Input Comp2-Name or Number"<<endl;
				input_cui(rtc_name2);
				rtc_num2=str_conv_int(rtc_name2);
				if((rtc_num2>=0)&&(rtc_num2<(signed int)rtclist.size())){						//コンポーネント名に数字が入力
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num2,rtc_name2);						
				}

				cout<<"Input Port Name or Number"<<endl;
				if(!rtc_namecheck(rtc_name2,&rtclist[0],rtclist.size())){
					vector<string> portlist2;
					rtc_get_portlist(namingserver,rtc_name2,portlist2);
					name_show(&portlist2[0],portlist2.size());
				}
				input_cui(port_name2);
				port_num2=str_conv_int(port_name2);

				if(!rtc_namecheck(rtc_name1,&rtclist[0],rtclist.size())
					&&(!rtc_namecheck(rtc_name2,&rtclist[0],rtclist.size())))	{

						//				if(!name_check(rtclist,rtc_name1)&&(!name_check(rtclist,rtc_name2))){

						vector<string> portlist1;
						rtc_get_portlist(namingserver,rtc_name1,portlist1);
						vector<string> portlist2;
						rtc_get_portlist(namingserver,rtc_name2,portlist2);

						if((port_num1>=0)&&(port_num2>=0)){										//portに数字を入力
							if((port_num1<(signed int)portlist1.size())&&(port_num2<(signed int)portlist2.size())){
								rtc_connect(namingserver,rtc_name1,port_num1,rtc_name2,port_num2);
							}
							else{
								if(!(port_num1<(signed int)portlist1.size()))				cout<<"Comp1 PortNumError"<<endl;
								if(!(port_num2<(signed int)portlist2.size()))				cout<<"Comp2 PortNumError"<<endl;
							}
						}

						else{	
							if((!name_to_number(&portlist1[0],portlist1.size(),port_name1,port_num1))&&(!name_to_number(&portlist2[0],portlist2.size(),port_name2,port_num2)))
								rtc_connect(namingserver,rtc_name1,port_num1,rtc_name2,port_num2);
						}
				}


			}
			else if((cmd=="list")||(cmd=="l")){					//RTコンポーネントの状態確認
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
			}
			else if((cmd=="save")){								//RTコンポーネントの状態保存
				cout<<"Input File Name"<<endl;
				string fname;
				getline(cin,fname);
				if(fname=="") fname="connect";
				rtc_connect_save(namingserver,IP_adress,fname);	
			}
			else if((cmd=="load")){								//RTコンポーネントの状態復元
				cout<<"Input File Name"<<endl;
				string fname;
				getline(cin,fname);
				if(fname=="") fname="connect";
				rtc_connect_load(namingserver,fname);	
			}

			else if((cmd=="state")||(cmd=="s")){				//RTコンポーネントの状態確認
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())&&((signed int)rtclist.size()>0)){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}


				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
					rtc_state(namingserver,rtc_name);
			}

			else if((cmd=="portlist")||(cmd=="pl")){			//ポート一覧を出力

				string rtc_name;
				if(!rtclist.empty()) 

					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_port_namelist(namingserver,rtc_name);
			}


			else if((cmd=="portshow")||(cmd=="ps")){			//RTコンポーネントのポート接続状態一覧を出力
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_portshow(namingserver,rtc_name);
			}

			else if((cmd=="portinfo")||(cmd=="pi")){			//RTコンポーネントのポート情報の出力

				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}


				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_port_info(namingserver,rtc_name);
			}
			else if((cmd=="connectinfo")||(cmd=="ci")){	
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_connect_info(namingserver,rtc_name);
			}


			else if((cmd=="rtcinfo")||(cmd=="ri")){	

				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_comp_info(namingserver,rtc_name);
			}

			else if((cmd=="disconnectall")||(cmd=="dca")){			//RTコンポーネントの全てのポート接続解除
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))		{
					rtc_disconnect(namingserver,rtc_name);
					cout<<rtc_name<<" disconnect"<<endl;
				}

			}
			else if((cmd=="disconnect")||(cmd=="dc")){				//RTコンポーネントの特定のポート接続解除
				//Input RTComponent
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				//Input Port
				cout<<"Input Port Name or Number"<<endl;
				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size())){
					vector<string> portlist;
					rtc_get_portlist(namingserver,rtc_name,portlist);
					name_show(&portlist[0],portlist.size());
				}
				int port_num;
				string port_name;
				input_cui(port_name);
				port_num=str_conv_int(port_name);

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size())){
					vector<string> portlist;
					rtc_get_portlist(namingserver,rtc_name,portlist);					
					if(port_num>=0){										//Input port_name=number
						if(port_num<(signed int)portlist.size()){
							rtc_disconnect(namingserver,rtc_name,port_num);
							cout<<rtc_name<<" "<<port_name<<" disconnect"<<endl;
						}
						else{
							if(!(port_num<(signed int)portlist.size()))				cout<<"RTC PortNumError"<<endl;
						}
					}

					else{	
						if(!name_to_number(&portlist[0],portlist.size(),port_name,port_num)){
							rtc_disconnect(namingserver,rtc_name,port_num);
							cout<<rtc_name<<" "<<port_name<<" disconnect"<<endl;
						}
					}
				}

			}
			else if((cmd=="active")||(cmd=="a")){					//RTコンポーネントのをアクティブ化
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
					rtc_active(namingserver,rtc_name);
			}
			else if((cmd=="reset")||(cmd=="r")){					//RTコンポーネントのをアクティブ化
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
					rtc_reset(namingserver,rtc_name);
			}

			else if((cmd=="deactive")||(cmd=="da")){				//RTコンポーネントのを非アクティブ化
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_deactive(namingserver,rtc_name);
			}
			else if((cmd=="allgetrate")||(cmd=="agr")){				
				rtc_all_get_rate(namingserver);
			}
			else if((cmd=="allactive")||(cmd=="aa")){						//全てのRTコンポーネントのをアクティブ化
				rtc_all_active(namingserver);
			}
			else if((cmd=="alldeactive")||(cmd=="ada")){					//全てのRTコンポーネントのを非アクティブ化
				rtc_all_deactive(namingserver);
			}
			else if((cmd=="allshow")||(cmd=="as")){							//全てのRTコンポーネントのを接続状態一覧
				rtc_all_show(namingserver);
			}
			else if((cmd=="alldisconnect")||(cmd=="adc")){					//全てのRTコンポーネントのを接続解除
				rtc_all_disconnect(namingserver);
			}
			else if((cmd=="confget")||(cmd=="cg")){							//コンフィグレーション取得
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				string confset;
				cout<<"configset"<<endl;
				cin>>confset;

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_config_get(namingserver,rtc_name,confset);
			}

			else if((cmd=="confgetdefault")||(cmd=="cgd")){							//コンフィグレーション取得
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				string confset="default";
				cout<<"configset"<<endl;

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_config_get(namingserver,rtc_name,confset);
			}

			else if((cmd=="confsetdefault")||(cmd=="csd")){							//コンフィグレーションセット
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				string value;
				string key;
				cout<<"config"<<endl;
				cin>>key;		
				cout<<"value"<<endl;
				cin>>value;	

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_config_set(namingserver,rtc_name,key,value);
			}

			else if((cmd=="confset")||(cmd=="cs")){							//コンフィグレーションセット
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				//string rtc_name;
				string value;
				string key;
				string confset;
				cout<<"configset [default:default]"<<endl;
				getline(cin,confset);
				if(confset=="") confset="default";
				cout<<"config"<<endl;
				getline(cin,key);
				cout<<"value"<<endl;
				getline(cin,value);

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_config_set(namingserver,rtc_name,key,value,confset);
			}

			else if((cmd=="confsetnew")||(cmd=="csn")){							//新規コンフィグレーションセット
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				string value;
				string key;
				string config_set;
				cout<<"configset [default:default]"<<endl;
				getline(cin,config_set);	
				if(config_set=="") config_set="default";
				cout<<"config"<<endl;
				getline(cin,key);
				cout<<"value"<<endl;
				getline(cin,value);

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
					rtc_new_config_set(namingserver,rtc_name,key,value,config_set);
			}
			else if((cmd=="destory")||(cmd=="des")){							//ネームサーバをクリアする
				rtc_destoryall(namingserver);
			}
			else if((cmd=="getrate")||(cmd=="gr")){							//実行周期を取得
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
					rtc_get_rate(namingserver,rtc_name);
			}
			else if((cmd=="setrate")||(cmd=="sr")){							//実行周期を取得
				string rtc_name;
				if(!rtclist.empty()) 
					name_show(&rtclist[0],rtclist.size());
				cout<<"Input RTC-Name or Number "<<endl;
				input_cui(rtc_name);
				int rtc_num=str_conv_int(rtc_name);
				if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){		
					rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);						
				}

				int rate;
				cout<<"rate"<<endl;
				cin>>rate;	
				if( std::cin.fail() ) {//another number
					cout<<"error"<<endl;
					std::cin.clear(); 
				}

				if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
					rtc_set_rate(namingserver,rtc_name,rate);
			}
			else{															//タイピングミス
				cout<<"Type Miss"<<endl;
			}
		}
		else{
			cout<<"NemeServer:"<<IP_adress<<" No RTComponents"<<endl;
		}
	}
	orb->destroy();

#if USE_READLINE==1
	write_history("/var/rtc-control_history");
	cout<<"history wrote -> /var/rtc-control_history"<<endl;
#endif

	return 0;
}

int ArgumentMode(string IP_adress,string arg[],int argc){
	//適当な代入し，CORBA初期化．
	int _argc(1);
	char* _argv[]={"initialize"};
	CORBA::ORB_var orb = CORBA::ORB_init(_argc,_argv);
	RTC::CorbaNaming namingserver(orb, IP_adress.c_str());	

	//RTコンポーネントリスト格納
	vector<string> rtclist;
	rtc_get_rtclist(namingserver,rtclist);

	if((arg[2]=="--connect")&&(argc==7)) {
		string port_name1=arg[4];
		string port_name2=arg[6];

		string rtc_name1=arg[3];
		string rtc_name2=arg[5];
		int rtc_num1=-1;
		int rtc_num2=-1;
		int port_num1=-1;
		int port_num2=-1;

		vector<string> rtclist;
		rtc_get_rtclist(namingserver,rtclist);
		rtc_num1=str_conv_int(rtc_name1);
		if((rtc_num1>=0)&&(rtc_num1<(signed int)rtclist.size())){						//When Input rtc_name is Number,
			rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num1,rtc_name1);							
		}

		rtc_num2=str_conv_int(rtc_name2);
		if((rtc_num2>=0)&&(rtc_num2<(signed int)rtclist.size())){						//When Input rtc_name is Number,
			rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num2,rtc_name2);						
		}

		port_num1=str_conv_int(port_name1);
		port_num2=str_conv_int(port_name2);

		if(!rtc_namecheck(rtc_name1,&rtclist[0],rtclist.size())
			&&(!rtc_namecheck(rtc_name2,&rtclist[0],rtclist.size())))	{

				vector<string> portlist1;
				rtc_get_portlist(namingserver,rtc_name1,portlist1);
				vector<string> portlist2;
				rtc_get_portlist(namingserver,rtc_name2,portlist2);

				if((port_num1>=0)&&(port_num2>=0)){//portに数字を入力
					if((port_num1<(signed int)portlist1.size())&&(port_num2<(signed int)portlist2.size())){
						rtc_connect(namingserver,rtc_name1,port_num1,rtc_name2,port_num2);
					}
					else{
						if(!(port_num1<(signed int)portlist1.size()))				cout<<"Comp1 PortNumError"<<endl;
						if(!(port_num2<(signed int)portlist2.size()))				cout<<"Comp2 PortNumError"<<endl;
					}
				}

				else{	
					if((!name_to_number(&portlist1[0],portlist1.size(),port_name1,port_num1))&&(!name_to_number(&portlist2[0],portlist2.size(),port_name2,port_num2)))
						rtc_connect(namingserver,rtc_name1,port_num1,rtc_name2,port_num2);
				}
		}


	}

	if((arg[2]=="--disconnectall")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
			rtc_disconnect(namingserver,rtc_name);
	}

	if((arg[2]=="--disconnect")&&(argc==5)) {
		string rtc_name=arg[3];
		string port_name=arg[4];

		int rtc_num=str_conv_int(rtc_name);
		if((rtc_num>=0)&&(rtc_num<(signed int)rtclist.size())){						//When Input rtc_name is Number,
			rtc_number_to_name(&rtclist[0],rtclist.size(),rtc_num,rtc_name);							
		}

		int port_num=str_conv_int(port_name);

		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size())){
			vector<string> portlist;
			rtc_get_portlist(namingserver,rtc_name,portlist);

			if(port_num>=0){															//When Input port_name is Number
				if(port_num<(signed int)portlist.size()){
					rtc_disconnect(namingserver,rtc_name,port_num);
					cout<<rtc_name<<" "<<port_name<<" disconnect"<<endl;
				}
				else{
					if(!(port_num<(signed int)portlist.size()))				cout<<"RTC PortNumError"<<endl;
				}
			}

			else{	
				if(!name_to_number(&portlist[0],portlist.size(),port_name,port_num)){
					rtc_disconnect(namingserver,rtc_name,port_num);
					cout<<rtc_name<<" "<<port_name<<" disconnect"<<endl;
				}
			}
		}
	}



	if((arg[2]=="--destory")&&(argc==3)) {
		rtc_destoryall(namingserver);
	}


	if((arg[2]=="--getrate")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
			rtc_get_rate(namingserver,rtc_name);
	}

	if((arg[2]=="--setrate")&&(argc==5)) {
		string rtc_name=arg[3];
		string rate=arg[4];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
			rtc_set_rate(namingserver,rtc_name,atoi(rate.c_str()));
	}


	if((arg[2]=="--active")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_active(namingserver,rtc_name);
	}

	if((arg[2]=="--reset")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_reset(namingserver,rtc_name);
	}

	if((arg[2]=="--deactive")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_deactive(namingserver,rtc_name);
	}

	if((arg[2]=="--allactive")&&(argc==3)) {
		rtc_all_active(namingserver);
	}

	if(arg[2]=="--save") {
		if(argc==3)		rtc_connect_save(namingserver,IP_adress,"connect");	
		if(argc==4)		rtc_connect_save(namingserver,IP_adress,arg[3]);	
	}

	if(arg[2]=="--load") {
		if(argc==3)		rtc_connect_load(namingserver,"connect");	
		if(argc==4)		rtc_connect_load(namingserver,arg[3]);	
	}

	if((arg[2]=="--alldeactive")&&(argc==3)) {
		rtc_all_deactive(namingserver);
	}

	if((arg[2]=="--alldisconnect")&&(argc==3)) {
		rtc_all_disconnect(namingserver);
	}

	if((arg[2]=="--allshow")&&(argc==3)) {
		rtc_all_show(namingserver);
	}

	if((arg[2]=="--confsetdefault")&&(argc==6)) {
		string rtc_name=arg[3];
		string key=arg[4];
		string value=arg[5];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_config_set(namingserver,rtc_name,key,value);
	}

	if((arg[2]=="--confget")&&(argc==5)) {
		string rtc_name=arg[3];
		string confset=arg[4];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_config_get(namingserver,rtc_name,confset);
	}

	if((arg[2]=="--confset")&&(argc==7)) {
		string rtc_name=arg[3];
		string confset=arg[4];
		string value=arg[5];
		string key=arg[6];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_config_set(namingserver,rtc_name,key,value,confset);
	}

	if((arg[2]=="--confsetnew")&&(argc==7)) {
		string rtc_name=arg[3];
		string confset=arg[4];
		string value=arg[5];
		string key=arg[6];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_new_config_set(namingserver,rtc_name,key,value,confset);
	}


	if((arg[2]=="--list")&&(argc==3)) {
		if(!rtclist.empty()) 
			name_show(&rtclist[0],rtclist.size());
	}

	if((arg[2]=="--state")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
			rtc_state(namingserver,rtc_name);
	}

	if((arg[2]=="--portlist")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_port_namelist(namingserver,rtc_name);
	}

	if((arg[2]=="--portinfo")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_port_info(namingserver,rtc_name);
	}

	if((arg[2]=="--connectinfo")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))
			rtc_connect_info(namingserver,rtc_name);
	}

	if((arg[2]=="--rtcinfo")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
			rtc_comp_info(namingserver,rtc_name);
	}

	if((arg[2]=="--rtc_portshow")&&(argc==4)) {
		string rtc_name=arg[3];
		if(!rtc_namecheck(rtc_name,&rtclist[0],rtclist.size()))			
			rtc_comp_info(namingserver,rtc_name);
	}

	orb->destroy();
	return 0;

}

int main(int argc, char* argv[]){

	string *arg= new string[argc];
	for (int i = 0; i < argc; ++i){
		arg[i]=argv[i];
		//	cout<<arg[i]<<endl;
	}

	/////////CORBAネームサーバの登録,IPアドレス：ポートを指定
	string IP_adress;
	if(argc==1){
		cout<<"Input IPAdress:Port(Default=127.0.0.1:9876)"<<endl;
		input_cui(IP_adress);
		if(IP_adress=="") IP_adress="127.0.0.1:9876";
		cout<<"ip="<<IP_adress<<endl<<endl;
	}
	else{
		IP_adress=arg[1];
	}

	if((argc==1)||(argc==2)){
		ConsoleMode(IP_adress);
	}
	else{
		ArgumentMode(IP_adress,arg,argc);
	}

	delete[] arg;

	exit(1);
	return 0;
}





