// -*- C -*-
/*!
 * @file  rtc_log.c
 * @brief Log Operate
 * @date  $Date$
 *
 * $Id$
 */
#include "rtc_log.h"

#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<stdarg.h>

#include	<sys/types.h>
#include	<dirent.h>
#include	<btron/tkcall.h>

#include	<errno.h>

#include	<ctype.h>
#include	<limits.h>

// եν񤭽Ф⡼
typedef enum{
	FILE_WRITE_MODE_OVERWRITE,	// 
	FILE_WRITE_MODE_POSTSCRIPT	// ɵ
}FILE_WRITE_MODE;

// ⡼
typedef enum{
	SEARCH_MODE_OLD,	//Ǹťե븡
	SEARCH_MODE_NEW		//ǿե븡
}SEARCH_MODE;

// 1֤ÿ(7*24H*60M*60S)
#define WEEK_SEC 604800

FILE	*pDFd = NULL;		// DEBUGեݥ

// ߻ѤƤե̾
char	g_currentLogFilePath[FILE_NAME_MAX_LENGTH];

LOG_MODE	g_logMode;

/** ¾ѥޥե */
ID	g_logSemaphore	= -1;

// եν
int initLogFile(LOG_MODE logMode);
// եνλ
void finishLogFile();
// եĶեκ
int deleteOverLogFile(char* fileDirPath, char* fileName, int maxNum);
// ǿեΥѥ
int getNewLogFile(char* filePath, char* fileDirPath, char* fileName, LOGFILE_MODE mode);
// եǺǤŤեκ
int deleteOldLogFile(char* fileDirPath, char* fileName);
// ե륪ץ
int openLogFile(char* filePath, FILE_WRITE_MODE mode);
// ե륯
void closeLogFile();
// եΥեå
void flushLogFile();
// եι
int updateLogFile(LOG_MODE logMode);
// ǿեθ
int searchLogFile(char* searchFileName, SEARCH_MODE mode, char* fileDirPath, char* fileName);
// ե
int deleteLogFile(char* fileName);

// ޥե
ID			createSemaphore();
// ޥեγ
int	waitSemaphore(ID id);
// ޥեֵ
int	releaseSemaphore(ID id);
// ޥեκ
int	deleteSemaphore(ID id);

// ʸIntѴǽå
int logCheckStrInt(char* buf);
// ʸ10ʿѴ
int logChangeStrToInt(char* buf, int* value);

// ϵǽ
// եѥ
// եͭ
// ե
// 󥽡ϲ
// եϲ
void initLog(LOG_MODE logMode)
{
	char deleteLogFilePath[FILE_NAME_MAX_LENGTH];
	
	// ⡼ɤν
	memset(&g_logMode, 0, sizeof(LOG_MODE));
	
	// ޥեκ
	g_logSemaphore = createSemaphore();
#ifdef WIN32
	if(g_logSemaphore == NULL)
#else
	if(g_logSemaphore == -1)
#endif
	{
		return ;
	}
	
	// եǥ쥯ȥѥ
	strcpy(g_logMode.fileDirPath , logMode.fileDirPath);
	
	// ե̾
	strcpy(g_logMode.fileName, logMode.fileName);
	
	// ե⡼
	if(logMode.mode == LOGFILE_MODE_DAY
	|| logMode.mode == LOGFILE_MODE_WEEK
	|| logMode.mode == LOGFILE_MODE_NUMBER)
	{
		g_logMode.mode = logMode.mode;
	}else{
		g_logMode.mode = LOGFILE_MODE_DAY;
	}
	
	// ե
	if(MAXFILENUM_MIN <= logMode.maxNum && logMode.maxNum <= MAXFILENUM_MAX)
	{
		g_logMode.maxNum = logMode.maxNum ;
	}else{
		g_logMode.maxNum = MAXFILENUM_DEF ;
	}
	
	// ե륫
	if(FILECOUNTER_MIN <= logMode.counter && logMode.counter <= g_logMode.maxNum)
	{
		g_logMode.counter = logMode.counter ;
	}else{
		g_logMode.counter = FILECOUNTER_DEF ;
	}
	
	// ե⡼ɤֹξ
	if(g_logMode.mode == LOGFILE_MODE_NUMBER)
	{
		// Ʊֹե
		memset( deleteLogFilePath, 0, sizeof(deleteLogFilePath));
		sprintf( deleteLogFilePath, "%s%s-%d", g_logMode.fileDirPath, g_logMode.fileName , g_logMode.counter);
		deleteLogFile(deleteLogFilePath);
	}
	
	// Ͼ
	setConsoleMode(logMode.console);
	setLogFileMode(logMode.logFile);

}

// ϵǽλ
void finishLog()
{
	// եνλ
	finishLogFile();
	// ޥե
	deleteSemaphore(g_logSemaphore);
}

// 󥽡Ͼ
void setConsoleMode(OUTPUT_MODE console)
{
	// ޥե
	if(waitSemaphore(g_logSemaphore) != 0) return ;
	
	// 󥽡ϲ
	if(console == OUTPUT_MODE_OFF || console == OUTPUT_MODE_ON)
	{
		if(g_logMode.console != console)
		{
			DEBUGOUT("Console Output %d", console);
			g_logMode.console = console ;
		}
	}else{
		g_logMode.console = OUTPUT_MODE_OFF ;
	}
	
	// ޥեֵ
	releaseSemaphore(g_logSemaphore);
}

// 󥽡Ͼּ
void getConsoleMode(OUTPUT_MODE* console)
{
	// 󥽡ϲ
	*console = g_logMode.console ;
}

// եϾ
void setLogFileMode(OUTPUT_MODE logFile)
{
	// ޥե
	if(waitSemaphore(g_logSemaphore) != 0) return ;
	
	// եϲ
	if( logFile == OUTPUT_MODE_OFF)
	{
		if( g_logMode.logFile != logFile)
		{
			DEBUGOUT("Log File Output %d", logFile);
			g_logMode.logFile = logFile ;
			finishLogFile(g_logMode);
		}
		
	}else if(logFile == OUTPUT_MODE_ON){
		if( g_logMode.logFile != logFile)
		{
			DEBUGOUT("Log File Output %d", logFile);
			g_logMode.logFile = logFile ;
			initLogFile(g_logMode);
		}
	}else{
		g_logMode.logFile = OUTPUT_MODE_OFF ;
	}
	
	// ޥեֵ
	releaseSemaphore(g_logSemaphore);
}

// եϾּ
void getLogFileMode(OUTPUT_MODE* logFile)
{
	// եϲ
	*logFile = g_logMode.logFile ;
}

// եν
int initLogFile(LOG_MODE logMode)
{
	int	er = 0;	// 顼
	int			fileNum = 0;		// ե
	char		cLogFilePath[FILE_NAME_MAX_LENGTH];	//եѥ
	
	switch(logMode.mode)
	{
		case LOGFILE_MODE_NUMBER:
		{
			// Ϥեμ
			sprintf(cLogFilePath, "%s%s-%d", logMode.fileDirPath, logMode.fileName, logMode.counter);
			
			// եĶեκ
			er = deleteOverLogFile(logMode.fileDirPath, logMode.fileName, logMode.maxNum);
			if( er != 0 )
			{
				DEBUGOUT("deleteOverLogFile ERROR code = %d", er);
				goto LBL_EXIT;
			}
			
			break ;
		}
		case LOGFILE_MODE_DAY:
		case LOGFILE_MODE_WEEK:
		{
			// ϤեΥѥ
			er = getNewLogFile(cLogFilePath, logMode.fileDirPath, logMode.fileName, logMode.mode);
			if( er < 0)
			{
				DEBUGOUT("getNewLogFile ERROR code = %d", er);
				goto LBL_EXIT;
			}
			fileNum = er ;
			er = 0 ;
			
			// եΥå
			while(fileNum > logMode.maxNum)
			{
				// ե礭
				// Ǹťե
				er = deleteOldLogFile(logMode.fileDirPath, logMode.fileName);
				if( er != 0)
				{
					DEBUGOUT("deleteOldLogFile ERROR code = %d", er);
					goto LBL_EXIT;
				}
				fileNum-- ;
			}
			
			break ;
		}
		default:
			er = -1 ;
			goto LBL_EXIT ;
	}
	
	// եΥץ
	er = openLogFile(cLogFilePath, FILE_WRITE_MODE_POSTSCRIPT);
	if( er != 0)
	{
		DEBUGOUT("openLogFile ERROR code = %d", er);
		goto LBL_EXIT;
	}
LBL_EXIT:
	return er;
}

// եνλ
void finishLogFile()
{
	// եΥ
	closeLogFile();
}

// եĶեκ
int deleteOverLogFile(char* fileDirPath, char* fileName, int maxNum)
{
	int er = 0;		// 顼
	
	int fileNameLen = 0;						// ե̾ʸĹ
	char name[FILE_NAME_MAX_LENGTH];			// ե̾Ǽ
	int fileNum;								// եֹ
	char cDeleteFilePath[FILE_NAME_MAX_LENGTH];	// եѥ

#ifndef WIN32
	DIR *dir = NULL ;			// ǥ쥯ȥꥹȥ꡼
	struct dirent *dp = NULL ;	// ǥ쥯ȥꥨȥ
#define COPY_FILE_NAME(filename, entry) strcpy(filename, entry->d_name) 
	
	// ǥ쥯ȥΥץ
	dir = opendir(fileDirPath);
	if(dir == NULL)
	{
		DEBUGOUT("opendir ERROR");
		er = -1;
		goto LBL_EXIT;
	}
	// ե̾Ĺ
	fileNameLen = (int)strlen(fileName);
	// ǥ쥯ȥΥեʬ롼
	for(dp = readdir(dir); dp != NULL ; dp = readdir(dir))
	{
#else
	HANDLE dir;							// ϥɥ
	WIN32_FIND_DATA dp;					// ǡХåե
	char path[FILE_NAME_MAX_LENGTH];	// ǥ쥯ȥѥ
#define COPY_FILE_NAME(filename, entry) strcpy(filename, entry.cFileName)
	
	// ǥ쥯ȥΥץ
	sprintf(path, "%s%s", fileDirPath, "*");
	dir = FindFirstFile( (LPCSTR)path, &dp);
	if( dir == INVALID_HANDLE_VALUE)
	{
		DEBUGOUT("FindFirstFile ERROR");
		er = -1;
		goto LBL_EXIT;
	}
	// ե̾Ĺ
	fileNameLen = (int)strlen(fileName);
	// ǥ쥯ȥΥեʬ롼
	do
	{
#endif
		// ǥ쥯ȥΥե̾
		COPY_FILE_NAME(name, dp);
		
		// ե̾Ƚ
		if(0 == memcmp(name, fileName, fileNameLen))
		{
			// ե̾ξ
			
			// ֹμФ
			er = logChangeStrToInt(&name[fileNameLen+1], &fileNum);
			if(er != 0)
			{
				DEBUGOUT("logChangeStrToInt ERROR code = %d", er);
				er = 0 ;
				continue ;
			}
			
			// ֹȽ
			if(fileNum > maxNum)
			{
				// 礭
				// ե
				sprintf(cDeleteFilePath, "%s%s", fileDirPath, name);
				er = deleteLogFile(cDeleteFilePath);
				if(er != 0)
				{
					DEBUGOUT("deleteLogFile ERROR code = %d", er);
					goto LBL_EXIT;
				}
			}
		}

#ifndef WIN32
	}
	
LBL_EXIT :

	// ǥ쥯ȥΥ
	if(dir != NULL) closedir(dir);

#else
	} while(FindNextFile(dir,&dp)) ;
	
LBL_EXIT :
	
	// ǥ쥯ȥΥ
	FindClose(dir);
#endif
	
	return er;
}

// ϤեΥѥ
// ͤե -1ξERROR
int getNewLogFile(char* filePath, char* fileDirPath, char* fileName, LOGFILE_MODE mode)
{
	int er = 0;	//顼
	int fileNum = 0;				//ե
	
	int pos = 0;	//ե̾ѥ
	
	char cLatestFileName[FILE_NAME_MAX_LENGTH];	// ǿե̾
	char cNowFileName[FILE_NAME_MAX_LENGTH];	// ե̾
	
	time_t latestFileTime = 0;	//ǿեλ֤ÿ
	struct tm latest;			//ǿեλ
	
	time_t nowTime = 0;			//߻֤ÿ
	struct tm *now;				//߻
	
	// ǿե򸡺
	er = searchLogFile(cLatestFileName, SEARCH_MODE_NEW, fileDirPath, fileName);
	if(er < 0)
	{
		DEBUGOUT("searchLogFile ERROR code = %d", er);
		return er;
	}
	fileNum = er ;
	
	// ߻
	time( &nowTime );
	
	// localtime
	now = localtime(&nowTime);
	// ե̾
	memset(cNowFileName,0 ,sizeof(cNowFileName));
	sprintf(cNowFileName,"%s-%02d%02d%02d", fileName,
		 now->tm_year -100, now->tm_mon + 1, now->tm_mday);
	
	// ե̾μ
	// ǿե̾ȸߥե̾Ƚ
	if( 0 != strcmp(cLatestFileName, cNowFileName))
	{
		// 㤦
		// ֤ͭȽ
		switch(mode)
		{
			// ñ̤ξ
			case LOGFILE_MODE_DAY:
				// ߥե̾
				sprintf(filePath, "%s%s", fileDirPath, cNowFileName);
				fileNum++ ;
				break;
				
			// ñ̤ξ
			case LOGFILE_MODE_WEEK:
			{
				// ǿեλ֤μ
				char tmp[3];
				memset(&latest, 0 , sizeof(struct tm));
				memset(tmp ,0 , sizeof(tmp));
				pos = (int)strlen(fileName) + 1;
				
				// ǯμФ
				memcpy(tmp, &cLatestFileName[pos], 2);
				er = logChangeStrToInt(tmp, &latest.tm_year);
				if(er != 0)
				{
					DEBUGOUT("logChangeStrToInt ERROR code=%d", er);
					return er;
				}
				latest.tm_year = latest.tm_year + 100 ;
				pos += 2;
				// μФ
				memcpy(tmp, &cLatestFileName[pos], 2);
				er = logChangeStrToInt(tmp, &latest.tm_mon);
				if(er != 0)
				{
					DEBUGOUT("logChangeStrToInt ERROR code=%d", er);
					return er;
				}
				latest.tm_mon = latest.tm_mon - 1;
				pos += 2;
				// μФ
				memcpy(tmp, &cLatestFileName[pos], 2);
				er = logChangeStrToInt(tmp, &latest.tm_mday);
				if(er != 0)
				{
					DEBUGOUT("logChangeStrToInt ERROR code=%d", er);
					return er;
				}
				
				// ÿμ
				latestFileTime = mktime(&latest);
				
				// ǿեλ֤ȸߤλֺʬȽ
				if(latestFileTime - nowTime <= WEEK_SEC)
				{
					// ξϲǿե̾
					sprintf(filePath, "%s%s", fileDirPath, cLatestFileName);
				}else{
					// Ķϸߥե̾
					sprintf(filePath, "%s%s", fileDirPath, cNowFileName);
					fileNum++ ;
				}
				break ;
			}	
			default:
				er = -1;
				return er ;
		}
	}else{
		// Ʊξ
		// ե̾
		sprintf(filePath, "%s%s", fileDirPath, cLatestFileName);
	}
	
	return fileNum;
}

// եǺǤŤեκ
int deleteOldLogFile(char* fileDirPath, char* fileName)
{
	int er = 0;
	char cDeleteFile[FILE_NAME_MAX_LENGTH];
	char cDeleteFilePath[FILE_NAME_MAX_LENGTH];
	
	// Ǹťե򸡺
	er  = searchLogFile(cDeleteFile, SEARCH_MODE_OLD, fileDirPath, fileName);
	if(er < 0)
	{
		DEBUGOUT("searchLogFile ERROR code = %d", er);
		goto LBL_EXIT;
	}
	// ե
	sprintf(cDeleteFilePath, "%s%s", fileDirPath, cDeleteFile);
	er = deleteLogFile(cDeleteFilePath);
	if(er != 0)
	{
		DEBUGOUT("deleteLogFile ERROR code = %d", er);
		goto LBL_EXIT;
	}
	
LBL_EXIT:
	return er ;
}

// ե륪ץ
int openLogFile(char* filePath, FILE_WRITE_MODE mode)
{
	if(pDFd != NULL) closeLogFile();
	
	// ⡼ɤȽ
	switch(mode)
	{
		// 
		case FILE_WRITE_MODE_OVERWRITE:
			pDFd = fopen( filePath, "w");
			break ;
		// ɵ
		case FILE_WRITE_MODE_POSTSCRIPT:
			pDFd = fopen( filePath, "a");
			break;
		default:
			return -1;
	}
	
	if( pDFd == NULL)
	{
		DEBUGOUT("errno%d",errno);
		return -1;
	}
	strcpy(g_currentLogFilePath, filePath);
	return 0;
}

// ե륯
void closeLogFile()
{
	if(pDFd != NULL){
		// ǥХåե륯
		if(0 != fclose( pDFd ))
		{
			DEBUGOUT("errno%d",errno);
		}
		pDFd = NULL;
	}
}

// եΥեå
void flushLogFile()
{
	if(pDFd != NULL)
	{
		if(0 != fflush( pDFd ))
		{
			DEBUGOUT("fflush errno%d",errno);
		}
	}
}

// եι
int updateLogFile(LOG_MODE logMode)
{
	char cNowFilePath[FILE_NAME_MAX_LENGTH];
	time_t nowTime = 0;
	struct tm *now;
	
	// ߻
	time( &nowTime );
	
	// localtime
	now = localtime(&nowTime);
	// ե̾
	memset(cNowFilePath,0 ,sizeof(cNowFilePath));
	sprintf(cNowFilePath,"%s%s-%02d%02d%02d", logMode.fileDirPath, logMode.fileName,
		 now->tm_year -100, now->tm_mon + 1, now->tm_mday);
	
	// ߻ѤƤեѥȸߥեѥƱǤʤ
	if( 0 != strcmp( cNowFilePath, g_currentLogFilePath))
	{
		finishLogFile();
		initLogFile(logMode);
	}
	
	return 0;
}


// ƱեοȺǿեμ
// եη fileName-YYMMDDǤ뤳
// ͤե -1ξERROR
int searchLogFile(char* searchFileName, SEARCH_MODE mode, char* fileDirPath, char* fileName)
{
	
	int	er = 0;		// 顼
	int			fileCnt = 0;
	
	int fileNameLen = 0;				// ե̾ʸĹ
	char name[FILE_NAME_MAX_LENGTH];	// ե̾Ǽ
	
	int targetFileDate = 0;		// Ūե
	int currentFileDate = 0;	// ߥե
	
	// ǥ쥯ȥΥץ
#ifndef WIN32
	DIR *dir = NULL ;			// ǥ쥯ȥꥹȥ꡼
	struct dirent *dp = NULL ;	// ǥ쥯ȥꥨȥ
#define COPY_FILE_NAME(filename, entry) strcpy(filename, entry->d_name) 

	dir = opendir(fileDirPath);
	if(dir == NULL)
	{
		DEBUGOUT("opendir ERROR");
		er = -1;
		goto LBL_EXIT;
	}
	// ե̾Ĺ
	fileNameLen = (int)strlen(fileName);
	// ǥ쥯ȥΥեʬ롼
	for(dp = readdir(dir); dp != NULL ; dp = readdir(dir))
	{
#else
	HANDLE dir;				// ϥɥ
	WIN32_FIND_DATA dp;		// ǡХåե
	char path[FILE_NAME_MAX_LENGTH];	// ǥ쥯ȥѥ
#define COPY_FILE_NAME(filename, entry) strcpy(filename, entry.cFileName)

	sprintf(path, "%s%s", fileDirPath, "*");
	dir = FindFirstFile( (LPCSTR)path, &dp);
	if( dir == INVALID_HANDLE_VALUE)
	{
		DEBUGOUT("FindFirstFile ERROR");
		er = -1;
		goto LBL_EXIT;
	}
	// ե̾Ĺ
	fileNameLen = (int)strlen(fileName);
	// ǥ쥯ȥΥեʬ롼
	do
	{
#endif
		// ǥ쥯ȥΥե̾
		COPY_FILE_NAME( name, dp);
		
		// ե̾Ƚ
		if(0 == memcmp(name, fileName, fileNameLen))
		{
			// ե̾ξ
			// ե䤹
			fileCnt++ ;
			// ǯμФ
			er = logChangeStrToInt(&name[fileNameLen+1], &currentFileDate);
			if(er != 0)
			{
				DEBUGOUT("logChangeStrToInt ERROR code=%d", er);
				er = 0;
				continue ;
			}
			// ǽ˸줿եξ
			if(targetFileDate == 0)
			{
				// 0ξ(ޤꤵƤʤ)
				// ŪեǯŪե̾
				targetFileDate = currentFileDate ;
				COPY_FILE_NAME(searchFileName, dp);
				continue ;
			}
			// ⡼ɤȽ
			if(mode == SEARCH_MODE_OLD){
				// Ǹťեξ
				if( currentFileDate < targetFileDate )
				{
					targetFileDate = currentFileDate ;
					COPY_FILE_NAME(searchFileName, dp);
				}
			}else if(mode == SEARCH_MODE_NEW){
				// ǿեξ
				if( currentFileDate > targetFileDate)
				{
					targetFileDate = currentFileDate ;
					COPY_FILE_NAME(searchFileName, dp);
				}
			}
		}
#ifndef WIN32
	}
	er = fileCnt ;
	
LBL_EXIT :

	// ǥ쥯ȥΥ
	if(dir != NULL) closedir(dir);
	
#else
	} while(FindNextFile(dir,&dp)) ;
	er = fileCnt ;
	
LBL_EXIT :
	
	// ǥ쥯ȥΥ
	FindClose(dir);
#endif
	
	// Ʊե̾οֵ
	return er ;

}

// ե
int deleteLogFile(char* filePath)
{
	if(-1 == remove(filePath))
	{
		return -1;
	}
	return 0;
}


// ǥХåϤԤ
void outputLog(const char *msg, const char *file, const int line, const char *format, ...)
{
	// ޥե
	if(waitSemaphore(g_logSemaphore) != 0) return ;
	
	// 󥽡
	if(g_logMode.console)
	{
		va_list		args;

		if(msg != NULL) printf("%s", msg);

		va_start(args, format);
		vprintf(format, args);
		va_end(args);

		printf("\n");

		if(file != NULL && line != 0) printf("  [FILE]%s[LINE]%d\n", file, line);
		
	}
	
	// ե
	if(g_logMode.logFile)
	{
		if(g_logMode.mode == LOGFILE_MODE_DAY || g_logMode.mode == LOGFILE_MODE_WEEK)
		{
			if(0 != updateLogFile(g_logMode))
			{
				DEBUGOUT("updateLogFile Error");
			}
		}
		
		if(pDFd != NULL)
		{
			va_list		args;
			
			if(msg != NULL) fprintf(pDFd, "%s", msg);
			
			va_start(args, format);
			vfprintf(pDFd, format, args);
			va_end(args);
			
			fprintf(pDFd, "\n");
			if(file != NULL && line != 0) fprintf(pDFd, "  [FILE]%s[LINE]%d\n", file, line);
#ifdef __T_KERNEL__
			flushLogFile();
#endif
		}
	}
	// ޥեֵ
	releaseSemaphore(g_logSemaphore);
}

// ޥե
ID		createSemaphore()
{
	ID semaphore = -1;
	T_CSEM	csem;
	
	memset( &csem, 0, sizeof(T_CSEM));
	csem.sematr  = TA_TFIFO ;
	csem.isemcnt = 1;
	csem.maxsem  = 1;
	semaphore = tk_cre_sem(&csem);
	if( semaphore < E_OK)
	{
		DEBUGOUT("tk_cre_sem ERROR code=%d", semaphore);
		return -1;
	}
	return semaphore ;
}

// ޥեγ
int	waitSemaphore(ID id)
{
	ER er = E_OK;
	
	er = tk_wai_sem( id, 1, TMO_FEVR);
	if(er < E_OK)
	{
		DEBUGOUT("tk_wai_sem ERROR code=%d", er);
		return -1;
	}
	return 0;
}

// ޥեֵ
int	releaseSemaphore(ID id)
{
	ER er = E_OK ;
	
	er = tk_sig_sem( id, 1);
	if(er < E_OK)
	{
		DEBUGOUT("tk_sig_sem ERROR code=%d", er);
		return -1;
	}
	return 0;
}

// ޥեκ
int	deleteSemaphore(ID id)
{
	ER er = E_OK;
	
	er = tk_del_sem(id);
	if(er < E_OK)
	{
		DEBUGOUT("tk_del_sem ERROR code=%d",id);
		return -1;
	}
	return 0;
}

// ʸIntͤå
int logCheckStrInt(char* buf)
{
	char*	pBuf = buf;
	char	check = 0;	//åʸ
	
	// '-'ޤ'+'ξϼʸ
	if( *pBuf == '-' || *pBuf == '+')
	{
		pBuf++ ;
	}
	
	// ʸˤʤޤǥ롼
	while( *pBuf != 0)
	{
		check = *pBuf ;
		// ǤϤʤ票顼
		if( isdigit(check) == 0)
		{
			return -1;
		}
		// ʸ
		pBuf++;
	}
	
	return 0;
}

// ʸ10ʿѴ
int logChangeStrToInt(char* buf, int* value)
{
	int er = 0;
	int tmp;
	
	// ʸȽ
	er = logCheckStrInt(buf);
	if( er != 0)
	{
		DEBUGOUT("checkStrInt ERROR code = %d", er);
		goto LBL_EXIT;
	}
	
	// ʸ10ʿѴ
	errno = 0;
	tmp = strtol((const char*)buf, NULL, 10);
	if((errno == ERANGE && (tmp == LONG_MAX || tmp == LONG_MIN))
		|| (errno != 0 && tmp == 0))
	{
		DEBUGOUT("strtol ERROR");
		er = -1 ;
		goto LBL_EXIT;
	}
	*value = tmp ;
	
LBL_EXIT:
	return er;
}
