/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.wsdl;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.util.HashMap;
import org.apache.axis.enum.Scope;
import org.apache.axis.utils.DefaultAuthenticator;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class Wsdl2javaAntTask
extends Task {
    private boolean verbose = false;
    private boolean server = false;
    private boolean skeletonDeploy = false;
    private boolean testCase = false;
    private boolean noImports = false;
    private boolean all = false;
    private boolean helperGen = false;
    private String factory = null;
    private HashMap namespaceMap = new HashMap();
    private String output = ".";
    private String deployScope = "";
    private String url = "";
    private String tm = "1.1";
    private long timeout = 45000L;
    private boolean printStackTraceOnFailure = true;
    private boolean failOnNetworkErrors = false;

    protected void validate() throws BuildException {
        if (this.url == null || this.url.length() == 0) {
            throw new BuildException("No url specified");
        }
        if (this.timeout < -1L) {
            throw new BuildException("negative timeout supplied");
        }
        File file = new File(this.output);
        if (!file.isDirectory() || !file.exists()) {
            throw new BuildException("output directory is not valid");
        }
    }

    public void traceParams(int n) {
        this.log("Running Wsdl2javaAntTask with parameters:", n);
        this.log("\tverbose:" + this.verbose, n);
        this.log("\tserver-side:" + this.server, n);
        this.log("\tskeletonDeploy:" + this.skeletonDeploy, n);
        this.log("\thelperGen:" + this.helperGen, n);
        this.log("\tfactory:" + this.factory, n);
        this.log("\ttestCase:" + this.testCase, n);
        this.log("\tnoImports:" + this.noImports, n);
        this.log("\tNStoPkg:" + this.namespaceMap, n);
        this.log("\toutput:" + this.output, n);
        this.log("\tdeployScope:" + this.deployScope, n);
        this.log("\tURL:" + this.url, n);
        this.log("\tall:" + this.all, n);
        this.log("\ttypeMappingVersion:" + this.tm, n);
        this.log("\ttimeout:" + this.timeout, n);
        this.log("\tfailOnNetworkErrors:" + this.failOnNetworkErrors, n);
        this.log("\tprintStackTraceOnFailure:" + this.printStackTraceOnFailure, n);
    }

    public void execute() throws BuildException {
        this.traceParams(3);
        this.validate();
        try {
            Emitter emitter = new Emitter();
            Scope scope = Scope.getScope((String)this.deployScope, null);
            if (scope != null) {
                emitter.setScope(scope);
            } else if (!"none".equalsIgnoreCase(this.deployScope)) {
                this.log("Unrecognized scope:  " + this.deployScope + ".  Ignoring it.", 3);
            }
            if (!this.namespaceMap.isEmpty()) {
                emitter.setNamespaceMap(this.namespaceMap);
            }
            emitter.setTestCaseWanted(this.testCase);
            emitter.setHelperWanted(this.helperGen);
            if (this.factory != null) {
                emitter.setFactory(this.factory);
            }
            emitter.setImports(!this.noImports);
            emitter.setAllWanted(this.all);
            emitter.setOutputDir(this.output);
            emitter.setServerSide(this.server);
            emitter.setSkeletonWanted(this.skeletonDeploy);
            emitter.setVerbose(this.verbose);
            emitter.setTypeMappingVersion(this.tm);
            emitter.setNStoPkg(((ProjectComponent)this).project.resolveFile("NStoPkg.properties"));
            emitter.setTimeout(this.timeout);
            Authenticator.setDefault((Authenticator)new DefaultAuthenticator(null, null));
            this.log("WSDL2Java " + this.url, 2);
            try {
                emitter.run(this.url);
            }
            catch (Throwable throwable) {
                if (this.url.startsWith("http://")) {
                    if (!this.failOnNetworkErrors) {
                        this.log(throwable.toString(), 1);
                        return;
                    }
                    throw new BuildException("Could not build " + this.url, throwable);
                }
                throw throwable;
            }
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Throwable throwable) {
            if (this.printStackTraceOnFailure) {
                this.traceParams(2);
                throwable.printStackTrace();
            }
            throw new BuildException("Error while processing WSDL in Wsdl2javaAntTask for " + this.url, throwable);
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setServerSide(boolean bl) {
        this.server = bl;
    }

    public void setSkeletonDeploy(boolean bl) {
        this.skeletonDeploy = bl;
    }

    public void setTestCase(boolean bl) {
        this.testCase = bl;
    }

    public void setHelperGen(boolean bl) {
        this.helperGen = bl;
    }

    public void setFactory(String string) {
        this.factory = string;
    }

    public void setNoImports(boolean bl) {
        this.noImports = bl;
    }

    public void setOutput(File file) throws BuildException {
        try {
            this.output = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    public void setDeployScope(String string) {
        this.deployScope = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setAll(boolean bl) {
        this.all = bl;
    }

    public void setTypeMappingVersion(String string) {
        this.tm = string;
    }

    public void setTimeout(String string) {
        try {
            this.timeout = new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log("Could not convert " + string + " to a number", 1);
        }
    }

    public Mapping createMapping() {
        Mapping mapping = new Mapping();
        return mapping;
    }

    public class Mapping {
        private String namespace;
        private String packageName;

        public void setNamespace(String string) {
            this.namespace = string;
            if (this.namespace != null && this.packageName != null) {
                Wsdl2javaAntTask.this.namespaceMap.put(this.namespace, this.packageName);
            }
        }

        public void setPackage(String string) {
            this.packageName = string;
            if (this.namespace != null && this.packageName != null) {
                Wsdl2javaAntTask.this.namespaceMap.put(this.namespace, this.packageName);
            }
        }
    }
}

