/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAPOperationSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPOperation sOAPOperation = (SOAPOperation)extensibilityElement;
        if (sOAPOperation != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap/", "operation", definition);
            printWriter.print("      <" + string);
            DOMUtils.printAttribute("soapAction", sOAPOperation.getSoapActionURI(), printWriter);
            DOMUtils.printAttribute("style", sOAPOperation.getStyle(), printWriter);
            Boolean bl = sOAPOperation.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPOperation sOAPOperation = (SOAPOperation)extensionRegistry.createExtension(clazz, qName);
        String string = DOMUtils.getAttribute(element, "soapAction");
        String string2 = DOMUtils.getAttribute(element, "style");
        String string3 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string != null) {
            sOAPOperation.setSoapActionURI(string);
        }
        if (string2 != null) {
            sOAPOperation.setStyle(string2);
        }
        if (string3 != null) {
            sOAPOperation.setRequired(new Boolean(string3));
        }
        return sOAPOperation;
    }
}

