/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import rumblejp.common.beans.BattleResult;
import rumblejp.common.beans.RobotResult;
import rumblejp.common.beans.RobotScore;

public class DuelScore
extends RobotScore
implements Serializable {
    private int[] battleResult = new int[3];
    private int[] roundResult = new int[3];
    private int totalScore;
    private int attackScore;
    private int ramScore;
    private int moveScore;
    private int pliableScore;
    private int duelScore;

    public void clear() {
        int i = 0;
        while (i < 3) {
            this.battleResult[i] = 0;
            this.roundResult[i] = 0;
            ++i;
        }
        this.totalScore = 0;
        this.attackScore = 0;
        this.ramScore = 0;
        this.moveScore = 0;
        this.pliableScore = 0;
        this.duelScore = 0;
    }

    public void createScore(int robotId, Collection result) {
        this.clear();
        if (result == null || result.size() == 0) {
            return;
        }
        Iterator i = result.iterator();
        while (i.hasNext()) {
            RobotResult enemy;
            RobotResult my;
            BattleResult br = (BattleResult)i.next();
            RobotResult[] robotResults = br.getRobotResults();
            if (robotResults.length != 2) continue;
            if (robotResults[0].getRobotId() == robotId) {
                my = robotResults[0];
                enemy = robotResults[1];
            } else {
                my = robotResults[1];
                enemy = robotResults[0];
            }
            int rounds = br.getRounds();
            int draw = my.getFirsts() + enemy.getFirsts() - rounds;
            int win = rounds + enemy.getSeconds() - my.getFirsts() - my.getSeconds();
            int lose = rounds + my.getSeconds() - enemy.getFirsts() - enemy.getSeconds();
            this.roundResult[0] = this.roundResult[0] + win;
            this.roundResult[1] = this.roundResult[1] + lose;
            this.roundResult[2] = this.roundResult[2] + draw;
            my.setFirsts(win);
            my.setSeconds(lose);
            my.setThirds(draw);
            enemy.setFirsts(lose);
            enemy.setSeconds(win);
            enemy.setThirds(draw);
            if (my.getScore() > enemy.getScore()) {
                this.battleResult[0] = this.battleResult[0] + 1;
            } else if (my.getScore() < enemy.getScore()) {
                this.battleResult[1] = this.battleResult[1] + 1;
            } else {
                this.battleResult[2] = this.battleResult[2] + 1;
            }
            this.totalScore += my.getScore();
            this.attackScore += my.getBulletDamage() + my.getBulletDamageBonus();
            this.ramScore += my.getRamDamage() + my.getRamDamageBonus();
            this.moveScore += enemy.getBulletDamage() + enemy.getRamDamage();
        }
        this.profile();
    }

    private void profile() {
        int totalRounds = this.getTotalRounds();
        int totalBattles = this.battleResult[0] + this.battleResult[1] + this.battleResult[2];
        if (totalRounds > 0 && totalBattles > 0) {
            this.totalScore = 300 * this.totalScore / totalRounds / 150;
            this.attackScore = 300 * this.attackScore / totalRounds / 100;
            this.moveScore = 300 * (100 - this.moveScore / totalRounds) / 80;
            this.ramScore = 300 * this.ramScore / totalRounds / 20;
            this.pliableScore = 300 * this.battleResult[0] / totalBattles;
            this.duelScore = (300 * this.roundResult[0] / totalRounds + this.totalScore * 2 + this.pliableScore * 3) / 5;
        }
        this.totalScore = this.limit(this.totalScore);
        this.attackScore = this.limit(this.attackScore);
        this.moveScore = this.limit(this.moveScore);
        this.ramScore = this.limit(this.ramScore);
        this.duelScore = this.limit(this.duelScore);
        this.pliableScore = this.limit(this.pliableScore);
    }

    public int getTotalRounds() {
        int totalRounds = 0;
        int i = 0;
        while (i < this.roundResult.length) {
            totalRounds += this.roundResult[i];
            ++i;
        }
        return totalRounds;
    }

    public int getWin() {
        return this.battleResult[0];
    }

    public int getLose() {
        return this.battleResult[1];
    }

    public int getDraw() {
        return this.battleResult[2];
    }

    public int[] getBattleResult() {
        return this.battleResult;
    }

    public int[] getRoundResult() {
        return this.roundResult;
    }

    public int getTotalScore() {
        return this.totalScore;
    }

    public int getAttackScore() {
        return this.attackScore;
    }

    public int getMoveScore() {
        return this.moveScore;
    }

    public int getRamScore() {
        return this.ramScore;
    }

    public int getPliableScore() {
        return this.pliableScore;
    }

    public int getDuelScore() {
        return this.duelScore;
    }

    public void setBattleResult(int[] battleResult) {
        this.battleResult = battleResult;
    }

    public void setRoundResult(int[] roundResult) {
        this.roundResult = roundResult;
    }

    public void setTotalScore(int totalScore) {
        this.totalScore = totalScore;
    }

    public void setAttackScore(int attackScore) {
        this.attackScore = attackScore;
    }

    public void setMoveScore(int moveScore) {
        this.moveScore = moveScore;
    }

    public void setRamScore(int ramScore) {
        this.ramScore = ramScore;
    }

    public void setPliableScore(int pliableScore) {
        this.pliableScore = pliableScore;
    }

    public void setDuelScore(int duelScore) {
        this.duelScore = duelScore;
    }

    public String getBattleResultString() {
        return this.toString(this.battleResult);
    }

    public String getRoundResultString() {
        return this.toString(this.roundResult);
    }
}

