package robocode;

/**
 * This event is sent to {@link robocode.Robot#onBulletHitBullet onBulletHitBullet}
 * when one of your bullets hits another bullet.
 */
public class BulletHitBulletEvent extends Event {
	private Bullet bullet;
	private Bullet hitBullet;
/**
 * Called by the game to create a new BulletHitEvent.
 */
public BulletHitBulletEvent(Bullet bullet, Bullet hitBullet) {
	super();
	this.bullet = bullet;
	this.hitBullet = hitBullet;
}
/**
 * Returns the Bullet.
 * @return Bullet
 */
public Bullet getBullet() {
	return bullet;
}
/**
 * Returns the Bullet that was hit.
 * @return Bullet
 */
public Bullet getHitBullet() {
	return hitBullet;
}
}
