names=pathmap
visibility=public 
kind=added

--- pathmap(spec = nil){ ... } -> String

与えられた書式指定文字列に応じてパス(自身)を変換します。

与えられた書式指定文字列は変換の詳細を制御します。
指定できる書式指定文字列は以下の通りです。

: %p
  完全なパスを表します。
: %f
  拡張子付きのファイル名を表します。ディレクトリ名は含まれません。
: %n
  拡張子なしのファイル名を表します。
: %d
  パスに含まれるディレクトリのリストを表します。
: %x
  パスに含まれるファイルの拡張子を表します。拡張子が無い場合は空文字列を表します。
: %X
  拡張子以外すべてを表します。
: %s
  定義されていれば、代替のファイルセパレータを表します。
  定義されてい無い場合は、標準のファイルセパレータを表します。
: %%
  パーセント自身を表します。


%d は数値のプレフィクスを取ることができます。

例:
   'a/b/c/d/file.txt'.pathmap("%2d")   => 'a/b'
   'a/b/c/d/file.txt'.pathmap("%-2d")  => 'c/d'

また、%d, %p, %f, %n, %x, %X には単純な文字列置換を行うための
置換パターンを表すパラメータを指定することが出来ます。
パターンと置換文字列はコンマで区切り全体を中括弧でくくります。
置換指定は、% と指示子の間に置きます。(例: "%{old,new}d")
複数の置換を行う場合はパターンをセミコロンで区切ってください。
(例: "%{old,new;src,bin}d")

正規表現や後方参照をパターンとして使用することがあるかもしれません。
中括弧、コンマ、セミコロンはパターンと置換文字列に使用しないでください。

例:
    "src/org/onestepback/proj/A.java".pathmap("%{^src,bin}X.class")
    #=> "bin/org/onestepback/proj/A.class"

置換文字列に '*' を指定した場合は、置換文字列を計算するためにブロックを評価します。

例:

   "/path/to/file.TXT".pathmap("%X%{.*,*}x") { |ext| ext.downcase }
   #=> "/path/to/file.txt"


